/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.NlsString;
import org.apache.flink.annotation.Internal;

@Internal
public class SqlSet
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("SET", SqlKind.OTHER);
    @Nullable
    private final SqlNode key;
    @Nullable
    private final SqlNode value;

    public SqlSet(SqlParserPos pos, SqlNode key, SqlNode value) {
        super(pos);
        this.key = Objects.requireNonNull(key, "key cannot be null");
        this.value = Objects.requireNonNull(value, "value cannot be null");
    }

    public SqlSet(SqlParserPos pos) {
        super(pos);
        this.key = null;
        this.value = null;
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.key, (Object)this.value);
    }

    @Nullable
    public SqlNode getKey() {
        return this.key;
    }

    @Nullable
    public SqlNode getValue() {
        return this.value;
    }

    @Nullable
    public String getKeyString() {
        if (this.key == null) {
            return null;
        }
        return ((NlsString)SqlLiteral.value((SqlNode)this.key)).getValue();
    }

    @Nullable
    public String getValueString() {
        if (this.value == null) {
            return null;
        }
        return ((NlsString)SqlLiteral.value((SqlNode)this.value)).getValue();
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("SET");
        if (this.key != null && this.value != null) {
            this.key.unparse(writer, leftPrec, rightPrec);
            writer.keyword("=");
            this.value.unparse(writer, leftPrec, rightPrec);
        }
    }
}

