/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ExtendedSqlNode;
import org.apache.flink.sql.parser.SqlConstraintValidator;
import org.apache.flink.sql.parser.SqlUnparseUtils;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.sql.parser.ddl.SqlDistribution;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.sql.parser.error.SqlValidateException;

public class SqlReplaceTableAs
extends SqlCreateTable
implements ExtendedSqlNode {
    public static final SqlSpecialOperator REPLACE_OPERATOR = new SqlSpecialOperator("REPLACE TABLE AS", SqlKind.OTHER_DDL);
    public static final SqlSpecialOperator CREATE_OR_REPLACE_OPERATOR = new SqlSpecialOperator("CREATE OR REPLACE TABLE AS", SqlKind.OTHER_DDL);
    private final boolean isCreateOrReplace;
    private final SqlNode asQuery;

    public SqlReplaceTableAs(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList columnList, List<SqlTableConstraint> tableConstraints, SqlNodeList propertyList, SqlDistribution distribution, SqlNodeList partitionKeyList, @Nullable SqlWatermark watermark, @Nullable SqlCharStringLiteral comment, SqlNode asQuery, boolean isTemporary, boolean ifNotExists, boolean isCreateOrReplace) {
        super(isCreateOrReplace ? CREATE_OR_REPLACE_OPERATOR : REPLACE_OPERATOR, pos, tableName, columnList, tableConstraints, propertyList, distribution, partitionKeyList, watermark, comment, isTemporary, ifNotExists, true);
        this.asQuery = asQuery;
        this.isCreateOrReplace = isCreateOrReplace;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.getTableName(), (Object)this.getColumnList(), (Object)new SqlNodeList(this.getTableConstraints(), SqlParserPos.ZERO), (Object)this.getPropertyList(), (Object)this.getPartitionKeyList(), (Object)((SqlNode)this.getWatermark().get()), (Object)((SqlNode)this.getComment().get()), (Object)this.asQuery, (Object[])new SqlNode[0]);
    }

    @Override
    public void validate() throws SqlValidateException {
        String errorMsg;
        if (!this.isSchemaWithColumnsIdentifiersOnly()) {
            SqlConstraintValidator.validateAndChangeColumnNullability(this.getTableConstraints(), this.getColumnList());
        }
        String string = errorMsg = this.isCreateOrReplace ? "CREATE OR REPLACE TABLE AS SELECT" : "REPLACE TABLE AS SELECT";
        if (this.isIfNotExists()) {
            throw new SqlValidateException(this.getParserPosition(), errorMsg + " syntax does not support IF NOT EXISTS statements yet.");
        }
        if (this.isTemporary()) {
            throw new SqlValidateException(this.getParserPosition(), errorMsg + " syntax does not support temporary table yet.");
        }
    }

    public SqlNode getAsQuery() {
        return this.asQuery;
    }

    public boolean isCreateOrReplace() {
        return this.isCreateOrReplace;
    }

    public boolean isSchemaWithColumnsIdentifiersOnly() {
        SqlNodeList columnList = this.getColumnList();
        return !columnList.isEmpty() && columnList.get(0) instanceof SqlIdentifier;
    }

    @Override
    public List<SqlTableConstraint> getFullConstraints() {
        return SqlConstraintValidator.getFullConstraints(this.getTableConstraints(), this.getColumnList());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlNodeList propertyList;
        if (this.isCreateOrReplace) {
            writer.keyword("CREATE OR");
        }
        writer.keyword("REPLACE TABLE");
        this.getTableName().unparse(writer, leftPrec, rightPrec);
        SqlCharStringLiteral comment = this.getComment().orElse(null);
        if (comment != null) {
            writer.newlineAndIndent();
            writer.keyword("COMMENT");
            comment.unparse(writer, leftPrec, rightPrec);
        }
        if (!(propertyList = this.getPropertyList()).isEmpty()) {
            writer.keyword("WITH");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : propertyList) {
                SqlUnparseUtils.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
        writer.newlineAndIndent();
        writer.keyword("AS");
        writer.newlineAndIndent();
        this.asQuery.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public String[] fullTableName() {
        return (String[])this.getTableName().names.toArray((Object[])new String[0]);
    }
}

