/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.SqlUnparseUtils;
import org.apache.flink.sql.parser.ddl.SqlAlterMaterializedTable;

public class SqlAlterMaterializedTableReset
extends SqlAlterMaterializedTable {
    private final SqlNodeList propertyKeyList;

    public SqlAlterMaterializedTableReset(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList propertyKeyList) {
        super(pos, tableName);
        this.propertyKeyList = propertyKeyList;
    }

    public SqlNodeList getPropertyKeyList() {
        return this.propertyKeyList;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.getTableName(), (Object)this.propertyKeyList);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("RESET");
        SqlWriter.Frame withFrame = writer.startList("(", ")");
        for (SqlNode propertyKey : this.propertyKeyList) {
            SqlUnparseUtils.printIndent(writer);
            propertyKey.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.endList(withFrame);
    }
}

