/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.SqlPartitionUtils;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;

public class SqlAddPartitions
extends SqlAlterTable {
    private final boolean ifPartitionNotExists;
    private final List<SqlNodeList> partSpecs;
    private final List<SqlNodeList> partProps;

    public SqlAddPartitions(SqlParserPos pos, SqlIdentifier tableName, boolean ifPartitionNotExists, List<SqlNodeList> partSpecs, List<SqlNodeList> partProps) {
        super(pos, tableName, false);
        this.ifPartitionNotExists = ifPartitionNotExists;
        this.partSpecs = partSpecs;
        this.partProps = partProps;
    }

    public boolean ifPartitionNotExists() {
        return this.ifPartitionNotExists;
    }

    public List<SqlNodeList> getPartSpecs() {
        return this.partSpecs;
    }

    public LinkedHashMap<String, String> getPartitionKVs(int i) {
        return SqlPartitionUtils.getPartitionKVs(this.getPartSpecs().get(i));
    }

    public List<SqlNodeList> getPartProps() {
        return this.partProps;
    }

    @Nonnull
    public List<SqlNode> getOperandList() {
        ArrayList<SqlNode> operands = new ArrayList<SqlNode>();
        operands.add((SqlNode)this.tableIdentifier);
        operands.addAll(this.partSpecs);
        operands.addAll(this.partProps);
        return operands;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.newlineAndIndent();
        writer.keyword("ADD");
        if (this.ifPartitionNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        int opLeftPrec = this.getOperator().getLeftPrec();
        int opRightPrec = this.getOperator().getRightPrec();
        for (int i = 0; i < this.partSpecs.size(); ++i) {
            writer.newlineAndIndent();
            SqlNodeList partSpec = this.partSpecs.get(i);
            SqlNodeList partProp = this.partProps.get(i);
            writer.keyword("PARTITION");
            partSpec.unparse(writer, opLeftPrec, opRightPrec);
            if (partProp == null) continue;
            writer.keyword("WITH");
            partProp.unparse(writer, opLeftPrec, opRightPrec);
        }
    }

    public static class AlterTableAddPartitionContext {
        public boolean ifNotExists;
        public List<SqlNodeList> partSpecs;
        public List<SqlNodeList> partProps;
    }
}

