/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.NlsString;

public class SqlPartitionSpecProperty
extends SqlCall {
    protected static final SqlOperator OPERATOR = new SqlSpecialOperator("Pair", SqlKind.OTHER);
    private final SqlIdentifier key;
    @Nullable
    private final SqlNode value;

    public SqlPartitionSpecProperty(SqlIdentifier key, @Nullable SqlNode value, SqlParserPos pos) {
        super(pos);
        this.key = Objects.requireNonNull(key, "Pair key is missing");
        this.value = value;
    }

    public SqlIdentifier getKey() {
        return this.key;
    }

    @Nullable
    public SqlNode getValue() {
        return this.value;
    }

    public String getKeyString() {
        return this.key.toString();
    }

    @Nullable
    public String getValueString() {
        return this.value != null ? ((NlsString)SqlLiteral.value((SqlNode)this.value)).getValue() : null;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        if (this.value != null) {
            return ImmutableNullableList.of((Object)this.key, (Object)this.value);
        }
        return ImmutableNullableList.of((Object)this.key);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.key.unparse(writer, leftPrec, rightPrec);
        if (this.value != null) {
            writer.keyword("=");
            this.value.unparse(writer, leftPrec, rightPrec);
        }
    }
}

