/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Map;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.jobmaster.slotpool.PendingRequest;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.scheduler.loading.LoadingWeight;

public interface RequestSlotMatchingStrategy {
    public Collection<RequestSlotMatch> matchRequestsAndSlots(Collection<? extends PhysicalSlot> var1, Collection<PendingRequest> var2, Map<ResourceID, LoadingWeight> var3);

    public static final class RequestSlotMatch {
        private final PendingRequest pendingRequest;
        private final PhysicalSlot matchedSlot;

        private RequestSlotMatch(PendingRequest pendingRequest, PhysicalSlot matchedSlot) {
            this.pendingRequest = pendingRequest;
            this.matchedSlot = matchedSlot;
        }

        PhysicalSlot getSlot() {
            return this.matchedSlot;
        }

        PendingRequest getPendingRequest() {
            return this.pendingRequest;
        }

        static RequestSlotMatch createFor(PendingRequest pendingRequest, PhysicalSlot newSlot) {
            return new RequestSlotMatch(pendingRequest, newSlot);
        }
    }
}

