/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.util.Preconditions;

public class InputOutputFormatContainer {
    private final FormatUserCodeTable formats;
    private final Configuration parameters;
    private final ClassLoader userCodeClassLoader;

    public InputOutputFormatContainer(ClassLoader classLoader) {
        this.formats = new FormatUserCodeTable();
        this.parameters = new Configuration();
        this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
    }

    public InputOutputFormatContainer(TaskConfig config, ClassLoader classLoader) {
        UserCodeWrapper wrapper;
        Preconditions.checkNotNull((Object)config);
        this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
        try {
            wrapper = config.getStubWrapper(classLoader);
        }
        catch (Throwable t) {
            throw new RuntimeException("Deserializing the input/output formats failed: " + t.getMessage(), t);
        }
        if (wrapper == null) {
            throw new RuntimeException("No InputFormat or OutputFormat present in task configuration.");
        }
        try {
            this.formats = (FormatUserCodeTable)wrapper.getUserCodeObject(FormatUserCodeTable.class, classLoader);
        }
        catch (Throwable t) {
            throw new RuntimeException("Instantiating the input/output formats failed: " + t.getMessage(), t);
        }
        this.parameters = new Configuration();
        Configuration stubParameters = config.getStubParameters();
        for (String key : stubParameters.keySet()) {
            this.parameters.setString(key, stubParameters.getString(key, null));
        }
    }

    public Map<OperatorID, UserCodeWrapper<? extends InputFormat<?, ?>>> getInputFormats() {
        return this.formats.getInputFormats();
    }

    public Map<OperatorID, UserCodeWrapper<? extends OutputFormat<?>>> getOutputFormats() {
        return this.formats.getOutputFormats();
    }

    public <OT, T extends InputSplit> Pair<OperatorID, InputFormat<OT, T>> getUniqueInputFormat() {
        Map<OperatorID, UserCodeWrapper<InputFormat<?, ?>>> inputFormats = this.formats.getInputFormats();
        Preconditions.checkState((inputFormats.size() == 1 ? 1 : 0) != 0);
        Map.Entry<OperatorID, UserCodeWrapper<InputFormat<?, ?>>> entry = inputFormats.entrySet().iterator().next();
        return new ImmutablePair((Object)entry.getKey(), (Object)((InputFormat)entry.getValue().getUserCodeObject(InputFormat.class, this.userCodeClassLoader)));
    }

    public <IT> Pair<OperatorID, OutputFormat<IT>> getUniqueOutputFormat() {
        Map<OperatorID, UserCodeWrapper<OutputFormat<?>>> outputFormats = this.formats.getOutputFormats();
        Preconditions.checkState((outputFormats.size() == 1 ? 1 : 0) != 0);
        Map.Entry<OperatorID, UserCodeWrapper<OutputFormat<?>>> entry = outputFormats.entrySet().iterator().next();
        return new ImmutablePair((Object)entry.getKey(), (Object)((OutputFormat)entry.getValue().getUserCodeObject(OutputFormat.class, this.userCodeClassLoader)));
    }

    public InputOutputFormatContainer addInputFormat(OperatorID operatorId, InputFormat<?, ?> inputFormat) {
        this.formats.addInputFormat(operatorId, (UserCodeWrapper<? extends InputFormat<?, ?>>)new UserCodeObjectWrapper(inputFormat));
        return this;
    }

    public InputOutputFormatContainer addInputFormat(OperatorID operatorId, UserCodeWrapper<? extends InputFormat<?, ?>> wrapper) {
        this.formats.addInputFormat(operatorId, wrapper);
        return this;
    }

    public InputOutputFormatContainer addOutputFormat(OperatorID operatorId, OutputFormat<?> outputFormat) {
        this.formats.addOutputFormat(operatorId, (UserCodeWrapper<? extends OutputFormat<?>>)new UserCodeObjectWrapper(outputFormat));
        return this;
    }

    public InputOutputFormatContainer addOutputFormat(OperatorID operatorId, UserCodeWrapper<? extends OutputFormat<?>> wrapper) {
        this.formats.addOutputFormat(operatorId, wrapper);
        return this;
    }

    public Configuration getParameters(OperatorID operatorId) {
        return new DelegatingConfiguration(this.parameters, this.getParamKeyPrefix(operatorId));
    }

    public InputOutputFormatContainer addParameters(OperatorID operatorId, Configuration parameters) {
        for (String key : parameters.keySet()) {
            this.addParameters(operatorId, key, parameters.getString(key, null));
        }
        return this;
    }

    public InputOutputFormatContainer addParameters(OperatorID operatorId, String key, String value) {
        this.parameters.setString(this.getParamKeyPrefix(operatorId) + key, value);
        return this;
    }

    public void write(TaskConfig config) {
        config.setStubWrapper((UserCodeWrapper<?>)new UserCodeObjectWrapper((Object)this.formats));
        config.setStubParameters(this.parameters);
    }

    private String getParamKeyPrefix(OperatorID operatorId) {
        return operatorId + ".";
    }

    public static class FormatUserCodeTable
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<OperatorID, UserCodeWrapper<? extends InputFormat<?, ?>>> inputFormats = new HashMap();
        private final Map<OperatorID, UserCodeWrapper<? extends OutputFormat<?>>> outputFormats = new HashMap();

        public void addInputFormat(OperatorID operatorId, UserCodeWrapper<? extends InputFormat<?, ?>> wrapper) {
            if (this.inputFormats.containsKey(Preconditions.checkNotNull((Object)((Object)operatorId)))) {
                throw new IllegalStateException("The input format has been set for the operator: " + operatorId);
            }
            this.inputFormats.put(operatorId, (UserCodeWrapper)Preconditions.checkNotNull(wrapper));
        }

        public void addOutputFormat(OperatorID operatorId, UserCodeWrapper<? extends OutputFormat<?>> wrapper) {
            if (this.outputFormats.containsKey(Preconditions.checkNotNull((Object)((Object)operatorId)))) {
                throw new IllegalStateException("The output format has been set for the operator: " + operatorId);
            }
            this.outputFormats.put(operatorId, (UserCodeWrapper)Preconditions.checkNotNull(wrapper));
        }

        public Map<OperatorID, UserCodeWrapper<? extends InputFormat<?, ?>>> getInputFormats() {
            return Collections.unmodifiableMap(this.inputFormats);
        }

        public Map<OperatorID, UserCodeWrapper<? extends OutputFormat<?>>> getOutputFormats() {
            return Collections.unmodifiableMap(this.outputFormats);
        }
    }
}

