/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.streaming.api.windowing.windows.GlobalWindow;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.assertj.core.api.Condition;

class WindowSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Object, Object> {
    WindowSerializerUpgradeTest() {
    }

    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("time-window-serializer", flinkVersion, TimeWindowSerializerSetup.class, TimeWindowSerializerVerifier.class));
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("global-window-serializer", flinkVersion, GlobalWindowSerializerSetup.class, GlobalWindowSerializerVerifier.class));
        return testSpecifications;
    }

    public static final class GlobalWindowSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<GlobalWindow> {
        public TypeSerializer<GlobalWindow> createUpgradedSerializer() {
            return new GlobalWindow.Serializer();
        }

        public Condition<GlobalWindow> testDataCondition() {
            return new Condition(arg_0 -> ((GlobalWindow)GlobalWindow.get()).equals(arg_0), "", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<GlobalWindow>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class GlobalWindowSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<GlobalWindow> {
        public TypeSerializer<GlobalWindow> createPriorSerializer() {
            return new GlobalWindow.Serializer();
        }

        public GlobalWindow createTestData() {
            return GlobalWindow.get();
        }
    }

    public static final class TimeWindowSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<TimeWindow> {
        public TypeSerializer<TimeWindow> createUpgradedSerializer() {
            return new TimeWindow.Serializer();
        }

        public Condition<TimeWindow> testDataCondition() {
            return new Condition(timeWindow -> new TimeWindow(12345L, 67890L).equals(timeWindow), "", new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<TimeWindow>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class TimeWindowSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<TimeWindow> {
        public TypeSerializer<TimeWindow> createPriorSerializer() {
            return new TimeWindow.Serializer();
        }

        public TimeWindow createTestData() {
            return new TimeWindow(12345L, 67890L);
        }
    }
}

