/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.graph;

import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.CheckpointingMode;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.legacy.SinkFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TranslationTest {
    TranslationTest() {
    }

    @Test
    void testCheckpointModeTranslation() {
        StreamExecutionEnvironment deactivated = TranslationTest.getSimpleJob();
        Assertions.assertThat((Comparable)CheckpointingOptions.getCheckpointingMode((Configuration)deactivated.getStreamGraph().getJobGraph().getJobConfiguration())).isEqualTo((Object)CheckpointingMode.AT_LEAST_ONCE);
        StreamExecutionEnvironment activated = TranslationTest.getSimpleJob();
        activated.enableCheckpointing(1000L);
        Assertions.assertThat((Comparable)CheckpointingOptions.getCheckpointingMode((Configuration)activated.getStreamGraph().getJobGraph().getJobConfiguration())).isEqualTo((Object)CheckpointingMode.EXACTLY_ONCE);
        StreamExecutionEnvironment explicit = TranslationTest.getSimpleJob();
        explicit.enableCheckpointing(1000L, CheckpointingMode.AT_LEAST_ONCE);
        Assertions.assertThat((Comparable)CheckpointingOptions.getCheckpointingMode((Configuration)explicit.getStreamGraph().getJobGraph().getJobConfiguration())).isEqualTo((Object)CheckpointingMode.AT_LEAST_ONCE);
    }

    private static StreamExecutionEnvironment getSimpleJob() {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.fromSequence(1L, 10000000L).addSink((SinkFunction)new SinkFunction<Long>(){

            public void invoke(Long value) {
            }
        });
        return env;
    }
}

