/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichAggregateFunction;
import org.apache.flink.streaming.api.operators.PartitionAggregateOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.TestHarnessUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PartitionAggregateOperatorTest {
    private static final int RECORD = 1;

    PartitionAggregateOperatorTest() {
    }

    @Test
    void testAggregate() throws Exception {
        PartitionAggregateOperator partitionAggregateOperator = new PartitionAggregateOperator((AggregateFunction)new Aggregate(new CompletableFuture<Object>(), new CompletableFuture<Object>()));
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(partitionAggregateOperator);
        LinkedList<StreamRecord> expectedOutput = new LinkedList<StreamRecord>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)1));
        testHarness.processElement(new StreamRecord((Object)1));
        testHarness.processElement(new StreamRecord((Object)1));
        testHarness.endInput();
        expectedOutput.add(new StreamRecord((Object)"303"));
        TestHarnessUtil.assertOutputEquals("The aggregate result is not correct.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }

    @Test
    void testOpenClose() throws Exception {
        CompletableFuture<Object> openIdentifier = new CompletableFuture<Object>();
        CompletableFuture<Object> closeIdentifier = new CompletableFuture<Object>();
        PartitionAggregateOperator partitionAggregateOperator = new PartitionAggregateOperator((AggregateFunction)new Aggregate(openIdentifier, closeIdentifier));
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(partitionAggregateOperator);
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)1));
        testHarness.endInput();
        testHarness.close();
        Assertions.assertThat(openIdentifier).isCompleted();
        Assertions.assertThat(closeIdentifier).isCompleted();
        Assertions.assertThat(testHarness.getOutput()).isNotEmpty();
    }

    private static class TestAccumulator {
        private Integer result = 0;

        private TestAccumulator() {
        }

        public void addNumber(Integer number) {
            this.result = this.result + number + 100;
        }

        public String getResult() {
            return String.valueOf(this.result);
        }
    }

    private static class Aggregate
    extends RichAggregateFunction<Integer, TestAccumulator, String> {
        private final CompletableFuture<Object> openIdentifier;
        private final CompletableFuture<Object> closeIdentifier;

        public Aggregate(CompletableFuture<Object> openIdentifier, CompletableFuture<Object> closeIdentifier) {
            this.openIdentifier = openIdentifier;
            this.closeIdentifier = closeIdentifier;
        }

        public void open(OpenContext openContext) throws Exception {
            super.open(openContext);
            this.openIdentifier.complete(null);
        }

        public TestAccumulator createAccumulator() {
            return new TestAccumulator();
        }

        public TestAccumulator add(Integer value, TestAccumulator accumulator) {
            accumulator.addNumber(value);
            return accumulator;
        }

        public String getResult(TestAccumulator accumulator) {
            return accumulator.getResult();
        }

        public TestAccumulator merge(TestAccumulator a, TestAccumulator b) {
            return null;
        }

        public void close() throws Exception {
            super.close();
            this.closeIdentifier.complete(null);
        }
    }
}

