/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.operators.testutils.ExpectedTestException;
import org.apache.flink.streaming.api.functions.source.ContinuousFileReaderOperatorFactory;
import org.apache.flink.streaming.api.functions.source.TimestampedFileInputSplit;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.mailbox.Mail;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ContinuousFileReaderOperatorTest {
    ContinuousFileReaderOperatorTest() {
    }

    @Test
    void testExceptionRethrownFromClose() throws Exception {
        OneInputStreamOperatorTestHarness<TimestampedFileInputSplit, String> harness = this.createHarness(this.failingFormat());
        harness.getExecutionConfig().setAutoWatermarkInterval(10L);
        Assertions.assertThatThrownBy(() -> {
            try (OneInputStreamOperatorTestHarness tester = harness;){
                tester.open();
            }
        }).isInstanceOf(ExpectedTestException.class);
    }

    @Test
    void testExceptionRethrownFromProcessElement() throws Exception {
        OneInputStreamOperatorTestHarness<TimestampedFileInputSplit, String> harness = this.createHarness(this.failingFormat());
        harness.getExecutionConfig().setAutoWatermarkInterval(10L);
        Assertions.assertThatThrownBy(() -> {
            try (OneInputStreamOperatorTestHarness tester = harness;){
                tester.open();
                tester.processElement(new StreamRecord((Object)new TimestampedFileInputSplit(0L, 1, new Path(), 0L, 0L, new String[0])));
                for (Mail m : harness.getTaskMailbox().drain()) {
                    m.run();
                }
            }
        }).isInstanceOf(ExpectedTestException.class);
    }

    private FileInputFormat<String> failingFormat() {
        return new FileInputFormat<String>(){

            public boolean reachedEnd() {
                return false;
            }

            public String nextRecord(String reuse) {
                throw new ExpectedTestException();
            }

            public void open(FileInputSplit fileSplit) {
                throw new ExpectedTestException();
            }

            public void close() {
                throw new ExpectedTestException();
            }

            public void configure(Configuration parameters) {
            }
        };
    }

    private <T> OneInputStreamOperatorTestHarness<TimestampedFileInputSplit, T> createHarness(FileInputFormat<T> format) throws Exception {
        ExecutionConfig config = new ExecutionConfig();
        return new OneInputStreamOperatorTestHarness(new ContinuousFileReaderOperatorFactory(format, TypeExtractor.getInputFormatTypes(format), config), TypeExtractor.getForClass(TimestampedFileInputSplit.class).createSerializer(config.getSerializerConfig()));
    }
}

