/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.stats;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.runtime.util.stats.StatsSummary;
import org.apache.flink.runtime.util.stats.StatsSummarySnapshot;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;

class StatsSummaryTest {
    StatsSummaryTest() {
    }

    @Test
    void testInitialState() {
        StatsSummary mma = new StatsSummary();
        Assertions.assertThat((long)mma.getMinimum()).isZero();
        Assertions.assertThat((long)mma.getMaximum()).isZero();
        Assertions.assertThat((long)mma.getSum()).isZero();
        Assertions.assertThat((long)mma.getCount()).isZero();
        Assertions.assertThat((long)mma.getAverage()).isZero();
    }

    @Test
    void testAddNonPositiveStats() {
        StatsSummary mma = new StatsSummary();
        mma.add(-1L);
        Assertions.assertThat((long)mma.getMinimum()).isZero();
        Assertions.assertThat((long)mma.getMaximum()).isZero();
        Assertions.assertThat((long)mma.getSum()).isZero();
        Assertions.assertThat((long)mma.getCount()).isZero();
        Assertions.assertThat((long)mma.getAverage()).isZero();
        mma.add(0L);
        Assertions.assertThat((long)mma.getMinimum()).isZero();
        Assertions.assertThat((long)mma.getMaximum()).isZero();
        Assertions.assertThat((long)mma.getSum()).isZero();
        Assertions.assertThat((long)mma.getCount()).isOne();
        Assertions.assertThat((long)mma.getAverage()).isZero();
    }

    @Test
    void testAddRandomNumbers() {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        StatsSummary mma = new StatsSummary();
        long count = 13L;
        long sum = 0L;
        long min = Integer.MAX_VALUE;
        long max = Integer.MIN_VALUE;
        int i = 0;
        while ((long)i < count) {
            int number = rand.nextInt(124) + 1;
            sum += (long)number;
            min = Math.min(min, (long)number);
            max = Math.max(max, (long)number);
            mma.add((long)number);
            ++i;
        }
        Assertions.assertThat((long)mma.getMinimum()).isEqualTo(min);
        Assertions.assertThat((long)mma.getMaximum()).isEqualTo(max);
        Assertions.assertThat((long)mma.getSum()).isEqualTo(sum);
        Assertions.assertThat((long)mma.getCount()).isEqualTo(count);
        Assertions.assertThat((long)mma.getAverage()).isEqualTo(sum / count);
    }

    @Test
    void testQuantile() {
        int i;
        StatsSummary summary = new StatsSummary(100);
        for (i = 0; i < 123; ++i) {
            summary.add(100000L);
        }
        for (i = 1; i <= 100; ++i) {
            summary.add((long)i);
        }
        StatsSummarySnapshot snapshot = summary.createSnapshot();
        for (double q = 0.01; q <= 1.0; q += 1.0) {
            Assertions.assertThat((double)snapshot.getQuantile(q)).isCloseTo(q, Offset.offset((Number)1.0));
        }
    }
}

