/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroupImpl;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.scheduler.adaptive.allocator.JobInformation;

public class TestVertexInformation
implements JobInformation.VertexInformation {
    private final JobVertexID jobVertexId;
    private final int minParallelism;
    private final int parallelism;
    private final SlotSharingGroup slotSharingGroup;
    @Nullable
    private final TestingCoLocationGroup coLocationGroup;

    public TestVertexInformation(int parallelism, SlotSharingGroup slotSharingGroup) {
        this(new JobVertexID(), 1, parallelism, slotSharingGroup);
    }

    public TestVertexInformation(int parallelism, SlotSharingGroup slotSharingGroup, TestingCoLocationGroup coLocationGroup) {
        this(new JobVertexID(), 1, parallelism, slotSharingGroup, coLocationGroup);
    }

    TestVertexInformation(JobVertexID jobVertexId, int parallelism, SlotSharingGroup slotSharingGroup) {
        this(jobVertexId, 1, parallelism, slotSharingGroup);
    }

    TestVertexInformation(JobVertexID jobVertexId, int minParallelism, int parallelism, SlotSharingGroup slotSharingGroup) {
        this(jobVertexId, minParallelism, parallelism, slotSharingGroup, null);
    }

    TestVertexInformation(JobVertexID jobVertexId, int minParallelism, int parallelism, SlotSharingGroup slotSharingGroup, @Nullable TestingCoLocationGroup coLocationGroup) {
        this.jobVertexId = jobVertexId;
        this.minParallelism = minParallelism;
        this.parallelism = parallelism;
        this.slotSharingGroup = slotSharingGroup;
        this.slotSharingGroup.addVertexToGroup(jobVertexId);
        this.coLocationGroup = coLocationGroup;
        if (this.coLocationGroup != null) {
            this.coLocationGroup.addVertex(jobVertexId);
        }
    }

    public JobVertexID getJobVertexID() {
        return this.jobVertexId;
    }

    public int getMinParallelism() {
        return this.minParallelism;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getMaxParallelism() {
        return 128;
    }

    public SlotSharingGroup getSlotSharingGroup() {
        return this.slotSharingGroup;
    }

    @Nullable
    public TestingCoLocationGroup getCoLocationGroup() {
        return this.coLocationGroup;
    }

    public static class TestingCoLocationGroup
    extends CoLocationGroupImpl {
        private final List<JobVertexID> verticesIDs = new ArrayList<JobVertexID>();

        public TestingCoLocationGroup(JobVertexID ... verticesIDs) {
            super(new JobVertex[0]);
            if (verticesIDs != null && verticesIDs.length > 0) {
                this.verticesIDs.addAll(Arrays.stream(verticesIDs).collect(Collectors.toList()));
            }
        }

        public void addVertex(JobVertexID vertexID) {
            this.verticesIDs.add(vertexID);
        }

        public List<JobVertexID> getVertexIds() {
            return this.verticesIDs;
        }
    }
}

