/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.scheduler.adaptive.JobSchedulingPlan;
import org.apache.flink.runtime.scheduler.adaptive.allocator.AbstractSlotMatchingResolverTest;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotMatchingResolver;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotSharingSlotAllocator;
import org.apache.flink.runtime.scheduler.adaptive.allocator.TasksBalancedSlotMatchingResolver;
import org.apache.flink.runtime.scheduler.loading.DefaultLoadingWeight;
import org.apache.flink.runtime.scheduler.loading.LoadingWeight;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.assertj.core.api.Assertions;

class TasksBalancedSlotMatchingResolverTest
extends AbstractSlotMatchingResolverTest {
    TasksBalancedSlotMatchingResolverTest() {
    }

    @Override
    protected SlotMatchingResolver createSlotMatchingResolver() {
        return TasksBalancedSlotMatchingResolver.INSTANCE;
    }

    @Override
    protected void assertAssignments(Collection<JobSchedulingPlan.SlotAssignment> assignments) {
        Map<TaskManagerLocation, Set<JobSchedulingPlan.SlotAssignment>> assignmentsPerTm = TasksBalancedSlotMatchingResolverTest.getAssignmentsPerTaskManager(assignments);
        Assertions.assertThat(assignmentsPerTm).allSatisfy((taskManagerLocation, slotAssignments) -> Assertions.assertThat((float)slotAssignments.stream().map(s -> ((SlotSharingSlotAllocator.ExecutionSlotSharingGroup)s.getTargetAs(SlotSharingSlotAllocator.ExecutionSlotSharingGroup.class)).getLoading()).reduce(DefaultLoadingWeight.EMPTY, LoadingWeight::merge).getLoading()).isGreaterThanOrEqualTo(9.0f));
    }
}

