/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.scheduler.ExecutionOperations;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class TestExecutionOperationsDecorator
implements ExecutionOperations {
    private final ExecutionOperations delegate;
    private final CountLatch deployedExecutions = new CountLatch();
    private final CountLatch canceledExecutions = new CountLatch();
    private final CountLatch failedExecutions = new CountLatch();
    private boolean failDeploy;

    public TestExecutionOperationsDecorator(ExecutionOperations delegate) {
        this.delegate = (ExecutionOperations)Preconditions.checkNotNull((Object)delegate);
    }

    public void deploy(Execution execution) throws JobException {
        this.deployedExecutions.add(execution);
        if (this.failDeploy) {
            throw new RuntimeException("Expected");
        }
        this.delegate.deploy(execution);
    }

    public CompletableFuture<?> cancel(Execution execution) {
        this.canceledExecutions.add(execution);
        return this.delegate.cancel(execution);
    }

    public void markFailed(Execution execution, Throwable cause) {
        this.failedExecutions.add(execution);
        this.delegate.markFailed(execution, cause);
    }

    public void enableFailDeploy() {
        this.failDeploy = true;
    }

    public void disableFailDeploy() {
        this.failDeploy = false;
    }

    public List<ExecutionAttemptID> getDeployedExecutions() {
        return this.deployedExecutions.getExecutions();
    }

    public List<ExecutionAttemptID> getCanceledExecutions() {
        return this.canceledExecutions.getExecutions();
    }

    public List<ExecutionAttemptID> getFailedExecutions() {
        return this.failedExecutions.getExecutions();
    }

    public List<ExecutionVertexID> getDeployedVertices() {
        return this.deployedExecutions.getVertices();
    }

    public List<ExecutionVertexID> getCanceledVertices() {
        return this.canceledExecutions.getVertices();
    }

    public List<ExecutionVertexID> getFailedVertices() {
        return this.failedExecutions.getVertices();
    }

    public void awaitCanceledExecutions(int count) throws InterruptedException {
        this.canceledExecutions.await(count);
    }

    public void awaitFailedExecutions(int count) throws InterruptedException {
        this.failedExecutions.await(count);
    }

    private static class CountLatch {
        @GuardedBy(value="lock")
        private final List<Execution> executions = new ArrayList<Execution>();
        private final Object lock = new Object();

        private CountLatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Execution execution) {
            Object object = this.lock;
            synchronized (object) {
                this.executions.add(execution);
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await(int count) throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                while (this.executions.size() < count) {
                    this.lock.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ExecutionAttemptID> getExecutions() {
            Object object = this.lock;
            synchronized (object) {
                return this.executions.stream().map(Execution::getAttemptId).collect(Collectors.toList());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ExecutionVertexID> getVertices() {
            Object object = this.lock;
            synchronized (object) {
                return this.executions.stream().map(Execution::getVertex).map(ExecutionVertex::getID).collect(Collectors.toList());
            }
        }
    }
}

