/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.topology;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalResult;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalVertex;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalVertexTest;
import org.apache.flink.runtime.util.JobVertexConnectionUtils;
import org.apache.flink.util.IterableUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultLogicalResultTest
extends TestLogger {
    private IntermediateDataSet result;
    private DefaultLogicalResult logicalResult;
    private Map<JobVertexID, JobVertex> vertexMap;
    private JobVertex producerVertex;

    @Before
    public void setUp() throws Exception {
        this.buildVerticesAndResults();
        this.logicalResult = new DefaultLogicalResult(this.result, vid -> new DefaultLogicalVertex(this.vertexMap.get(vid), rid -> null));
    }

    @Test
    public void testConstructor() {
        DefaultLogicalResultTest.assertResultInfoEquals(this.result, this.logicalResult);
    }

    @Test
    public void testGetProducer() {
        DefaultLogicalVertexTest.assertVertexInfoEquals(this.producerVertex, this.logicalResult.getProducer());
    }

    private void buildVerticesAndResults() {
        this.vertexMap = new HashMap<JobVertexID, JobVertex>();
        int parallelism = 3;
        this.producerVertex = ExecutionGraphTestUtils.createNoOpVertex(3);
        this.vertexMap.put(this.producerVertex.getID(), this.producerVertex);
        JobVertex consumerVertex = ExecutionGraphTestUtils.createNoOpVertex(3);
        JobEdge edge = JobVertexConnectionUtils.connectNewDataSetAsInput(consumerVertex, this.producerVertex, DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED);
        this.vertexMap.put(consumerVertex.getID(), consumerVertex);
        this.result = edge.getSource();
    }

    static void assertResultsEquals(Iterable<IntermediateDataSet> results, Iterable<DefaultLogicalResult> logicalResults) {
        Map logicalResultMap = IterableUtils.toStream(logicalResults).collect(Collectors.toMap(DefaultLogicalResult::getId, Function.identity()));
        for (IntermediateDataSet result : results) {
            DefaultLogicalResult logicalResult = (DefaultLogicalResult)logicalResultMap.remove(result.getId());
            Assert.assertNotNull((Object)logicalResult);
            DefaultLogicalResultTest.assertResultInfoEquals(result, logicalResult);
        }
        Assert.assertEquals((long)0L, (long)logicalResultMap.size());
    }

    static void assertResultInfoEquals(IntermediateDataSet result, DefaultLogicalResult logicalResult) {
        Assert.assertEquals((Object)result.getId(), (Object)logicalResult.getId());
        Assert.assertEquals((Object)result.getResultType(), (Object)logicalResult.getResultType());
    }
}

