/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.io.network.metrics.InputChannelMetrics;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelBuilder;
import org.apache.flink.runtime.io.network.partition.consumer.LocalInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGateBuilder;
import org.apache.flink.runtime.io.network.partition.consumer.UnknownInputChannel;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class UnknownInputChannelTest {
    UnknownInputChannelTest() {
    }

    @Test
    void testMetrics() {
        SingleInputGateBuilder builder = new SingleInputGateBuilder().setNumberOfChannels(1).setSingleInputGateIndex(0).setResultPartitionType(ResultPartitionType.PIPELINED);
        InputChannelMetrics metrics = new InputChannelMetrics(new MetricGroup[]{new UnregisteredMetricsGroup()});
        UnknownInputChannel unknownInputChannel = InputChannelBuilder.newBuilder().setMetrics(metrics).buildUnknownChannel(builder.build());
        metrics.getNumBuffersInLocalCounter().inc();
        LocalInputChannel localInputChannel = unknownInputChannel.toLocalInputChannel(new ResultPartitionID());
        Assertions.assertThat((long)localInputChannel.numBuffersIn.getCount()).isEqualTo(metrics.getNumBuffersInLocalCounter().getCount());
    }
}

