/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.executiongraph.failover.FailoverStrategyFactoryLoader;
import org.apache.flink.runtime.executiongraph.failover.RestartAllFailoverStrategy;
import org.apache.flink.runtime.executiongraph.failover.RestartPipelinedRegionFailoverStrategy;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FailoverStrategyFactoryLoaderTest {
    FailoverStrategyFactoryLoaderTest() {
    }

    @Test
    void testLoadRestartAllStrategyFactory() {
        Configuration config = new Configuration();
        config.set(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY, (Object)"full");
        Assertions.assertThat((Object)FailoverStrategyFactoryLoader.loadFailoverStrategyFactory((Configuration)config)).isInstanceOf(RestartAllFailoverStrategy.Factory.class);
    }

    @Test
    void testLoadRestartPipelinedRegionStrategyFactory() {
        Configuration config = new Configuration();
        config.set(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY, (Object)"region");
        Assertions.assertThat((Object)FailoverStrategyFactoryLoader.loadFailoverStrategyFactory((Configuration)config)).isInstanceOf(RestartPipelinedRegionFailoverStrategy.Factory.class);
    }

    @Test
    void testDefaultFailoverStrategyIsRegion() {
        Configuration config = new Configuration();
        Assertions.assertThat((Object)FailoverStrategyFactoryLoader.loadFailoverStrategyFactory((Configuration)config)).isInstanceOf(RestartPipelinedRegionFailoverStrategy.Factory.class);
    }

    @Test
    void testLoadFromInvalidConfiguration() {
        Configuration config = new Configuration();
        config.set(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY, (Object)"invalidStrategy");
        Assertions.assertThatThrownBy(() -> FailoverStrategyFactoryLoader.loadFailoverStrategyFactory((Configuration)config)).isInstanceOf(IllegalConfigurationException.class);
    }
}

