/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Properties;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.util.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentInformation {
    @VisibleForTesting
    public static final String UNKNOWN_COMMIT_ID = "DecafC0ffeeD0d0F00d";
    @VisibleForTesting
    public static final String UNKNOWN_COMMIT_ID_ABBREV = "DeadD0d0";
    private static final Logger LOG = LoggerFactory.getLogger(EnvironmentInformation.class);
    public static final String UNKNOWN = "<unknown>";

    public static String getVersion() {
        return EnvironmentInformation.getVersionsInstance().projectVersion;
    }

    public static String getScalaVersion() {
        return EnvironmentInformation.getVersionsInstance().scalaVersion;
    }

    public static Instant getBuildTime() {
        return EnvironmentInformation.getVersionsInstance().gitBuildTime;
    }

    public static String getBuildTimeString() {
        return EnvironmentInformation.getVersionsInstance().gitBuildTimeStr;
    }

    public static String getGitCommitId() {
        return EnvironmentInformation.getVersionsInstance().gitCommitId;
    }

    public static String getGitCommitIdAbbrev() {
        return EnvironmentInformation.getVersionsInstance().gitCommitIdAbbrev;
    }

    public static Instant getGitCommitTime() {
        return EnvironmentInformation.getVersionsInstance().gitCommitTime;
    }

    public static String getGitCommitTimeString() {
        return EnvironmentInformation.getVersionsInstance().gitCommitTimeStr;
    }

    public static RevisionInformation getRevisionInformation() {
        return new RevisionInformation(EnvironmentInformation.getGitCommitIdAbbrev(), EnvironmentInformation.getGitCommitTimeString());
    }

    private static Versions getVersionsInstance() {
        return VersionsHolder.INSTANCE;
    }

    public static String getHadoopUser() {
        try {
            Class<?> ugiClass = Class.forName("org.apache.hadoop.security.UserGroupInformation", false, EnvironmentInformation.class.getClassLoader());
            Method currentUserMethod = ugiClass.getMethod("getCurrentUser", new Class[0]);
            Method shortUserNameMethod = ugiClass.getMethod("getShortUserName", new Class[0]);
            Object ugi = currentUserMethod.invoke(null, new Object[0]);
            return (String)shortUserNameMethod.invoke(ugi, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return "<no hadoop dependency found>";
        }
        catch (LinkageError e) {
            LOG.debug("Cannot determine user/group information using Hadoop utils. Hadoop classes not loaded or compatible", (Throwable)e);
        }
        catch (Throwable t) {
            LOG.warn("Error while accessing user/group information via Hadoop utils.", t);
        }
        return UNKNOWN;
    }

    public static long getMaxJvmHeapMemory() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory != Long.MAX_VALUE) {
            return maxMemory;
        }
        long physicalMemory = Hardware.getSizeOfPhysicalMemory();
        if (physicalMemory != -1L) {
            return physicalMemory / 4L;
        }
        throw new RuntimeException("Could not determine the amount of free memory.\nPlease set the maximum memory for the JVM, e.g. -Xmx512M for 512 megabytes.");
    }

    public static long getSizeOfFreeHeapMemoryWithDefrag() {
        System.gc();
        return EnvironmentInformation.getSizeOfFreeHeapMemory();
    }

    public static long getSizeOfFreeHeapMemory() {
        Runtime r = Runtime.getRuntime();
        return EnvironmentInformation.getMaxJvmHeapMemory() - r.totalMemory() + r.freeMemory();
    }

    public static String getJvmVersion() {
        try {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            return bean.getVmName() + " - " + bean.getVmVendor() + " - " + bean.getSpecVersion() + "/" + bean.getVmVersion();
        }
        catch (Throwable t) {
            return UNKNOWN;
        }
    }

    public static String getJvmStartupOptions() {
        try {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            StringBuilder bld = new StringBuilder();
            for (String s : bean.getInputArguments()) {
                bld.append(s).append(' ');
            }
            return bld.toString();
        }
        catch (Throwable t) {
            return UNKNOWN;
        }
    }

    public static String[] getJvmStartupOptionsArray() {
        try {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            List<String> options = bean.getInputArguments();
            return options.toArray(new String[options.size()]);
        }
        catch (Throwable t) {
            return new String[0];
        }
    }

    public static String getTemporaryFileDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static long getOpenFileHandlesLimit() {
        Class<?> sunBeanClass;
        if (OperatingSystem.isWindows()) {
            return -1L;
        }
        try {
            sunBeanClass = Class.forName("com.sun.management.UnixOperatingSystemMXBean");
        }
        catch (ClassNotFoundException e) {
            return -1L;
        }
        try {
            Method fhLimitMethod = sunBeanClass.getMethod("getMaxFileDescriptorCount", new Class[0]);
            Object result = fhLimitMethod.invoke((Object)ManagementFactory.getOperatingSystemMXBean(), new Object[0]);
            return (Long)result;
        }
        catch (Throwable t) {
            LOG.warn("Unexpected error when accessing file handle limit", t);
            return -1L;
        }
    }

    public static void logEnvironmentInfo(Logger log, String componentName, String[] commandLineArgs) {
        if (log.isInfoEnabled()) {
            RevisionInformation rev = EnvironmentInformation.getRevisionInformation();
            String version = EnvironmentInformation.getVersion();
            String scalaVersion = EnvironmentInformation.getScalaVersion();
            String jvmVersion = EnvironmentInformation.getJvmVersion();
            String[] options = EnvironmentInformation.getJvmStartupOptionsArray();
            String javaHome = System.getenv("JAVA_HOME");
            String inheritedLogs = System.getenv("FLINK_INHERITED_LOGS");
            String arch = System.getProperty("os.arch");
            long maxHeapMegabytes = EnvironmentInformation.getMaxJvmHeapMemory() >>> 20;
            if (inheritedLogs != null) {
                log.info("--------------------------------------------------------------------------------");
                log.info(" Preconfiguration: ");
                log.info(inheritedLogs);
            }
            log.info("--------------------------------------------------------------------------------");
            log.info(" Starting " + componentName + " (Version: " + version + ", Scala: " + scalaVersion + ", Rev:" + rev.commitId + ", Date:" + rev.commitDate + ")");
            log.info(" OS current user: " + System.getProperty("user.name"));
            log.info(" Current Hadoop/Kerberos user: " + EnvironmentInformation.getHadoopUser());
            log.info(" JVM: " + jvmVersion);
            log.info(" Arch: " + arch);
            log.info(" Maximum heap size: " + maxHeapMegabytes + " MiBytes");
            log.info(" JAVA_HOME: " + (javaHome == null ? "(not set)" : javaHome));
            String hadoopVersionString = EnvironmentInformation.getHadoopVersionString();
            if (hadoopVersionString != null) {
                log.info(" Hadoop version: " + hadoopVersionString);
            } else {
                log.info(" No Hadoop Dependency available");
            }
            if (options.length == 0) {
                log.info(" JVM Options: (none)");
            } else {
                log.info(" JVM Options:");
                for (String s : options) {
                    log.info("    " + s);
                }
            }
            if (commandLineArgs == null || commandLineArgs.length == 0) {
                log.info(" Program Arguments: (none)");
            } else {
                log.info(" Program Arguments:");
                for (String s : commandLineArgs) {
                    if (GlobalConfiguration.isSensitive((String)s)) {
                        log.info("    ****** (sensitive information)");
                        continue;
                    }
                    log.info("    " + s);
                }
            }
            log.info(" Classpath: " + System.getProperty("java.class.path"));
            log.info("--------------------------------------------------------------------------------");
        }
    }

    public static String getHadoopVersionString() {
        try {
            Class<?> versionInfoClass = Class.forName("org.apache.hadoop.util.VersionInfo", false, EnvironmentInformation.class.getClassLoader());
            Method method = versionInfoClass.getMethod("getVersion", new Class[0]);
            return (String)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return null;
        }
        catch (Throwable e) {
            LOG.error("Cannot invoke VersionInfo.getVersion reflectively.", e);
            return null;
        }
    }

    private EnvironmentInformation() {
    }

    public static class RevisionInformation {
        public final String commitId;
        public final String commitDate;

        public RevisionInformation(String commitId, String commitDate) {
            this.commitId = commitId;
            this.commitDate = commitDate;
        }
    }

    private static final class VersionsHolder {
        static final Versions INSTANCE = new Versions();

        private VersionsHolder() {
        }
    }

    private static final class Versions {
        private static final Instant DEFAULT_TIME_INSTANT = Instant.EPOCH;
        private static final String DEFAULT_TIME_STRING = "1970-01-01T00:00:00+0000";
        private String projectVersion;
        private String scalaVersion;
        private Instant gitBuildTime;
        private String gitBuildTimeStr;
        private String gitCommitId;
        private String gitCommitIdAbbrev;
        private Instant gitCommitTime;
        private String gitCommitTimeStr;
        private static final String PROP_FILE = ".flink-runtime.version.properties";
        private static final String FAIL_MESSAGE = "The file .flink-runtime.version.properties has not been generated correctly. You MUST run 'mvn generate-sources' in the flink-runtime module.";

        private String getProperty(Properties properties, String key, String defaultValue) {
            String value = properties.getProperty(key);
            if (value == null || value.charAt(0) == '$') {
                return defaultValue;
            }
            return value;
        }

        public Versions() {
            block10: {
                this.projectVersion = EnvironmentInformation.UNKNOWN;
                this.scalaVersion = EnvironmentInformation.UNKNOWN;
                this.gitBuildTime = DEFAULT_TIME_INSTANT;
                this.gitBuildTimeStr = DEFAULT_TIME_STRING;
                this.gitCommitId = EnvironmentInformation.UNKNOWN_COMMIT_ID;
                this.gitCommitIdAbbrev = EnvironmentInformation.UNKNOWN_COMMIT_ID_ABBREV;
                this.gitCommitTime = DEFAULT_TIME_INSTANT;
                this.gitCommitTimeStr = DEFAULT_TIME_STRING;
                ClassLoader classLoader = EnvironmentInformation.class.getClassLoader();
                try (InputStream propFile = classLoader.getResourceAsStream(PROP_FILE);){
                    if (propFile == null) break block10;
                    Properties properties = new Properties();
                    properties.load(propFile);
                    this.projectVersion = this.getProperty(properties, "project.version", EnvironmentInformation.UNKNOWN);
                    this.scalaVersion = this.getProperty(properties, "scala.binary.version", EnvironmentInformation.UNKNOWN);
                    this.gitCommitId = this.getProperty(properties, "git.commit.id", EnvironmentInformation.UNKNOWN_COMMIT_ID);
                    this.gitCommitIdAbbrev = this.getProperty(properties, "git.commit.id.abbrev", EnvironmentInformation.UNKNOWN_COMMIT_ID_ABBREV);
                    DateTimeFormatter gitDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
                    DateTimeFormatter berlinDateTime = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.of("Europe/Berlin"));
                    try {
                        String propGitCommitTime = this.getProperty(properties, "git.commit.time", DEFAULT_TIME_STRING);
                        this.gitCommitTime = gitDateTimeFormatter.parse((CharSequence)propGitCommitTime, Instant::from);
                        this.gitCommitTimeStr = berlinDateTime.format(this.gitCommitTime);
                        String propGitBuildTime = this.getProperty(properties, "git.build.time", DEFAULT_TIME_STRING);
                        this.gitBuildTime = gitDateTimeFormatter.parse((CharSequence)propGitBuildTime, Instant::from);
                        this.gitBuildTimeStr = berlinDateTime.format(this.gitBuildTime);
                    }
                    catch (DateTimeParseException dtpe) {
                        LOG.error("{} : {}", (Object)FAIL_MESSAGE, (Object)dtpe);
                        throw new IllegalStateException(FAIL_MESSAGE);
                    }
                }
                catch (IOException ioe) {
                    LOG.info("Cannot determine code revision: Unable to read version property file.: {}", (Object)ioe.getMessage());
                }
            }
        }
    }
}

