/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.persistence;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.persistence.ResourceVersion;
import org.apache.flink.util.Preconditions;

public class StringResourceVersion
implements ResourceVersion<StringResourceVersion> {
    private static final long serialVersionUID = 1L;
    private static final StringResourceVersion NOT_EXISTING = new StringResourceVersion("-1");
    private final String value;

    private StringResourceVersion(String value) {
        this.value = value;
    }

    @Override
    public int compareTo(@Nonnull StringResourceVersion other) {
        return this.value.compareTo(other.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == StringResourceVersion.class) {
            StringResourceVersion that = (StringResourceVersion)obj;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Override
    public boolean isExisting() {
        return this != NOT_EXISTING;
    }

    public String toString() {
        return "StringResourceVersion{value='" + this.value + "'}";
    }

    public String getValue() {
        return this.value;
    }

    public static StringResourceVersion notExisting() {
        return NOT_EXISTING;
    }

    public static StringResourceVersion valueOf(String value) {
        Preconditions.checkArgument((!value.equals(NOT_EXISTING.getValue()) ? 1 : 0) != 0);
        return new StringResourceVersion(value);
    }
}

