/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.event;

import java.io.IOException;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;

class FsBatchFlushOutputStream
extends FSDataOutputStream {
    private final byte[] writeBuffer;
    private final FSDataOutputStream outputStream;
    private final Path filePath;
    private int pos;
    private volatile boolean closed;

    public FsBatchFlushOutputStream(FileSystem fileSystem, Path filePath, FileSystem.WriteMode overwriteMode, int bufferSize) throws IOException {
        this.filePath = filePath;
        this.outputStream = fileSystem.create(filePath, overwriteMode);
        this.writeBuffer = new byte[bufferSize];
    }

    public long getPos() throws IOException {
        return (long)this.pos + (this.outputStream == null ? 0L : this.outputStream.getPos());
    }

    public void write(int b) throws IOException {
        if (this.pos >= this.writeBuffer.length) {
            this.flush();
        }
        this.writeBuffer[this.pos++] = (byte)b;
    }

    public void writeInt(int num) throws IOException {
        this.write(num >>> 24 & 0xFF);
        this.write(num >>> 16 & 0xFF);
        this.write(num >>> 8 & 0xFF);
        this.write(num & 0xFF);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len < this.writeBuffer.length) {
            int remaining = this.writeBuffer.length - this.pos;
            if (len >= remaining) {
                System.arraycopy(b, off, this.writeBuffer, this.pos, remaining);
                off += remaining;
                len -= remaining;
                this.pos += remaining;
                this.flush();
            }
            if (len > 0) {
                System.arraycopy(b, off, this.writeBuffer, this.pos, len);
                this.pos += len;
            }
        } else {
            this.flush();
            this.outputStream.write(b, off, len);
        }
    }

    public void flush() throws IOException {
        if (!this.closed && this.pos > 0) {
            this.outputStream.write(this.writeBuffer, 0, this.pos);
            this.outputStream.flush();
            this.pos = 0;
        }
    }

    public void sync() throws IOException {
        this.outputStream.sync();
    }

    public void close() throws IOException {
        if (!this.closed) {
            try {
                if (this.outputStream != null) {
                    this.flush();
                    this.pos = this.writeBuffer.length;
                    this.outputStream.close();
                }
            }
            finally {
                this.closed = true;
            }
        }
    }
}

