/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.streaming.runtime.partitioner.RebalancePartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitionerTest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RebalancePartitionerTest
extends StreamPartitionerTest {
    RebalancePartitionerTest() {
    }

    @Override
    StreamPartitioner<Tuple> createPartitioner() {
        RebalancePartitioner partitioner = new RebalancePartitioner();
        Assertions.assertThat((boolean)partitioner.isBroadcast()).isFalse();
        return partitioner;
    }

    @Test
    void testSelectChannelsInterval() {
        int numberOfChannels = 3;
        this.streamPartitioner.setup(3);
        int initialChannel = this.streamPartitioner.selectChannel((IOReadableWritable)this.serializationDelegate);
        Assertions.assertThat((int)initialChannel).isGreaterThanOrEqualTo(0).isLessThan(3);
        for (int i = 1; i <= 3; ++i) {
            this.assertSelectedChannel((initialChannel + i) % 3);
        }
    }
}

