/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichReduceFunction;
import org.apache.flink.streaming.api.operators.PartitionReduceOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.TestHarnessUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PartitionReduceOperatorTest {
    private static final int RECORD = 10;

    PartitionReduceOperatorTest() {
    }

    @Test
    void testReduce() throws Exception {
        PartitionReduceOperator partitionReduceOperator = new PartitionReduceOperator((ReduceFunction)new Reduce(new CompletableFuture<Object>(), new CompletableFuture<Object>()));
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(partitionReduceOperator);
        LinkedList<StreamRecord> expectedOutput = new LinkedList<StreamRecord>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)10));
        testHarness.processElement(new StreamRecord((Object)10));
        testHarness.processElement(new StreamRecord((Object)10));
        testHarness.endInput();
        expectedOutput.add(new StreamRecord((Object)30));
        TestHarnessUtil.assertOutputEquals("The reduce result is not correct.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }

    @Test
    void testOpenClose() throws Exception {
        CompletableFuture<Object> openIdentifier = new CompletableFuture<Object>();
        CompletableFuture<Object> closeIdentifier = new CompletableFuture<Object>();
        PartitionReduceOperator partitionReduceOperator = new PartitionReduceOperator((ReduceFunction)new Reduce(openIdentifier, closeIdentifier));
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(partitionReduceOperator);
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)10));
        testHarness.endInput();
        testHarness.close();
        Assertions.assertThat(openIdentifier).isCompleted();
        Assertions.assertThat(closeIdentifier).isCompleted();
        Assertions.assertThat(testHarness.getOutput()).isNotEmpty();
    }

    private static class Reduce
    extends RichReduceFunction<Integer> {
        private final CompletableFuture<Object> openIdentifier;
        private final CompletableFuture<Object> closeIdentifier;

        public Reduce(CompletableFuture<Object> openIdentifier, CompletableFuture<Object> closeIdentifier) {
            this.openIdentifier = openIdentifier;
            this.closeIdentifier = closeIdentifier;
        }

        public void open(OpenContext openContext) throws Exception {
            super.open(openContext);
            this.openIdentifier.complete(null);
        }

        public Integer reduce(Integer value1, Integer value2) {
            return value1 + value2;
        }

        public void close() throws Exception {
            super.close();
            this.closeIdentifier.complete(null);
        }
    }
}

