/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.runtime.state.ArrayListSerializer;
import org.assertj.core.api.Condition;

class ArrayListSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<ArrayList<String>, ArrayList<String>> {
    private static final String SPEC_NAME = "arraylist-serializer";

    ArrayListSerializerUpgradeTest() {
    }

    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification(SPEC_NAME, flinkVersion, ArrayListSerializerSetup.class, ArrayListSerializerVerifier.class));
        return testSpecifications;
    }

    public static final class ArrayListSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<ArrayList<String>> {
        public TypeSerializer<ArrayList<String>> createUpgradedSerializer() {
            return new ArrayListSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public Condition<ArrayList<String>> testDataCondition() {
            ArrayList<String> data = new ArrayList<String>(2);
            data.add("Apache");
            data.add("Flink");
            return new Condition(data::equals, "value is equal to " + data, new Object[0]);
        }

        public Condition<TypeSerializerSchemaCompatibility<ArrayList<String>>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class ArrayListSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<ArrayList<String>> {
        public TypeSerializer<ArrayList<String>> createPriorSerializer() {
            return new ArrayListSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public ArrayList<String> createTestData() {
            ArrayList<String> data = new ArrayList<String>(2);
            data.add("Apache");
            data.add("Flink");
            return data;
        }
    }
}

