/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.metrics;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.metrics.util.InterceptingOperatorMetricGroup;
import org.apache.flink.runtime.scheduler.metrics.JobStatusMetrics;
import org.apache.flink.runtime.scheduler.metrics.StateTimeMetric;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StateTimeMetricTest {
    StateTimeMetricTest() {
    }

    @Test
    void testEnableStateMetrics() {
        StateTimeMetricTest.testMetricSelection(MetricOptions.JobStatusMetrics.STATE);
    }

    @Test
    void testEnableCurrentTimeMetrics() {
        StateTimeMetricTest.testMetricSelection(MetricOptions.JobStatusMetrics.CURRENT_TIME);
    }

    @Test
    void testEnableTotalTimeMetrics() {
        StateTimeMetricTest.testMetricSelection(MetricOptions.JobStatusMetrics.TOTAL_TIME);
    }

    @Test
    void testEnableMultipleMetrics() {
        StateTimeMetricTest.testMetricSelection(MetricOptions.JobStatusMetrics.CURRENT_TIME, MetricOptions.JobStatusMetrics.TOTAL_TIME);
    }

    private static void testMetricSelection(MetricOptions.JobStatusMetrics ... selectedMetrics) {
        EnumSet<MetricOptions.JobStatusMetrics> selectedMetricsSet = EnumSet.noneOf(MetricOptions.JobStatusMetrics.class);
        Arrays.stream(selectedMetrics).forEach(selectedMetricsSet::add);
        InterceptingOperatorMetricGroup metricGroup = new InterceptingOperatorMetricGroup();
        StateTimeMetric.register((MetricOptions.JobStatusMetricsSettings)StateTimeMetricTest.enable(selectedMetrics), (MetricGroup)metricGroup, (StateTimeMetric)new TestStateTimeMetric(), (String)"test");
        Map<JobStatus, StatusMetricSet> registeredMetrics = StateTimeMetricTest.extractMetrics(metricGroup);
        for (StatusMetricSet metrics : registeredMetrics.values()) {
            Assertions.assertThat((boolean)metrics.getState().isPresent()).isEqualTo(selectedMetricsSet.contains(MetricOptions.JobStatusMetrics.STATE));
            Assertions.assertThat((boolean)metrics.getCurrentTime().isPresent()).isEqualTo(selectedMetricsSet.contains(MetricOptions.JobStatusMetrics.CURRENT_TIME));
            Assertions.assertThat((boolean)metrics.getTotalTime().isPresent()).isEqualTo(selectedMetricsSet.contains(MetricOptions.JobStatusMetrics.TOTAL_TIME));
        }
    }

    static MetricOptions.JobStatusMetricsSettings enable(MetricOptions.JobStatusMetrics ... enabledMetrics) {
        Configuration configuration = new Configuration();
        configuration.set(MetricOptions.JOB_STATUS_METRICS, Arrays.asList(enabledMetrics));
        return MetricOptions.JobStatusMetricsSettings.fromConfiguration((Configuration)configuration);
    }

    static Map<JobStatus, StatusMetricSet> extractMetrics(InterceptingOperatorMetricGroup metrics) {
        EnumMap<JobStatus, StatusMetricSet> extractedMetrics = new EnumMap<JobStatus, StatusMetricSet>(JobStatus.class);
        for (JobStatus jobStatus : JobStatus.values()) {
            String baseMetricName = JobStatusMetrics.getBaseMetricName((JobStatus)jobStatus);
            StatusMetricSet statusMetricSet = new StatusMetricSet((Gauge<Long>)((Gauge)metrics.get(StateTimeMetric.getStateMetricName((String)baseMetricName))), (Gauge<Long>)((Gauge)metrics.get(StateTimeMetric.getCurrentTimeMetricName((String)baseMetricName))), (Gauge<Long>)((Gauge)metrics.get(StateTimeMetric.getTotalTimeMetricName((String)baseMetricName))));
            if (!statusMetricSet.getState().isPresent() && !statusMetricSet.getCurrentTime().isPresent() && !statusMetricSet.getTotalTime().isPresent()) continue;
            extractedMetrics.put(jobStatus, statusMetricSet);
        }
        return extractedMetrics;
    }

    static class StatusMetricSet {
        @Nullable
        private final Gauge<Long> state;
        @Nullable
        private final Gauge<Long> currentTime;
        @Nullable
        private final Gauge<Long> totalTime;

        private StatusMetricSet(@Nullable Gauge<Long> state, @Nullable Gauge<Long> currentTime, @Nullable Gauge<Long> totalTime) {
            this.state = state;
            this.currentTime = currentTime;
            this.totalTime = totalTime;
        }

        @Nullable
        public Optional<Gauge<Long>> getState() {
            return Optional.ofNullable(this.state);
        }

        @Nullable
        public Optional<Gauge<Long>> getCurrentTime() {
            return Optional.ofNullable(this.currentTime);
        }

        @Nullable
        public Optional<Gauge<Long>> getTotalTime() {
            return Optional.ofNullable(this.totalTime);
        }
    }

    private static class TestStateTimeMetric
    implements StateTimeMetric {
        private TestStateTimeMetric() {
        }

        public long getCurrentTime() {
            return 2L;
        }

        public long getTotalTime() {
            return 3L;
        }

        public long getBinary() {
            return 1L;
        }
    }
}

