/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.scheduler.adaptive.BackgroundTask;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class BackgroundTaskTest {
    @RegisterExtension
    private static final TestExecutorExtension<ExecutorService> TEST_EXECUTOR_EXTENSION = new TestExecutorExtension(() -> Executors.newFixedThreadPool(2));

    BackgroundTaskTest() {
    }

    @Test
    void testFinishedBackgroundTaskIsTerminated() {
        BackgroundTask finishedBackgroundTask = BackgroundTask.finishedBackgroundTask();
        FlinkAssertions.assertThatFuture((CompletableFuture)finishedBackgroundTask.getTerminationFuture()).isDone();
        finishedBackgroundTask.getTerminationFuture().join();
    }

    @Test
    void testFinishedBackgroundTaskDoesNotContainAResult() {
        BackgroundTask finishedBackgroundTask = BackgroundTask.finishedBackgroundTask();
        FlinkAssertions.assertThatFuture((CompletableFuture)finishedBackgroundTask.getResultFuture()).isCompletedExceptionally();
    }

    @Test
    void testNormalCompletionOfBackgroundTask() {
        String expectedValue = "foobar";
        BackgroundTask backgroundTask = BackgroundTask.finishedBackgroundTask().runAfter(() -> "foobar", (Executor)TEST_EXECUTOR_EXTENSION.getExecutor());
        Assertions.assertThat((String)((String)backgroundTask.getResultFuture().join())).isEqualTo("foobar");
        backgroundTask.getTerminationFuture().join();
    }

    @Test
    void testExceptionalCompletionOfBackgroundTask() throws InterruptedException {
        Exception expectedException = new Exception("Test exception");
        BackgroundTask backgroundTask = BackgroundTask.finishedBackgroundTask().runAfter(() -> {
            throw expectedException;
        }, (Executor)TEST_EXECUTOR_EXTENSION.getExecutor());
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> backgroundTask.getResultFuture().get()).withFailMessage("Expected an exceptionally completed result future.", new Object[0])).isInstanceOf(ExecutionException.class)).hasCause((Throwable)expectedException);
        backgroundTask.getTerminationFuture().join();
    }

    @Test
    void testRunAfterExecutesBackgroundTaskAfterPreviousHasCompleted() {
        OneShotLatch blockingLatch = new OneShotLatch();
        ArrayBlockingQueue taskCompletions = new ArrayBlockingQueue(2);
        BackgroundTask backgroundTask = BackgroundTask.initialBackgroundTask(() -> {
            blockingLatch.await();
            taskCompletions.offer(1);
            return null;
        }, (Executor)TEST_EXECUTOR_EXTENSION.getExecutor()).runAfter(() -> {
            taskCompletions.offer(2);
            return null;
        }, (Executor)TEST_EXECUTOR_EXTENSION.getExecutor());
        blockingLatch.trigger();
        backgroundTask.getTerminationFuture().join();
        Assertions.assertThat(taskCompletions).contains((Object[])new Integer[]{1, 2});
    }

    @Test
    void testAbortSkipsTasksWhichHaveNotBeenStarted() {
        OneShotLatch blockingLatch = new OneShotLatch();
        ArrayBlockingQueue taskCompletions = new ArrayBlockingQueue(2);
        BackgroundTask backgroundTask = BackgroundTask.initialBackgroundTask(() -> {
            blockingLatch.await();
            taskCompletions.offer(1);
            return null;
        }, (Executor)TEST_EXECUTOR_EXTENSION.getExecutor()).runAfter(() -> {
            taskCompletions.offer(2);
            return null;
        }, (Executor)TEST_EXECUTOR_EXTENSION.getExecutor());
        BackgroundTask finalTask = backgroundTask.runAfter(() -> {
            taskCompletions.offer(3);
            return null;
        }, (Executor)TEST_EXECUTOR_EXTENSION.getExecutor());
        backgroundTask.abort();
        blockingLatch.trigger();
        finalTask.getTerminationFuture().join();
        Assertions.assertThat(taskCompletions).contains((Object[])new Integer[]{1, 3});
    }
}

