/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.io.network.netty.InboundChannelHandlerFactory;
import org.apache.flink.runtime.io.network.netty.OutboundChannelHandlerFactory;
import org.apache.flink.runtime.io.network.netty.Prio0InboundChannelHandlerFactory;
import org.apache.flink.runtime.io.network.netty.Prio1InboundChannelHandlerFactory;
import org.apache.flink.runtime.rest.HttpMethodWrapper;
import org.apache.flink.runtime.rest.Prio0OutboundChannelHandlerFactory;
import org.apache.flink.runtime.rest.Prio1OutboundChannelHandlerFactory;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.RestServerEndpoint;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.RuntimeMessageHeaders;
import org.apache.flink.runtime.rest.util.TestRestServerEndpoint;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.apache.flink.testutils.junit.extensions.ContextClassLoaderExtension;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssertAlternative;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.RegisterExtension;

class RestExternalHandlersITCase {
    private static final Duration timeout = Duration.ofSeconds(10L);
    private static final String REQUEST_URL = "/nonExisting1";
    private static final String REDIRECT1_URL = "/nonExisting2";
    private static final String REDIRECT2_URL = "/nonExisting3";
    private RestServerEndpoint serverEndpoint;
    private RestClient restClient;
    private InetSocketAddress serverAddress;
    @RegisterExtension
    private static final Extension CONTEXT_CLASS_LOADER_EXTENSION = ContextClassLoaderExtension.builder().withServiceEntry(InboundChannelHandlerFactory.class, new String[]{Prio0InboundChannelHandlerFactory.class.getCanonicalName(), Prio1InboundChannelHandlerFactory.class.getCanonicalName()}).withServiceEntry(OutboundChannelHandlerFactory.class, new String[]{Prio0OutboundChannelHandlerFactory.class.getCanonicalName(), Prio1OutboundChannelHandlerFactory.class.getCanonicalName()}).build();
    @RegisterExtension
    static final TestExecutorExtension<ScheduledExecutorService> EXECUTOR_EXTENSION = TestingUtils.defaultExecutorExtension();
    private final Configuration config = RestExternalHandlersITCase.getBaseConfig();

    private static Configuration getBaseConfig() {
        String loopbackAddress = InetAddress.getLoopbackAddress().getHostAddress();
        Configuration config = new Configuration();
        config.set(RestOptions.BIND_PORT, (Object)"0");
        config.set(RestOptions.BIND_ADDRESS, (Object)loopbackAddress);
        config.set(RestOptions.ADDRESS, (Object)loopbackAddress);
        config.set(Prio0OutboundChannelHandlerFactory.REDIRECT_TO_URL, (Object)REDIRECT1_URL);
        config.set(Prio0InboundChannelHandlerFactory.REDIRECT_FROM_URL, (Object)REDIRECT1_URL);
        config.set(Prio0InboundChannelHandlerFactory.REDIRECT_TO_URL, (Object)REDIRECT2_URL);
        return config;
    }

    @BeforeEach
    void setup() throws Exception {
        this.serverEndpoint = TestRestServerEndpoint.builder(this.config).buildAndStart();
        this.restClient = new RestClient(this.config, (Executor)EXECUTOR_EXTENSION.getExecutor());
        this.serverAddress = this.serverEndpoint.getServerAddress();
    }

    @AfterEach
    void teardown() throws Exception {
        if (this.restClient != null) {
            this.restClient.shutdown(timeout);
            this.restClient = null;
        }
        if (this.serverEndpoint != null) {
            this.serverEndpoint.closeAsync().get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            this.serverEndpoint = null;
        }
    }

    @Test
    void testHandlersMustBeLoaded() {
        List inboundChannelHandlerFactories = this.serverEndpoint.getInboundChannelHandlerFactories();
        Assertions.assertThat((List)inboundChannelHandlerFactories).hasSize(2);
        Assertions.assertThat((Object)((InboundChannelHandlerFactory)inboundChannelHandlerFactories.get(0))).isInstanceOf(Prio1InboundChannelHandlerFactory.class);
        Assertions.assertThat((Object)((InboundChannelHandlerFactory)inboundChannelHandlerFactories.get(1))).isInstanceOf(Prio0InboundChannelHandlerFactory.class);
        List outboundChannelHandlerFactories = this.restClient.getOutboundChannelHandlerFactories();
        Assertions.assertThat((List)outboundChannelHandlerFactories).hasSize(2);
        Assertions.assertThat((Object)((OutboundChannelHandlerFactory)outboundChannelHandlerFactories.get(0))).isInstanceOf(Prio1OutboundChannelHandlerFactory.class);
        Assertions.assertThat((Object)((OutboundChannelHandlerFactory)outboundChannelHandlerFactories.get(1))).isInstanceOf(Prio0OutboundChannelHandlerFactory.class);
        CompletableFuture<TestResponse> response = this.sendRequestToTestHandler(new TestRequest());
        ((ThrowableAssertAlternative)FlinkAssertions.assertThatFuture(response).eventuallyFailsWith(ExecutionException.class).as("Request must fail with 2 times redirected URL", new Object[0])).withMessageContaining(REDIRECT2_URL);
    }

    private CompletableFuture<TestResponse> sendRequestToTestHandler(TestRequest testRequest) {
        try {
            return this.restClient.sendRequest(this.serverAddress.getHostName(), this.serverAddress.getPort(), (MessageHeaders)new TestHeaders(), (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)testRequest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class TestHeaders
    implements RuntimeMessageHeaders<TestRequest, TestResponse, EmptyMessageParameters> {
        private TestHeaders() {
        }

        public HttpMethodWrapper getHttpMethod() {
            return HttpMethodWrapper.POST;
        }

        public String getTargetRestEndpointURL() {
            return RestExternalHandlersITCase.REQUEST_URL;
        }

        public Class<TestRequest> getRequestClass() {
            return TestRequest.class;
        }

        public Class<TestResponse> getResponseClass() {
            return TestResponse.class;
        }

        public HttpResponseStatus getResponseStatusCode() {
            return HttpResponseStatus.OK;
        }

        public String getDescription() {
            return "";
        }

        public EmptyMessageParameters getUnresolvedMessageParameters() {
            return EmptyMessageParameters.getInstance();
        }
    }

    private static class TestResponse
    implements ResponseBody {
        private TestResponse() {
        }
    }

    private static class TestRequest
    implements RequestBody {
        private TestRequest() {
        }
    }
}

