/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.MetricRegistryTestUtils;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.InternalOperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.apache.flink.runtime.metrics.util.TestingMetricRegistry;
import org.apache.flink.shaded.guava33.com.google.common.collect.ImmutableSet;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class InternalOperatorGroupTest {
    private static final int NUMBER_OF_REPORTERS = 1;
    private TestingMetricRegistry registry;

    InternalOperatorGroupTest() {
    }

    @BeforeEach
    public void setup() {
        this.registry = TestingMetricRegistry.builder().setNumberReporters(1).build();
    }

    @Test
    void testGenerateScopeDefault() throws Exception {
        TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"theHostName", (ResourceID)new ResourceID("test-tm-id"));
        TaskMetricGroup taskGroup = tmGroup.addJob(new JobID(), "myJobName").addTask(ExecutionGraphTestUtils.createExecutionAttemptId(new JobVertexID(), 11, 0), "aTaskName");
        HashMap<String, String> additionalVariables = new HashMap<String, String>();
        additionalVariables.put("foo", "42");
        additionalVariables.put("bar", "44");
        InternalOperatorMetricGroup opGroup = taskGroup.getOrAddOperator(new OperatorID(), "myOpName", additionalVariables);
        Assertions.assertThat((Object[])opGroup.getScopeComponents()).containsExactly((Object[])new String[]{"theHostName", "taskmanager", "test-tm-id", "myJobName", "myOpName", "11"});
        Assertions.assertThat((String)opGroup.getMetricIdentifier("name")).isEqualTo("theHostName.taskmanager.test-tm-id.myJobName.myOpName.11.name");
        ((MapAssert)Assertions.assertThat((Map)opGroup.getAllVariables(0, (Set)ImmutableSet.of((Object)"foo"))).contains(new Map.Entry[]{Assertions.entry((Object)"bar", (Object)"44")})).doesNotContain(new Map.Entry[]{Assertions.entry((Object)"foo", (Object)"42")});
        Assertions.assertThat((Map)opGroup.getAllVariables()).contains(new Map.Entry[]{Assertions.entry((Object)"foo", (Object)"42"), Assertions.entry((Object)"bar", (Object)"44")});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGenerateScopeCustom() throws Exception {
        Configuration cfg = new Configuration();
        cfg.set(MetricOptions.SCOPE_NAMING_OPERATOR, (Object)"<tm_id>.<job_id>.<task_id>.<operator_name>.<operator_id>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        try {
            String tmID = "test-tm-id";
            JobID jid = new JobID();
            JobVertexID vertexId = new JobVertexID();
            OperatorID operatorID = new OperatorID();
            String operatorName = "operatorName";
            InternalOperatorMetricGroup operatorGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"theHostName", (ResourceID)new ResourceID(tmID)).addJob(jid, "myJobName").addTask(ExecutionGraphTestUtils.createExecutionAttemptId(vertexId, 13, 2), "aTaskname").getOrAddOperator(operatorID, operatorName, Collections.emptyMap());
            Assertions.assertThat((Object[])operatorGroup.getScopeComponents()).containsExactly((Object[])new String[]{tmID, jid.toString(), vertexId.toString(), operatorName, operatorID.toString()});
            Assertions.assertThat((String)operatorGroup.getMetricIdentifier("name")).isEqualTo("%s.%s.%s.%s.%s.name", new Object[]{tmID, jid, vertexId, operatorName, operatorID});
        }
        finally {
            registry.closeAsync().get();
        }
    }

    @Test
    void testIOMetricGroupInstantiation() throws Exception {
        TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"theHostName", (ResourceID)new ResourceID("test-tm-id"));
        TaskMetricGroup taskGroup = tmGroup.addJob(new JobID(), "myJobName").addTask(ExecutionGraphTestUtils.createExecutionAttemptId(new JobVertexID(), 11, 0), "aTaskName");
        InternalOperatorMetricGroup opGroup = taskGroup.getOrAddOperator(new OperatorID(), "myOpName", Collections.emptyMap());
        Assertions.assertThat((Object)opGroup.getIOMetricGroup()).isNotNull();
        Assertions.assertThat((Object)opGroup.getIOMetricGroup().getNumRecordsInCounter()).isNotNull();
        Assertions.assertThat((Object)opGroup.getIOMetricGroup().getNumRecordsOutCounter()).isNotNull();
    }

    @Test
    void testVariables() {
        JobID jid = new JobID();
        JobVertexID tid = new JobVertexID();
        ExecutionAttemptID eid = ExecutionGraphTestUtils.createExecutionAttemptId(tid, 11, 0);
        OperatorID oid = new OperatorID();
        TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"theHostName", (ResourceID)new ResourceID("test-tm-id"));
        TaskMetricGroup taskGroup = tmGroup.addJob(jid, "myJobName").addTask(eid, "aTaskName");
        InternalOperatorMetricGroup opGroup = taskGroup.getOrAddOperator(oid, "myOpName", Collections.emptyMap());
        Map variables = opGroup.getAllVariables();
        InternalOperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_HOST, "theHostName");
        InternalOperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASKMANAGER_ID, "test-tm-id");
        InternalOperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_JOB_ID, jid.toString());
        InternalOperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_JOB_NAME, "myJobName");
        InternalOperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASK_VERTEX_ID, tid.toString());
        InternalOperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASK_NAME, "aTaskName");
        InternalOperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASK_ATTEMPT_ID, eid.toString());
        InternalOperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASK_SUBTASK_INDEX, "11");
        InternalOperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASK_ATTEMPT_NUM, "0");
        InternalOperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_OPERATOR_ID, oid.toString());
        InternalOperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_OPERATOR_NAME, "myOpName");
    }

    private static void testVariable(Map<String, String> variables, String key, String expectedValue) {
        String actualValue = variables.get(key);
        ((AbstractStringAssert)Assertions.assertThat((String)actualValue).isNotNull()).isEqualTo(expectedValue);
    }

    @Test
    void testCreateQueryServiceMetricInfo() {
        JobID jid = new JobID();
        JobVertexID vid = new JobVertexID();
        ExecutionAttemptID eid = ExecutionGraphTestUtils.createExecutionAttemptId(vid, 4, 5);
        OperatorID oid = new OperatorID();
        TaskManagerMetricGroup tm = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"host", (ResourceID)new ResourceID("id"));
        TaskMetricGroup task = tm.addJob(jid, "jobname").addTask(eid, "taskName");
        InternalOperatorMetricGroup operator = task.getOrAddOperator(oid, "operator", Collections.emptyMap());
        QueryScopeInfo.OperatorQueryScopeInfo info = operator.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assertions.assertThat((String)info.scope).isEmpty();
        Assertions.assertThat((String)info.jobID).isEqualTo(jid.toString());
        Assertions.assertThat((String)info.vertexID).isEqualTo(vid.toString());
        Assertions.assertThat((int)info.subtaskIndex).isEqualTo(4);
        Assertions.assertThat((String)info.operatorName).isEqualTo("operator");
    }
}

