/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.metrics.TimerGauge;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.ManualClock;
import org.apache.flink.util.clock.SystemClock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TimerGaugeTest {
    private static final long SLEEP = 10L;
    private static final long UPDATE_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(5L);

    TimerGaugeTest() {
    }

    @Test
    void testBasicUsage() {
        ManualClock clock = new ManualClock(42000000L);
        TimerGauge gauge = new TimerGauge((Clock)clock, 5);
        gauge.update();
        Assertions.assertThat((Long)gauge.getValue()).isZero();
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isZero();
        Assertions.assertThat((long)gauge.getAccumulatedCount()).isZero();
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        clock.advanceTime(UPDATE_INTERVAL_MILLIS - 10L, TimeUnit.MILLISECONDS);
        gauge.update();
        Assertions.assertThat((Long)gauge.getValue()).isEqualTo(2L);
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isEqualTo(10L);
        Assertions.assertThat((long)gauge.getAccumulatedCount()).isEqualTo(10L);
        gauge.markStart();
        clock.advanceTime(5L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        clock.advanceTime(UPDATE_INTERVAL_MILLIS - 5L, TimeUnit.MILLISECONDS);
        gauge.update();
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isEqualTo(5L);
        Assertions.assertThat((long)gauge.getAccumulatedCount()).isEqualTo(15L);
    }

    @Test
    void testUpdateWithoutMarkingEnd() {
        ManualClock clock = new ManualClock(42000000L);
        TimerGauge gauge = new TimerGauge((Clock)clock, 10);
        clock.advanceTime(UPDATE_INTERVAL_MILLIS - 10L, TimeUnit.MILLISECONDS);
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.update();
        Assertions.assertThat((Long)gauge.getValue()).isEqualTo(2L);
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isEqualTo(10L);
        clock.advanceTime(UPDATE_INTERVAL_MILLIS, TimeUnit.MILLISECONDS);
        gauge.update();
        Assertions.assertThat((Long)gauge.getValue()).isEqualTo((10L + UPDATE_INTERVAL_MILLIS) / 10L);
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isEqualTo(10L + UPDATE_INTERVAL_MILLIS);
    }

    @Test
    void testGetWithoutUpdate() {
        ManualClock clock = new ManualClock(42000000L);
        TimerGauge gauge = new TimerGauge((Clock)clock);
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((Long)gauge.getValue()).isZero();
        gauge.markEnd();
        Assertions.assertThat((Long)gauge.getValue()).isZero();
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isZero();
    }

    @Test
    void testUpdateBeforeMarkingEnd() {
        ManualClock clock = new ManualClock(42000000L);
        TimerGauge gauge = new TimerGauge((Clock)clock, 10);
        clock.advanceTime(UPDATE_INTERVAL_MILLIS - 10L, TimeUnit.MILLISECONDS);
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.update();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        clock.advanceTime(UPDATE_INTERVAL_MILLIS - 10L, TimeUnit.MILLISECONDS);
        gauge.update();
        Assertions.assertThat((Long)gauge.getValue()).isEqualTo(2L);
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isEqualTo(20L);
    }

    @Test
    void testLargerTimespan() {
        ManualClock clock = new ManualClock(42000000L);
        TimerGauge gauge = new TimerGauge((Clock)clock, 10);
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        clock.advanceTime(UPDATE_INTERVAL_MILLIS - 10L, TimeUnit.MILLISECONDS);
        gauge.update();
        Assertions.assertThat((Long)gauge.getValue()).isEqualTo(2L);
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isEqualTo(10L);
        Assertions.assertThat((long)gauge.getAccumulatedCount()).isEqualTo(10L);
        clock.advanceTime(UPDATE_INTERVAL_MILLIS - 10L, TimeUnit.MILLISECONDS);
        gauge.update();
        Assertions.assertThat((Long)gauge.getValue()).isEqualTo(1L);
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isZero();
        Assertions.assertThat((long)gauge.getAccumulatedCount()).isEqualTo(10L);
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        clock.advanceTime(UPDATE_INTERVAL_MILLIS - 10L, TimeUnit.MILLISECONDS);
        gauge.update();
        gauge.markStart();
        clock.advanceTime(10L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        clock.advanceTime(UPDATE_INTERVAL_MILLIS - 10L, TimeUnit.MILLISECONDS);
        gauge.update();
        Assertions.assertThat((Long)gauge.getValue()).isEqualTo(2L);
        gauge.markStart();
        clock.advanceTime(5L, TimeUnit.MILLISECONDS);
        gauge.markEnd();
        clock.advanceTime(UPDATE_INTERVAL_MILLIS - 5L, TimeUnit.MILLISECONDS);
        gauge.update();
        Assertions.assertThat((long)gauge.getMaxSingleMeasurement()).isEqualTo(5L);
        Assertions.assertThat((long)gauge.getAccumulatedCount()).isEqualTo(35L);
    }

    @Test
    void testListeners() {
        TimerGauge gauge = new TimerGauge((Clock)SystemClock.getInstance(), 5);
        TestStartStopListener listener1 = new TestStartStopListener();
        TestStartStopListener listener2 = new TestStartStopListener();
        gauge.registerListener((TimerGauge.StartStopListener)listener1);
        gauge.markStart();
        listener1.assertCounts(1L, 0L);
        gauge.markEnd();
        listener1.assertCounts(1L, 1L);
        gauge.markStart();
        gauge.registerListener((TimerGauge.StartStopListener)listener2);
        listener1.assertCounts(2L, 1L);
        listener2.assertCounts(1L, 0L);
        gauge.markEnd();
        listener1.assertCounts(2L, 2L);
        listener2.assertCounts(1L, 1L);
        gauge.markStart();
        gauge.unregisterListener((TimerGauge.StartStopListener)listener1);
        listener1.assertCounts(3L, 3L);
        listener2.assertCounts(2L, 1L);
        gauge.markEnd();
        listener2.assertCounts(2L, 2L);
        gauge.unregisterListener((TimerGauge.StartStopListener)listener2);
        gauge.markStart();
        gauge.markEnd();
        listener1.assertCounts(3L, 3L);
        listener2.assertCounts(2L, 2L);
    }

    static class TestStartStopListener
    implements TimerGauge.StartStopListener {
        long startCount;
        long endCount;

        TestStartStopListener() {
        }

        public void markStart() {
            ++this.startCount;
        }

        public void markEnd() {
            ++this.endCount;
        }

        public void assertCounts(long expectedStart, long expectedEnd) {
            Assertions.assertThat((long)this.startCount).isEqualTo(expectedStart);
            Assertions.assertThat((long)this.endCount).isEqualTo(expectedEnd);
        }
    }
}

