/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.buffer.BufferConsumerWithPartialRecordLength;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.partition.PrioritizedDeque;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

class BufferConsumerWithPartialRecordLengthTest {
    private static final int BUFFER_INT_SIZE = 4;
    private static final int BUFFER_SIZE = 16;
    private final PrioritizedDeque<BufferConsumerWithPartialRecordLength> buffers = new PrioritizedDeque();
    private BufferBuilder builder = null;

    BufferConsumerWithPartialRecordLengthTest() {
    }

    @AfterEach
    void clear() {
        this.buffers.clear();
        this.builder = null;
    }

    @Test
    void partialRecordTestCase() {
        this.writeToBuffer(BufferBuilderTestUtils.toByteBuffer(0, 1, 2, 3, 42));
        Assertions.assertThat(this.buffers).hasSize(2);
        BufferConsumerWithPartialRecordLength consumer1 = (BufferConsumerWithPartialRecordLength)this.buffers.poll();
        Assertions.assertThat((int)Objects.requireNonNull(consumer1).getPartialRecordLength()).isZero();
        Assertions.assertThat((boolean)consumer1.cleanupPartialRecord()).isTrue();
        BufferBuilderTestUtils.assertContent(consumer1.build(), FreeingBufferRecycler.INSTANCE, 0, 1, 2, 3);
        BufferConsumerWithPartialRecordLength consumer2 = (BufferConsumerWithPartialRecordLength)this.buffers.poll();
        Assertions.assertThat((boolean)Objects.requireNonNull(consumer2).cleanupPartialRecord()).isTrue();
        Assertions.assertThat((int)consumer2.build().readableBytes()).isZero();
    }

    @Test
    void partialLongRecordSpanningBufferTestCase() {
        this.writeToBuffer(BufferBuilderTestUtils.toByteBuffer(0, 1, 2, 3, 4, 5, 6, 7, 42));
        this.writeToBuffer(BufferBuilderTestUtils.toByteBuffer(8, 9));
        Assertions.assertThat(this.buffers).hasSize(3);
        this.buffers.poll();
        BufferConsumerWithPartialRecordLength consumer2 = (BufferConsumerWithPartialRecordLength)this.buffers.poll();
        Assertions.assertThat((int)Objects.requireNonNull(consumer2).getPartialRecordLength()).isEqualTo(16);
        Assertions.assertThat((boolean)consumer2.cleanupPartialRecord()).isFalse();
        Assertions.assertThat((int)consumer2.build().readableBytes()).isZero();
        BufferConsumerWithPartialRecordLength consumer3 = (BufferConsumerWithPartialRecordLength)this.buffers.poll();
        Assertions.assertThat((boolean)Objects.requireNonNull(consumer3).cleanupPartialRecord()).isTrue();
        BufferBuilderTestUtils.assertContent(consumer3.build(), FreeingBufferRecycler.INSTANCE, 8, 9);
    }

    @Test
    void partialLongRecordEndsWithFullBufferTestCase() {
        this.writeToBuffer(BufferBuilderTestUtils.toByteBuffer(0, 1, 2, 3, 4, 5, 6, 42));
        this.writeToBuffer(BufferBuilderTestUtils.toByteBuffer(8, 9));
        Assertions.assertThat(this.buffers).hasSize(3);
        this.buffers.poll();
        BufferConsumerWithPartialRecordLength consumer2 = (BufferConsumerWithPartialRecordLength)this.buffers.poll();
        Assertions.assertThat((int)Objects.requireNonNull(consumer2).getPartialRecordLength()).isEqualTo(16);
        Assertions.assertThat((boolean)consumer2.cleanupPartialRecord()).isFalse();
        Assertions.assertThat((int)consumer2.build().readableBytes()).isZero();
        BufferConsumerWithPartialRecordLength consumer3 = (BufferConsumerWithPartialRecordLength)this.buffers.poll();
        Assertions.assertThat((boolean)Objects.requireNonNull(consumer3).cleanupPartialRecord()).isTrue();
        BufferBuilderTestUtils.assertContent(consumer3.build(), FreeingBufferRecycler.INSTANCE, 8, 9);
    }

    @Test
    void readPositionNotAtTheBeginningOfTheBufferTestCase() {
        this.writeToBuffer(BufferBuilderTestUtils.toByteBuffer(0, 1, 2, 3, 42));
        Assertions.assertThat(this.buffers).hasSize(2);
        this.buffers.poll();
        BufferConsumerWithPartialRecordLength consumer2 = (BufferConsumerWithPartialRecordLength)this.buffers.poll();
        Objects.requireNonNull(consumer2).build();
        this.writeToBuffer(BufferBuilderTestUtils.toByteBuffer(8, 9));
        Assertions.assertThat((int)consumer2.getPartialRecordLength()).isEqualTo(4);
        Assertions.assertThat((boolean)consumer2.cleanupPartialRecord()).isTrue();
        BufferBuilderTestUtils.assertContent(consumer2.build(), FreeingBufferRecycler.INSTANCE, 8, 9);
    }

    private void writeToBuffer(ByteBuffer record) {
        if (this.builder == null) {
            this.builder = BufferBuilderTestUtils.createEmptyBufferBuilder(16);
            this.buffers.add((Object)new BufferConsumerWithPartialRecordLength(this.builder.createBufferConsumerFromBeginning(), 0));
        }
        this.builder.appendAndCommit(record);
        while (record.hasRemaining()) {
            this.builder.finish();
            this.builder = BufferBuilderTestUtils.createEmptyBufferBuilder(16);
            int partialRecordBytes = this.builder.appendAndCommit(record);
            this.buffers.add((Object)new BufferConsumerWithPartialRecordLength(this.builder.createBufferConsumerFromBeginning(), partialRecordBytes));
        }
        if (this.builder.isFull()) {
            this.builder.finish();
            this.builder = null;
        }
    }
}

