/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufUtil;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.util.ByteProcessor;
import org.apache.flink.shaded.netty4.io.netty.util.CharsetUtil;
import org.apache.flink.shaded.netty4.io.netty.util.IllegalReferenceCountException;
import org.apache.flink.shaded.netty4.io.netty.util.internal.EmptyArrays;
import org.apache.flink.shaded.netty4.io.netty.util.internal.PlatformDependent;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

abstract class AbstractByteBufTest {
    private static final int CAPACITY = 4096;
    private static final int BLOCK_SIZE = 128;
    private static final int JAVA_BYTEBUFFER_CONSISTENCY_ITERATIONS = 100;
    private long seed;
    private Random random;
    private ByteBuf buffer;
    private static final CharBuffer EXTENDED_ASCII_CHARS;
    private static final CharBuffer ASCII_CHARS;

    AbstractByteBufTest() {
    }

    protected final ByteBuf newBuffer(int capacity) {
        return this.newBuffer(capacity, Integer.MAX_VALUE);
    }

    protected abstract ByteBuf newBuffer(int var1, int var2);

    protected boolean discardReadBytesDoesNotMoveWritableBytes() {
        return true;
    }

    @BeforeEach
    void init() {
        this.buffer = this.newBuffer(4096);
        this.seed = System.currentTimeMillis();
        this.random = new Random(this.seed);
    }

    @AfterEach
    void dispose() {
        if (this.buffer != null) {
            Assertions.assertThat((boolean)this.buffer.release()).isTrue();
            Assertions.assertThat((int)this.buffer.refCnt()).isZero();
            try {
                this.buffer.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.buffer = null;
        }
    }

    @Test
    void comparableInterfaceNotViolated() {
        Assumptions.assumeThat((boolean)this.buffer.isReadOnly()).isFalse();
        this.buffer.writerIndex(this.buffer.readerIndex());
        Assumptions.assumeThat((this.buffer.writableBytes() >= 4 ? 1 : 0) != 0).isTrue();
        this.buffer.writeLong(0L);
        ByteBuf buffer2 = this.newBuffer(4096);
        Assumptions.assumeThat((boolean)buffer2.isReadOnly()).isFalse();
        buffer2.writerIndex(buffer2.readerIndex());
        buffer2.writeLong(0xF0000000L);
        Assumptions.assumeThat((Comparable)this.buffer).isLessThan((Comparable)buffer2);
        Assumptions.assumeThat((Comparable)buffer2).isGreaterThan((Comparable)this.buffer);
        buffer2.release();
    }

    @Test
    void initialState() {
        Assertions.assertThat((int)this.buffer.capacity()).isEqualTo(4096);
        Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
    }

    @Test
    void readerIndexBoundaryCheck1() {
        this.buffer.writerIndex(0);
        Assertions.assertThatThrownBy(() -> this.buffer.readerIndex(-1)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void readerIndexBoundaryCheck2() {
        this.buffer.writerIndex(this.buffer.capacity());
        Assertions.assertThatThrownBy(() -> this.buffer.readerIndex(this.buffer.capacity() + 1)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void readerIndexBoundaryCheck3() {
        this.buffer.writerIndex(2048);
        Assertions.assertThatThrownBy(() -> this.buffer.readerIndex(6144)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void readerIndexBoundaryCheck4() {
        this.buffer.writerIndex(0);
        this.buffer.readerIndex(0);
        this.buffer.writerIndex(this.buffer.capacity());
        this.buffer.readerIndex(this.buffer.capacity());
    }

    @Test
    void writerIndexBoundaryCheck1() {
        Assertions.assertThatThrownBy(() -> this.buffer.writerIndex(-1)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void writerIndexBoundaryCheck2() {
        this.buffer.writerIndex(4096);
        this.buffer.readerIndex(4096);
        Assertions.assertThatThrownBy(() -> this.buffer.writerIndex(this.buffer.capacity() + 1)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void writerIndexBoundaryCheck3() {
        this.buffer.writerIndex(4096);
        this.buffer.readerIndex(2048);
        Assertions.assertThatThrownBy(() -> this.buffer.writerIndex(1024)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void writerIndexBoundaryCheck4() {
        this.buffer.writerIndex(0);
        this.buffer.readerIndex(0);
        this.buffer.writerIndex(4096);
        this.buffer.writeBytes(ByteBuffer.wrap(EmptyArrays.EMPTY_BYTES));
    }

    @Test
    void getBooleanBoundaryCheck1() {
        Assertions.assertThatThrownBy(() -> this.buffer.getBoolean(-1)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void getBooleanBoundaryCheck2() {
        Assertions.assertThatThrownBy(() -> this.buffer.getBoolean(this.buffer.capacity())).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void getByteBoundaryCheck1() {
        Assertions.assertThatThrownBy(() -> this.buffer.getByte(-1)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void getByteBoundaryCheck2() {
        Assertions.assertThatThrownBy(() -> this.buffer.getByte(this.buffer.capacity())).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void getShortBoundaryCheck1() {
        Assertions.assertThatThrownBy(() -> this.buffer.getShort(-1)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void getShortBoundaryCheck2() {
        Assertions.assertThatThrownBy(() -> this.buffer.getShort(this.buffer.capacity() - 1)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void getMediumBoundaryCheck1() {
        Assertions.assertThatThrownBy(() -> this.buffer.getMedium(-1)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void getMediumBoundaryCheck2() {
        Assertions.assertThatThrownBy(() -> this.buffer.getMedium(this.buffer.capacity() - 2)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void getIntBoundaryCheck1() {
        Assertions.assertThatThrownBy(() -> this.buffer.getInt(-1)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void getIntBoundaryCheck2() {
        Assertions.assertThatThrownBy(() -> this.buffer.getInt(this.buffer.capacity() - 3)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void getLongBoundaryCheck1() {
        Assertions.assertThatThrownBy(() -> this.buffer.getLong(-1)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void getLongBoundaryCheck2() {
        Assertions.assertThatThrownBy(() -> this.buffer.getLong(this.buffer.capacity() - 7)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void getByteArrayBoundaryCheck1() {
        Assertions.assertThatThrownBy(() -> this.buffer.getBytes(-1, EmptyArrays.EMPTY_BYTES)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void getByteArrayBoundaryCheck2() {
        Assertions.assertThatThrownBy(() -> this.buffer.getBytes(-1, EmptyArrays.EMPTY_BYTES, 0, 0)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void getByteArrayBoundaryCheck3() {
        byte[] dst = new byte[4];
        this.buffer.setInt(0, 16909060);
        Assertions.assertThatThrownBy(() -> this.buffer.getBytes(0, dst, -1, 4)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThat((byte)dst[0]).isZero();
        Assertions.assertThat((byte)dst[1]).isZero();
        Assertions.assertThat((byte)dst[2]).isZero();
        Assertions.assertThat((byte)dst[3]).isZero();
    }

    @Test
    void getByteArrayBoundaryCheck4() {
        byte[] dst = new byte[4];
        this.buffer.setInt(0, 16909060);
        Assertions.assertThatThrownBy(() -> this.buffer.getBytes(0, dst, 1, 4)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThat((byte)dst[0]).isZero();
        Assertions.assertThat((byte)dst[1]).isZero();
        Assertions.assertThat((byte)dst[2]).isZero();
        Assertions.assertThat((byte)dst[3]).isZero();
    }

    @Test
    void getByteBufferBoundaryCheck() {
        Assertions.assertThatThrownBy(() -> this.buffer.getBytes(-1, ByteBuffer.allocate(0))).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void copyBoundaryCheck1() {
        Assertions.assertThatThrownBy(() -> this.buffer.copy(-1, 0)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void copyBoundaryCheck2() {
        Assertions.assertThatThrownBy(() -> this.buffer.copy(0, this.buffer.capacity() + 1)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void copyBoundaryCheck3() {
        Assertions.assertThatThrownBy(() -> this.buffer.copy(this.buffer.capacity() + 1, 0)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void copyBoundaryCheck4() {
        Assertions.assertThatThrownBy(() -> this.buffer.copy(this.buffer.capacity(), 1)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void setIndexBoundaryCheck1() {
        Assertions.assertThatThrownBy(() -> this.buffer.setIndex(-1, 4096)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void setIndexBoundaryCheck2() {
        Assertions.assertThatThrownBy(() -> this.buffer.setIndex(2048, 1024)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void setIndexBoundaryCheck3() {
        Assertions.assertThatThrownBy(() -> this.buffer.setIndex(0, 4097)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void getByteBufferState() {
        ByteBuffer dst = ByteBuffer.allocate(4);
        dst.position(1);
        dst.limit(3);
        this.buffer.setByte(0, 1);
        this.buffer.setByte(1, 2);
        this.buffer.setByte(2, 3);
        this.buffer.setByte(3, 4);
        this.buffer.getBytes(1, dst);
        Assertions.assertThat((int)dst.position()).isEqualTo(3);
        Assertions.assertThat((int)dst.limit()).isEqualTo(3);
        dst.clear();
        Assertions.assertThat((byte)dst.get(0)).isZero();
        Assertions.assertThat((byte)dst.get(1)).isEqualTo((byte)2);
        Assertions.assertThat((byte)dst.get(2)).isEqualTo((byte)3);
        Assertions.assertThat((byte)dst.get(3)).isZero();
    }

    @Test
    void getDirectByteBufferBoundaryCheck() {
        Assertions.assertThatThrownBy(() -> this.buffer.getBytes(-1, ByteBuffer.allocateDirect(0))).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void getDirectByteBufferState() {
        ByteBuffer dst = ByteBuffer.allocateDirect(4);
        dst.position(1);
        dst.limit(3);
        this.buffer.setByte(0, 1);
        this.buffer.setByte(1, 2);
        this.buffer.setByte(2, 3);
        this.buffer.setByte(3, 4);
        this.buffer.getBytes(1, dst);
        Assertions.assertThat((int)dst.position()).isEqualTo(3);
        Assertions.assertThat((int)dst.limit()).isEqualTo(3);
        dst.clear();
        Assertions.assertThat((byte)dst.get(0)).isZero();
        Assertions.assertThat((byte)dst.get(1)).isEqualTo((byte)2);
        Assertions.assertThat((byte)dst.get(2)).isEqualTo((byte)3);
        Assertions.assertThat((byte)dst.get(3)).isZero();
    }

    @Test
    void testRandomByteAccess() {
        byte value;
        int i;
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = (byte)this.random.nextInt();
            this.buffer.setByte(i, (int)value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = (byte)this.random.nextInt();
            Assertions.assertThat((byte)this.buffer.getByte(i)).isEqualTo(value);
        }
    }

    @Test
    void testRandomUnsignedByteAccess() {
        short value;
        int i;
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = (short)this.random.nextInt();
            this.buffer.setByte(i, (int)value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = (short)(this.random.nextInt() & 0xFF);
            Assertions.assertThat((short)this.buffer.getUnsignedByte(i)).isEqualTo(value);
        }
    }

    @Test
    void testRandomShortAccess() {
        this.testRandomShortAccess(true);
    }

    @Test
    void testRandomShortLEAccess() {
        this.testRandomShortAccess(false);
    }

    private void testRandomShortAccess(boolean testBigEndian) {
        short value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 1; i += 2) {
            value = (short)this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setShort(i, (int)value);
                continue;
            }
            this.buffer.setShortLE(i, (int)value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 1; i += 2) {
            value = (short)this.random.nextInt();
            if (testBigEndian) {
                Assertions.assertThat((short)this.buffer.getShort(i)).isEqualTo(value);
                continue;
            }
            Assertions.assertThat((short)this.buffer.getShortLE(i)).isEqualTo(value);
        }
    }

    @Test
    void testShortConsistentWithByteBuffer() {
        this.testShortConsistentWithByteBuffer(true, true);
        this.testShortConsistentWithByteBuffer(true, false);
        this.testShortConsistentWithByteBuffer(false, true);
        this.testShortConsistentWithByteBuffer(false, false);
    }

    private void testShortConsistentWithByteBuffer(boolean direct, boolean testBigEndian) {
        for (int i = 0; i < 100; ++i) {
            ByteBuffer javaBuffer;
            ByteBuffer byteBuffer = javaBuffer = direct ? ByteBuffer.allocateDirect(this.buffer.capacity()) : ByteBuffer.allocate(this.buffer.capacity());
            if (!testBigEndian) {
                javaBuffer = javaBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            short expected = (short)(this.random.nextInt() & 0xFFFF);
            javaBuffer.putShort(expected);
            int bufferIndex = this.buffer.capacity() - 2;
            if (testBigEndian) {
                this.buffer.setShort(bufferIndex, (int)expected);
            } else {
                this.buffer.setShortLE(bufferIndex, (int)expected);
            }
            javaBuffer.flip();
            short javaActual = javaBuffer.getShort();
            Assertions.assertThat((short)javaActual).isEqualTo(expected).isEqualTo(testBigEndian ? this.buffer.getShort(bufferIndex) : this.buffer.getShortLE(bufferIndex));
        }
    }

    @Test
    void testRandomUnsignedShortAccess() {
        this.testRandomUnsignedShortAccess(true);
    }

    @Test
    void testRandomUnsignedShortLEAccess() {
        this.testRandomUnsignedShortAccess(false);
    }

    private void testRandomUnsignedShortAccess(boolean testBigEndian) {
        int value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 1; i += 2) {
            value = this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setShort(i, value);
                continue;
            }
            this.buffer.setShortLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 1; i += 2) {
            value = this.random.nextInt() & 0xFFFF;
            if (testBigEndian) {
                Assertions.assertThat((int)this.buffer.getUnsignedShort(i)).isEqualTo(value);
                continue;
            }
            Assertions.assertThat((int)this.buffer.getUnsignedShortLE(i)).isEqualTo(value);
        }
    }

    @Test
    void testRandomMediumAccess() {
        this.testRandomMediumAccess(true);
    }

    @Test
    void testRandomMediumLEAccess() {
        this.testRandomMediumAccess(false);
    }

    private void testRandomMediumAccess(boolean testBigEndian) {
        int value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 2; i += 3) {
            value = this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setMedium(i, value);
                continue;
            }
            this.buffer.setMediumLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 2; i += 3) {
            value = this.random.nextInt() << 8 >> 8;
            if (testBigEndian) {
                Assertions.assertThat((int)this.buffer.getMedium(i)).isEqualTo(value);
                continue;
            }
            Assertions.assertThat((int)this.buffer.getMediumLE(i)).isEqualTo(value);
        }
    }

    @Test
    void testRandomUnsignedMediumAccess() {
        this.testRandomUnsignedMediumAccess(true);
    }

    @Test
    void testRandomUnsignedMediumLEAccess() {
        this.testRandomUnsignedMediumAccess(false);
    }

    private void testRandomUnsignedMediumAccess(boolean testBigEndian) {
        int value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 2; i += 3) {
            value = this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setMedium(i, value);
                continue;
            }
            this.buffer.setMediumLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 2; i += 3) {
            value = this.random.nextInt() & 0xFFFFFF;
            if (testBigEndian) {
                Assertions.assertThat((int)this.buffer.getUnsignedMedium(i)).isEqualTo(value);
                continue;
            }
            Assertions.assertThat((int)this.buffer.getUnsignedMediumLE(i)).isEqualTo(value);
        }
    }

    @Test
    void testMediumConsistentWithByteBuffer() {
        this.testMediumConsistentWithByteBuffer(true, true);
        this.testMediumConsistentWithByteBuffer(true, false);
        this.testMediumConsistentWithByteBuffer(false, true);
        this.testMediumConsistentWithByteBuffer(false, false);
    }

    private void testMediumConsistentWithByteBuffer(boolean direct, boolean testBigEndian) {
        for (int i = 0; i < 100; ++i) {
            ByteBuffer javaBuffer;
            ByteBuffer byteBuffer = javaBuffer = direct ? ByteBuffer.allocateDirect(this.buffer.capacity()) : ByteBuffer.allocate(this.buffer.capacity());
            if (!testBigEndian) {
                javaBuffer = javaBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            int expected = this.random.nextInt() & 0xFFFFFF;
            javaBuffer.putInt(expected);
            int bufferIndex = this.buffer.capacity() - 3;
            if (testBigEndian) {
                this.buffer.setMedium(bufferIndex, expected);
            } else {
                this.buffer.setMediumLE(bufferIndex, expected);
            }
            javaBuffer.flip();
            int javaActual = javaBuffer.getInt();
            Assertions.assertThat((int)javaActual).isEqualTo(expected);
            Assertions.assertThat((int)javaActual).isEqualTo(testBigEndian ? this.buffer.getUnsignedMedium(bufferIndex) : this.buffer.getUnsignedMediumLE(bufferIndex));
        }
    }

    @Test
    void testRandomIntAccess() {
        this.testRandomIntAccess(true);
    }

    @Test
    void testRandomIntLEAccess() {
        this.testRandomIntAccess(false);
    }

    private void testRandomIntAccess(boolean testBigEndian) {
        int value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 3; i += 4) {
            value = this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setInt(i, value);
                continue;
            }
            this.buffer.setIntLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 3; i += 4) {
            value = this.random.nextInt();
            if (testBigEndian) {
                Assertions.assertThat((int)this.buffer.getInt(i)).isEqualTo(value);
                continue;
            }
            Assertions.assertThat((int)this.buffer.getIntLE(i)).isEqualTo(value);
        }
    }

    @Test
    void testIntConsistentWithByteBuffer() {
        this.testIntConsistentWithByteBuffer(true, true);
        this.testIntConsistentWithByteBuffer(true, false);
        this.testIntConsistentWithByteBuffer(false, true);
        this.testIntConsistentWithByteBuffer(false, false);
    }

    private void testIntConsistentWithByteBuffer(boolean direct, boolean testBigEndian) {
        for (int i = 0; i < 100; ++i) {
            ByteBuffer javaBuffer;
            ByteBuffer byteBuffer = javaBuffer = direct ? ByteBuffer.allocateDirect(this.buffer.capacity()) : ByteBuffer.allocate(this.buffer.capacity());
            if (!testBigEndian) {
                javaBuffer = javaBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            int expected = this.random.nextInt();
            javaBuffer.putInt(expected);
            int bufferIndex = this.buffer.capacity() - 4;
            if (testBigEndian) {
                this.buffer.setInt(bufferIndex, expected);
            } else {
                this.buffer.setIntLE(bufferIndex, expected);
            }
            javaBuffer.flip();
            int javaActual = javaBuffer.getInt();
            Assertions.assertThat((int)javaActual).isEqualTo(expected).isEqualTo(testBigEndian ? this.buffer.getInt(bufferIndex) : this.buffer.getIntLE(bufferIndex));
        }
    }

    @Test
    void testRandomUnsignedIntAccess() {
        this.testRandomUnsignedIntAccess(true);
    }

    @Test
    void testRandomUnsignedIntLEAccess() {
        this.testRandomUnsignedIntAccess(false);
    }

    private void testRandomUnsignedIntAccess(boolean testBigEndian) {
        int i;
        for (i = 0; i < this.buffer.capacity() - 3; i += 4) {
            int value = this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setInt(i, value);
                continue;
            }
            this.buffer.setIntLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 3; i += 4) {
            long value = (long)this.random.nextInt() & 0xFFFFFFFFL;
            if (testBigEndian) {
                Assertions.assertThat((long)this.buffer.getUnsignedInt(i)).isEqualTo(value);
                continue;
            }
            Assertions.assertThat((long)this.buffer.getUnsignedIntLE(i)).isEqualTo(value);
        }
    }

    @Test
    void testRandomLongAccess() {
        this.testRandomLongAccess(true);
    }

    @Test
    void testRandomLongLEAccess() {
        this.testRandomLongAccess(false);
    }

    private void testRandomLongAccess(boolean testBigEndian) {
        long value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            value = this.random.nextLong();
            if (testBigEndian) {
                this.buffer.setLong(i, value);
                continue;
            }
            this.buffer.setLongLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            value = this.random.nextLong();
            if (testBigEndian) {
                Assertions.assertThat((long)this.buffer.getLong(i)).isEqualTo(value);
                continue;
            }
            Assertions.assertThat((long)this.buffer.getLongLE(i)).isEqualTo(value);
        }
    }

    @Test
    void testLongConsistentWithByteBuffer() {
        this.testLongConsistentWithByteBuffer(true, true);
        this.testLongConsistentWithByteBuffer(true, false);
        this.testLongConsistentWithByteBuffer(false, true);
        this.testLongConsistentWithByteBuffer(false, false);
    }

    private void testLongConsistentWithByteBuffer(boolean direct, boolean testBigEndian) {
        for (int i = 0; i < 100; ++i) {
            ByteBuffer javaBuffer;
            ByteBuffer byteBuffer = javaBuffer = direct ? ByteBuffer.allocateDirect(this.buffer.capacity()) : ByteBuffer.allocate(this.buffer.capacity());
            if (!testBigEndian) {
                javaBuffer = javaBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            long expected = this.random.nextLong();
            javaBuffer.putLong(expected);
            int bufferIndex = this.buffer.capacity() - 8;
            if (testBigEndian) {
                this.buffer.setLong(bufferIndex, expected);
            } else {
                this.buffer.setLongLE(bufferIndex, expected);
            }
            javaBuffer.flip();
            long javaActual = javaBuffer.getLong();
            Assertions.assertThat((long)javaActual).isEqualTo(expected).isEqualTo(testBigEndian ? this.buffer.getLong(bufferIndex) : this.buffer.getLongLE(bufferIndex));
        }
    }

    @Test
    void testRandomFloatAccess() {
        this.testRandomFloatAccess(true);
    }

    @Test
    void testRandomFloatLEAccess() {
        this.testRandomFloatAccess(false);
    }

    private void testRandomFloatAccess(boolean testBigEndian) {
        int i;
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            float value = this.random.nextFloat();
            if (testBigEndian) {
                this.buffer.setFloat(i, value);
                continue;
            }
            this.buffer.setFloatLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            float expected = this.random.nextFloat();
            float actual = testBigEndian ? this.buffer.getFloat(i) : this.buffer.getFloatLE(i);
            Assertions.assertThat((float)actual).isCloseTo(expected, Assertions.within((Float)Float.valueOf(0.01f)));
        }
    }

    @Test
    void testRandomDoubleAccess() {
        this.testRandomDoubleAccess(true);
    }

    @Test
    void testRandomDoubleLEAccess() {
        this.testRandomDoubleAccess(false);
    }

    private void testRandomDoubleAccess(boolean testBigEndian) {
        int i;
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            double value = this.random.nextDouble();
            if (testBigEndian) {
                this.buffer.setDouble(i, value);
                continue;
            }
            this.buffer.setDoubleLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            double expected = this.random.nextDouble();
            double actual = testBigEndian ? this.buffer.getDouble(i) : this.buffer.getDoubleLE(i);
            Assertions.assertThat((double)actual).isCloseTo(expected, Assertions.within((Double)0.01));
        }
    }

    @Test
    void testSetZero() {
        int i;
        int length;
        this.buffer.clear();
        while (this.buffer.isWritable()) {
            this.buffer.writeByte(-1);
        }
        for (i = 0; i < this.buffer.capacity(); i += length) {
            length = Math.min(this.buffer.capacity() - i, this.random.nextInt(32));
            this.buffer.setZero(i, length);
        }
        for (i = 0; i < this.buffer.capacity(); ++i) {
            Assertions.assertThat((byte)this.buffer.getByte(i)).isZero();
        }
    }

    @Test
    void testSequentialByteAccess() {
        byte value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = (byte)this.random.nextInt();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isWritable()).isTrue();
            this.buffer.writeByte((int)value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((boolean)this.buffer.isWritable()).isFalse();
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = (byte)this.random.nextInt();
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isReadable()).isTrue();
            Assertions.assertThat((byte)this.buffer.readByte()).isEqualTo(value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((boolean)this.buffer.isReadable()).isFalse();
        Assertions.assertThat((boolean)this.buffer.isWritable()).isFalse();
    }

    @Test
    void testSequentialUnsignedByteAccess() {
        int value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = this.random.nextInt();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isWritable()).isTrue();
            this.buffer.writeByte(value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((boolean)this.buffer.isWritable()).isFalse();
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = this.random.nextInt() & 0xFF;
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isReadable()).isTrue();
            Assertions.assertThat((short)this.buffer.readUnsignedByte()).isEqualTo((short)value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((boolean)this.buffer.isReadable()).isFalse();
        Assertions.assertThat((boolean)this.buffer.isWritable()).isFalse();
    }

    @Test
    void testSequentialShortAccess() {
        this.testSequentialShortAccess(true);
    }

    @Test
    void testSequentialShortLEAccess() {
        this.testSequentialShortAccess(false);
    }

    private void testSequentialShortAccess(boolean testBigEndian) {
        short value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); i += 2) {
            value = (short)this.random.nextInt();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isWritable()).isTrue();
            if (testBigEndian) {
                this.buffer.writeShort((int)value);
                continue;
            }
            this.buffer.writeShortLE((int)value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((boolean)this.buffer.isWritable()).isFalse();
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); i += 2) {
            value = (short)this.random.nextInt();
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isReadable()).isTrue();
            if (testBigEndian) {
                Assertions.assertThat((short)this.buffer.readShort()).isEqualTo(value);
                continue;
            }
            Assertions.assertThat((short)this.buffer.readShortLE()).isEqualTo(value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((boolean)this.buffer.isReadable()).isFalse();
        Assertions.assertThat((boolean)this.buffer.isWritable()).isFalse();
    }

    @Test
    void testSequentialUnsignedShortAccess() {
        this.testSequentialUnsignedShortAccess(true);
    }

    @Test
    void testSequentialUnsignedShortLEAccess() {
        this.testSequentialUnsignedShortAccess(true);
    }

    private void testSequentialUnsignedShortAccess(boolean testBigEndian) {
        int value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); i += 2) {
            value = this.random.nextInt();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isWritable()).isTrue();
            if (testBigEndian) {
                this.buffer.writeShort(value);
                continue;
            }
            this.buffer.writeShortLE(value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((boolean)this.buffer.isWritable()).isFalse();
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); i += 2) {
            value = this.random.nextInt() & 0xFFFF;
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isReadable()).isTrue();
            if (testBigEndian) {
                Assertions.assertThat((int)this.buffer.readUnsignedShort()).isEqualTo(value);
                continue;
            }
            Assertions.assertThat((int)this.buffer.readUnsignedShortLE()).isEqualTo(value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((boolean)this.buffer.isReadable()).isFalse();
        Assertions.assertThat((boolean)this.buffer.isWritable()).isFalse();
    }

    @Test
    void testSequentialMediumAccess() {
        this.testSequentialMediumAccess(true);
    }

    @Test
    void testSequentialMediumLEAccess() {
        this.testSequentialMediumAccess(false);
    }

    private void testSequentialMediumAccess(boolean testBigEndian) {
        int value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity() / 3 * 3; i += 3) {
            value = this.random.nextInt();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isWritable()).isTrue();
            if (testBigEndian) {
                this.buffer.writeMedium(value);
                continue;
            }
            this.buffer.writeMediumLE(value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity() / 3 * 3);
        Assertions.assertThat((int)this.buffer.writableBytes()).isEqualTo(this.buffer.capacity() % 3);
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() / 3 * 3; i += 3) {
            value = this.random.nextInt() << 8 >> 8;
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isReadable()).isTrue();
            if (testBigEndian) {
                Assertions.assertThat((int)this.buffer.readMedium()).isEqualTo(value);
                continue;
            }
            Assertions.assertThat((int)this.buffer.readMediumLE()).isEqualTo(value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(this.buffer.capacity() / 3 * 3);
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity() / 3 * 3);
        Assertions.assertThat((int)this.buffer.readableBytes()).isZero();
        Assertions.assertThat((int)this.buffer.writableBytes()).isEqualTo(this.buffer.capacity() % 3);
    }

    @Test
    void testSequentialUnsignedMediumAccess() {
        this.testSequentialUnsignedMediumAccess(true);
    }

    @Test
    void testSequentialUnsignedMediumLEAccess() {
        this.testSequentialUnsignedMediumAccess(false);
    }

    private void testSequentialUnsignedMediumAccess(boolean testBigEndian) {
        int value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity() / 3 * 3; i += 3) {
            value = this.random.nextInt() & 0xFFFFFF;
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isWritable()).isTrue();
            if (testBigEndian) {
                this.buffer.writeMedium(value);
                continue;
            }
            this.buffer.writeMediumLE(value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity() / 3 * 3);
        Assertions.assertThat((int)this.buffer.writableBytes()).isEqualTo(this.buffer.capacity() % 3);
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() / 3 * 3; i += 3) {
            value = this.random.nextInt() & 0xFFFFFF;
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isReadable()).isTrue();
            if (testBigEndian) {
                Assertions.assertThat((int)this.buffer.readUnsignedMedium()).isEqualTo(value);
                continue;
            }
            Assertions.assertThat((int)this.buffer.readUnsignedMediumLE()).isEqualTo(value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(this.buffer.capacity() / 3 * 3);
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity() / 3 * 3);
        Assertions.assertThat((int)this.buffer.readableBytes()).isZero();
        Assertions.assertThat((int)this.buffer.writableBytes()).isEqualTo(this.buffer.capacity() % 3);
    }

    @Test
    void testSequentialIntAccess() {
        this.testSequentialIntAccess(true);
    }

    @Test
    void testSequentialIntLEAccess() {
        this.testSequentialIntAccess(false);
    }

    private void testSequentialIntAccess(boolean testBigEndian) {
        int value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); i += 4) {
            value = this.random.nextInt();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isWritable()).isTrue();
            if (testBigEndian) {
                this.buffer.writeInt(value);
                continue;
            }
            this.buffer.writeIntLE(value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((boolean)this.buffer.isWritable()).isFalse();
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); i += 4) {
            value = this.random.nextInt();
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isReadable()).isTrue();
            if (testBigEndian) {
                Assertions.assertThat((int)this.buffer.readInt()).isEqualTo(value);
                continue;
            }
            Assertions.assertThat((int)this.buffer.readIntLE()).isEqualTo(value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((boolean)this.buffer.isReadable()).isFalse();
        Assertions.assertThat((boolean)this.buffer.isWritable()).isFalse();
    }

    @Test
    void testSequentialUnsignedIntAccess() {
        this.testSequentialUnsignedIntAccess(true);
    }

    @Test
    void testSequentialUnsignedIntLEAccess() {
        this.testSequentialUnsignedIntAccess(false);
    }

    private void testSequentialUnsignedIntAccess(boolean testBigEndian) {
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); i += 4) {
            int value = this.random.nextInt();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isWritable()).isTrue();
            if (testBigEndian) {
                this.buffer.writeInt(value);
                continue;
            }
            this.buffer.writeIntLE(value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((boolean)this.buffer.isWritable()).isFalse();
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); i += 4) {
            long value = (long)this.random.nextInt() & 0xFFFFFFFFL;
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isReadable()).isTrue();
            if (testBigEndian) {
                Assertions.assertThat((long)this.buffer.readUnsignedInt()).isEqualTo(value);
                continue;
            }
            Assertions.assertThat((long)this.buffer.readUnsignedIntLE()).isEqualTo(value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((boolean)this.buffer.isReadable()).isFalse();
        Assertions.assertThat((boolean)this.buffer.isWritable()).isFalse();
    }

    @Test
    void testSequentialLongAccess() {
        this.testSequentialLongAccess(true);
    }

    @Test
    void testSequentialLongLEAccess() {
        this.testSequentialLongAccess(false);
    }

    private void testSequentialLongAccess(boolean testBigEndian) {
        long value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); i += 8) {
            value = this.random.nextLong();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isWritable()).isTrue();
            if (testBigEndian) {
                this.buffer.writeLong(value);
                continue;
            }
            this.buffer.writeLongLE(value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((boolean)this.buffer.isWritable()).isFalse();
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); i += 8) {
            value = this.random.nextLong();
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((boolean)this.buffer.isReadable()).isTrue();
            if (testBigEndian) {
                Assertions.assertThat((long)this.buffer.readLong()).isEqualTo(value);
                continue;
            }
            Assertions.assertThat((long)this.buffer.readLongLE()).isEqualTo(value);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((boolean)this.buffer.isReadable()).isFalse();
        Assertions.assertThat((boolean)this.buffer.isWritable()).isFalse();
    }

    @Test
    void testByteArrayTransfer() {
        byte[] value = new byte[256];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value);
            this.buffer.setBytes(i, value, this.random.nextInt(128), 128);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValue = new byte[256];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue);
            int valueOffset = this.random.nextInt(128);
            this.buffer.getBytes(i, value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assertions.assertThat((byte)value[j]).isEqualTo(expectedValue[j]);
            }
        }
    }

    @Test
    void testRandomByteArrayTransfer1() {
        byte[] value = new byte[128];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value);
            this.buffer.setBytes(i, value);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[128];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            this.buffer.getBytes(i, value);
            for (int j = 0; j < 128; ++j) {
                Assertions.assertThat((byte)value[j]).isEqualTo(expectedValue.getByte(j));
            }
        }
    }

    @Test
    void testRandomByteArrayTransfer2() {
        byte[] value = new byte[256];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value);
            this.buffer.setBytes(i, value, this.random.nextInt(128), 128);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            this.buffer.getBytes(i, value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assertions.assertThat((byte)value[j]).isEqualTo(expectedValue.getByte(j));
            }
        }
    }

    @Test
    void testRandomHeapBufferTransfer1() {
        byte[] valueContent = new byte[128];
        ByteBuf value = Unpooled.wrappedBuffer((byte[])valueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            value.setIndex(0, 128);
            this.buffer.setBytes(i, value);
            Assertions.assertThat((int)value.readerIndex()).isEqualTo(128);
            Assertions.assertThat((int)value.writerIndex()).isEqualTo(128);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[128];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            value.clear();
            this.buffer.getBytes(i, value);
            Assertions.assertThat((int)value.readerIndex()).isZero();
            Assertions.assertThat((int)value.writerIndex()).isEqualTo(128);
            for (int j = 0; j < 128; ++j) {
                Assertions.assertThat((byte)value.getByte(j)).isEqualTo(expectedValue.getByte(j));
            }
        }
    }

    @Test
    void testRandomHeapBufferTransfer2() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.wrappedBuffer((byte[])valueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            this.buffer.setBytes(i, value, this.random.nextInt(128), 128);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            this.buffer.getBytes(i, value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assertions.assertThat((byte)value.getByte(j)).isEqualTo(expectedValue.getByte(j));
            }
        }
    }

    @Test
    void testRandomDirectBufferTransfer() {
        byte[] tmp = new byte[256];
        ByteBuf value = Unpooled.directBuffer((int)256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(tmp);
            value.setBytes(0, tmp, 0, value.capacity());
            this.buffer.setBytes(i, value, this.random.nextInt(128), 128);
        }
        this.random.setSeed(this.seed);
        ByteBuf expectedValue = Unpooled.directBuffer((int)256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(tmp);
            expectedValue.setBytes(0, tmp, 0, expectedValue.capacity());
            int valueOffset = this.random.nextInt(128);
            this.buffer.getBytes(i, value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assertions.assertThat((byte)value.getByte(j)).isEqualTo(expectedValue.getByte(j));
            }
        }
        value.release();
        expectedValue.release();
    }

    @Test
    void testRandomByteBufferTransfer() {
        ByteBuffer value = ByteBuffer.allocate(256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value.array());
            value.clear().position(this.random.nextInt(128));
            value.limit(value.position() + 128);
            this.buffer.setBytes(i, value);
        }
        this.random.setSeed(this.seed);
        ByteBuffer expectedValue = ByteBuffer.allocate(256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue.array());
            int valueOffset = this.random.nextInt(128);
            value.clear().position(valueOffset).limit(valueOffset + 128);
            this.buffer.getBytes(i, value);
            Assertions.assertThat((int)value.position()).isEqualTo(valueOffset + 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assertions.assertThat((byte)value.get(j)).isEqualTo(expectedValue.get(j));
            }
        }
    }

    @Test
    void testSequentialByteArrayTransfer1() {
        byte[] value = new byte[128];
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value);
            Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            this.buffer.writeBytes(value);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValue = new byte[128];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue);
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(4096);
            this.buffer.readBytes(value);
            for (int j = 0; j < 128; ++j) {
                Assertions.assertThat((byte)value[j]).isEqualTo(expectedValue[j]);
            }
        }
    }

    @Test
    void testSequentialByteArrayTransfer2() {
        byte[] value = new byte[256];
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value);
            Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            int readerIndex = this.random.nextInt(128);
            this.buffer.writeBytes(value, readerIndex, 128);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValue = new byte[256];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue);
            int valueOffset = this.random.nextInt(128);
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(4096);
            this.buffer.readBytes(value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assertions.assertThat((byte)value[j]).isEqualTo(expectedValue[j]);
            }
        }
    }

    @Test
    void testSequentialHeapBufferTransfer1() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.wrappedBuffer((byte[])valueContent);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            this.buffer.writeBytes(value, this.random.nextInt(128), 128);
            Assertions.assertThat((int)value.readerIndex()).isZero();
            Assertions.assertThat((int)value.writerIndex()).isEqualTo(valueContent.length);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(4096);
            this.buffer.readBytes(value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assertions.assertThat((byte)value.getByte(j)).isEqualTo(expectedValue.getByte(j));
            }
            Assertions.assertThat((int)value.readerIndex()).isZero();
            Assertions.assertThat((int)value.writerIndex()).isEqualTo(valueContent.length);
        }
    }

    @Test
    void testSequentialHeapBufferTransfer2() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.wrappedBuffer((byte[])valueContent);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            int readerIndex = this.random.nextInt(128);
            value.readerIndex(readerIndex);
            value.writerIndex(readerIndex + 128);
            this.buffer.writeBytes(value);
            Assertions.assertThat((int)value.writerIndex()).isEqualTo(readerIndex + 128);
            Assertions.assertThat((int)value.readerIndex()).isEqualTo(value.writerIndex());
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(4096);
            value.readerIndex(valueOffset);
            value.writerIndex(valueOffset);
            this.buffer.readBytes(value, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assertions.assertThat((byte)value.getByte(j)).isEqualTo(expectedValue.getByte(j));
            }
            Assertions.assertThat((int)value.readerIndex()).isEqualTo(valueOffset);
            Assertions.assertThat((int)value.writerIndex()).isEqualTo(valueOffset + 128);
        }
    }

    @Test
    void testSequentialDirectBufferTransfer1() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.directBuffer((int)256);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            value.setBytes(0, valueContent);
            Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            this.buffer.writeBytes(value, this.random.nextInt(128), 128);
            Assertions.assertThat((int)value.readerIndex()).isZero();
            Assertions.assertThat((int)value.writerIndex()).isZero();
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            value.setBytes(0, valueContent);
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(4096);
            this.buffer.readBytes(value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assertions.assertThat((byte)value.getByte(j)).isEqualTo(expectedValue.getByte(j));
            }
            Assertions.assertThat((int)value.readerIndex()).isZero();
            Assertions.assertThat((int)value.writerIndex()).isZero();
        }
        value.release();
        expectedValue.release();
    }

    @Test
    void testSequentialDirectBufferTransfer2() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.directBuffer((int)256);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            value.setBytes(0, valueContent);
            Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            int readerIndex = this.random.nextInt(128);
            value.readerIndex(0);
            value.writerIndex(readerIndex + 128);
            value.readerIndex(readerIndex);
            this.buffer.writeBytes(value);
            Assertions.assertThat((int)value.writerIndex()).isEqualTo(readerIndex + 128);
            Assertions.assertThat((int)value.readerIndex()).isEqualTo(value.writerIndex());
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            value.setBytes(0, valueContent);
            int valueOffset = this.random.nextInt(128);
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(4096);
            value.readerIndex(valueOffset);
            value.writerIndex(valueOffset);
            this.buffer.readBytes(value, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assertions.assertThat((byte)value.getByte(j)).isEqualTo(expectedValue.getByte(j));
            }
            Assertions.assertThat((int)value.readerIndex()).isEqualTo(valueOffset);
            Assertions.assertThat((int)value.writerIndex()).isEqualTo(valueOffset + 128);
        }
        value.release();
        expectedValue.release();
    }

    @Test
    void testSequentialByteBufferBackedHeapBufferTransfer1() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.wrappedBuffer((ByteBuffer)ByteBuffer.allocate(256));
        value.writerIndex(0);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            value.setBytes(0, valueContent);
            Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            this.buffer.writeBytes(value, this.random.nextInt(128), 128);
            Assertions.assertThat((int)value.readerIndex()).isZero();
            Assertions.assertThat((int)value.writerIndex()).isZero();
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            value.setBytes(0, valueContent);
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(4096);
            this.buffer.readBytes(value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assertions.assertThat((byte)value.getByte(j)).isEqualTo(expectedValue.getByte(j));
            }
            Assertions.assertThat((int)value.readerIndex()).isZero();
            Assertions.assertThat((int)value.writerIndex()).isZero();
        }
    }

    @Test
    void testSequentialByteBufferBackedHeapBufferTransfer2() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.wrappedBuffer((ByteBuffer)ByteBuffer.allocate(256));
        value.writerIndex(0);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            value.setBytes(0, valueContent);
            Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            int readerIndex = this.random.nextInt(128);
            value.readerIndex(0);
            value.writerIndex(readerIndex + 128);
            value.readerIndex(readerIndex);
            this.buffer.writeBytes(value);
            Assertions.assertThat((int)value.writerIndex()).isEqualTo(readerIndex + 128);
            Assertions.assertThat((int)value.readerIndex()).isEqualTo(value.writerIndex());
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            value.setBytes(0, valueContent);
            int valueOffset = this.random.nextInt(128);
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(4096);
            value.readerIndex(valueOffset);
            value.writerIndex(valueOffset);
            this.buffer.readBytes(value, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assertions.assertThat((byte)value.getByte(j)).isEqualTo(expectedValue.getByte(j));
            }
            Assertions.assertThat((int)value.readerIndex()).isEqualTo(valueOffset);
            Assertions.assertThat((int)value.writerIndex()).isEqualTo(valueOffset + 128);
        }
    }

    @Test
    void testSequentialByteBufferTransfer() {
        this.buffer.writerIndex(0);
        ByteBuffer value = ByteBuffer.allocate(256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value.array());
            value.clear().position(this.random.nextInt(128));
            value.limit(value.position() + 128);
            this.buffer.writeBytes(value);
        }
        this.random.setSeed(this.seed);
        ByteBuffer expectedValue = ByteBuffer.allocate(256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue.array());
            int valueOffset = this.random.nextInt(128);
            value.clear().position(valueOffset).limit(valueOffset + 128);
            this.buffer.readBytes(value);
            Assertions.assertThat((int)value.position()).isEqualTo(valueOffset + 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assertions.assertThat((byte)value.get(j)).isEqualTo(expectedValue.get(j));
            }
        }
    }

    @Test
    void testSequentialCopiedBufferTransfer1() {
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            byte[] value = new byte[128];
            this.random.nextBytes(value);
            Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            this.buffer.writeBytes(value);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValue = new byte[128];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue);
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(4096);
            ByteBuf actualValue = this.buffer.readBytes(128);
            Assertions.assertThat((Comparable)actualValue).isEqualTo((Object)Unpooled.wrappedBuffer((byte[])expectedValue));
            actualValue.setByte(0, (int)((byte)(actualValue.getByte(0) + 1)));
            Assertions.assertThat((this.buffer.getByte(i) == actualValue.getByte(0) ? 1 : 0) != 0).isFalse();
            actualValue.release();
        }
    }

    @Test
    void testSequentialSlice1() {
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            byte[] value = new byte[128];
            this.random.nextBytes(value);
            Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            this.buffer.writeBytes(value);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValue = new byte[128];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue);
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(4096);
            ByteBuf actualValue = this.buffer.readSlice(128);
            Assertions.assertThat((Object)actualValue.order()).isEqualTo((Object)this.buffer.order());
            Assertions.assertThat((Comparable)actualValue).isEqualTo((Object)Unpooled.wrappedBuffer((byte[])expectedValue));
            actualValue.setByte(0, (int)((byte)(actualValue.getByte(0) + 1)));
            Assertions.assertThat((byte)actualValue.getByte(0)).isEqualTo(this.buffer.getByte(i));
        }
    }

    @Test
    void testWriteZero() {
        int i;
        int length;
        Assertions.assertThatThrownBy(() -> this.buffer.writeZero(-1)).isInstanceOf(IllegalArgumentException.class);
        this.buffer.clear();
        while (this.buffer.isWritable()) {
            this.buffer.writeByte(-1);
        }
        this.buffer.clear();
        for (i = 0; i < this.buffer.capacity(); i += length) {
            length = Math.min(this.buffer.capacity() - i, this.random.nextInt(32));
            this.buffer.writeZero(length);
        }
        Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(this.buffer.capacity());
        for (i = 0; i < this.buffer.capacity(); ++i) {
            Assertions.assertThat((byte)this.buffer.getByte(i)).isZero();
        }
    }

    @Test
    void testDiscardReadBytes() {
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity(); i += 4) {
            this.buffer.writeInt(i);
        }
        ByteBuf copy = Unpooled.copiedBuffer((ByteBuf)this.buffer);
        this.buffer.readerIndex(1024);
        this.buffer.markReaderIndex();
        this.buffer.writerIndex(1365);
        this.buffer.markWriterIndex();
        this.buffer.readerIndex(0);
        this.buffer.writerIndex(2048);
        this.buffer.discardReadBytes();
        Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(2048);
        Assertions.assertThat((Comparable)this.buffer.slice(0, 2048)).isEqualTo((Object)copy.slice(0, 2048));
        this.buffer.resetReaderIndex();
        Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(1024);
        this.buffer.resetWriterIndex();
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(1365);
        this.buffer.readerIndex(1);
        this.buffer.writerIndex(2048);
        this.buffer.discardReadBytes();
        Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(2047);
        Assertions.assertThat((Comparable)this.buffer.slice(0, 2047)).isEqualTo((Object)copy.slice(1, 2047));
        if (this.discardReadBytesDoesNotMoveWritableBytes()) {
            Assertions.assertThat((boolean)copy.slice(2048, 2048).equals((Object)this.buffer.slice(2047, 2048))).isFalse();
        } else {
            Assertions.assertThat((Comparable)this.buffer.slice(2047, 2048)).isEqualTo((Object)copy.slice(2048, 2048));
        }
        this.buffer.resetReaderIndex();
        Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(1023);
        this.buffer.resetWriterIndex();
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(1364);
        copy.release();
    }

    @Test
    void testDiscardReadBytes2() {
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity(); ++i) {
            this.buffer.writeByte((int)((byte)i));
        }
        ByteBuf copy = Unpooled.copiedBuffer((ByteBuf)this.buffer);
        this.buffer.setIndex(2047, 4095);
        this.buffer.discardReadBytes();
        Assertions.assertThat((int)this.buffer.readerIndex()).isZero();
        Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(2048);
        for (int i = 0; i < 2048; ++i) {
            Assertions.assertThat((Comparable)this.buffer.slice(i, 2048 - i)).isEqualTo((Object)copy.slice(2047 + i, 2048 - i));
        }
        copy.release();
    }

    @Test
    void testStreamTransfer1() throws Exception {
        byte[] expected = new byte[this.buffer.capacity()];
        this.random.nextBytes(expected);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            ByteArrayInputStream in = new ByteArrayInputStream(expected, i, 128);
            Assertions.assertThat((int)this.buffer.setBytes(i, (InputStream)in, 128)).isEqualTo(128);
            Assertions.assertThat((int)this.buffer.setBytes(i, (InputStream)in, 0)).isEqualTo(-1);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.buffer.getBytes(i, (OutputStream)out, 128);
        }
        Assertions.assertThat((boolean)Arrays.equals(expected, out.toByteArray())).isTrue();
    }

    @Test
    void testStreamTransfer2() throws Exception {
        byte[] expected = new byte[this.buffer.capacity()];
        this.random.nextBytes(expected);
        this.buffer.clear();
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            ByteArrayInputStream in = new ByteArrayInputStream(expected, i, 128);
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i);
            this.buffer.writeBytes((InputStream)in, 128);
            Assertions.assertThat((int)this.buffer.writerIndex()).isEqualTo(i + 128);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i);
            this.buffer.readBytes((OutputStream)out, 128);
            Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(i + 128);
        }
        Assertions.assertThat((boolean)Arrays.equals(expected, out.toByteArray())).isTrue();
    }

    @Test
    void testCopy() {
        for (int i = 0; i < this.buffer.capacity(); ++i) {
            byte value = (byte)this.random.nextInt();
            this.buffer.setByte(i, (int)value);
        }
        int readerIndex = 1365;
        int writerIndex = 2730;
        this.buffer.setIndex(1365, 2730);
        ByteBuf copy = this.buffer.copy();
        Assertions.assertThat((int)copy.readerIndex()).isZero();
        Assertions.assertThat((int)copy.writerIndex()).isEqualTo(this.buffer.readableBytes());
        Assertions.assertThat((int)copy.capacity()).isEqualTo(this.buffer.readableBytes());
        Assertions.assertThat((Object)copy.order()).isSameAs((Object)this.buffer.order());
        for (int i = 0; i < copy.capacity(); ++i) {
            Assertions.assertThat((byte)copy.getByte(i)).isEqualTo(this.buffer.getByte(i + 1365));
        }
        this.buffer.setByte(1365, (int)((byte)(this.buffer.getByte(1365) + 1)));
        Assertions.assertThat((this.buffer.getByte(1365) != copy.getByte(0) ? 1 : 0) != 0).isTrue();
        copy.setByte(1, (int)((byte)(copy.getByte(1) + 1)));
        Assertions.assertThat((this.buffer.getByte(1366) != copy.getByte(1) ? 1 : 0) != 0).isTrue();
        copy.release();
    }

    @Test
    void testDuplicate() {
        for (int i = 0; i < this.buffer.capacity(); ++i) {
            byte value = (byte)this.random.nextInt();
            this.buffer.setByte(i, (int)value);
        }
        int readerIndex = 1365;
        int writerIndex = 2730;
        this.buffer.setIndex(1365, 2730);
        ByteBuf duplicate = this.buffer.duplicate();
        Assertions.assertThat((Object)duplicate.order()).isSameAs((Object)this.buffer.order());
        Assertions.assertThat((int)duplicate.readableBytes()).isEqualTo(this.buffer.readableBytes());
        Assertions.assertThat((Comparable)this.buffer).isEqualTo((Object)duplicate);
        this.buffer.setByte(1365, (int)((byte)(this.buffer.getByte(1365) + 1)));
        Assertions.assertThat((byte)duplicate.getByte(duplicate.readerIndex())).isEqualTo(this.buffer.getByte(1365));
        duplicate.setByte(duplicate.readerIndex(), (int)((byte)(duplicate.getByte(duplicate.readerIndex()) + 1)));
        Assertions.assertThat((byte)duplicate.getByte(duplicate.readerIndex())).isEqualTo(this.buffer.getByte(1365));
    }

    @Test
    void testSliceEndianness() {
        Assertions.assertThat((Object)this.buffer.slice(0, this.buffer.capacity()).order()).isEqualTo((Object)this.buffer.order());
        Assertions.assertThat((Object)this.buffer.slice(0, this.buffer.capacity() - 1).order()).isEqualTo((Object)this.buffer.order());
        Assertions.assertThat((Object)this.buffer.slice(1, this.buffer.capacity() - 1).order()).isEqualTo((Object)this.buffer.order());
        Assertions.assertThat((Object)this.buffer.slice(1, this.buffer.capacity() - 2).order()).isEqualTo((Object)this.buffer.order());
    }

    @Test
    void testSliceIndex() {
        Assertions.assertThat((int)this.buffer.slice(0, this.buffer.capacity()).readerIndex()).isZero();
        Assertions.assertThat((int)this.buffer.slice(0, this.buffer.capacity() - 1).readerIndex()).isZero();
        Assertions.assertThat((int)this.buffer.slice(1, this.buffer.capacity() - 1).readerIndex()).isZero();
        Assertions.assertThat((int)this.buffer.slice(1, this.buffer.capacity() - 2).readerIndex()).isZero();
        Assertions.assertThat((int)this.buffer.slice(0, this.buffer.capacity()).writerIndex()).isEqualTo(this.buffer.capacity());
        Assertions.assertThat((int)this.buffer.slice(0, this.buffer.capacity() - 1).writerIndex()).isEqualTo(this.buffer.capacity() - 1);
        Assertions.assertThat((int)this.buffer.slice(1, this.buffer.capacity() - 1).writerIndex()).isEqualTo(this.buffer.capacity() - 1);
        Assertions.assertThat((int)this.buffer.slice(1, this.buffer.capacity() - 2).writerIndex()).isEqualTo(this.buffer.capacity() - 2);
    }

    @Test
    void testRetainedSliceIndex() {
        ByteBuf retainedSlice = this.buffer.retainedSlice(0, this.buffer.capacity());
        Assertions.assertThat((int)retainedSlice.readerIndex()).isZero();
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(0, this.buffer.capacity() - 1);
        Assertions.assertThat((int)retainedSlice.readerIndex()).isZero();
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(1, this.buffer.capacity() - 1);
        Assertions.assertThat((int)retainedSlice.readerIndex()).isZero();
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(1, this.buffer.capacity() - 2);
        Assertions.assertThat((int)retainedSlice.readerIndex()).isZero();
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(0, this.buffer.capacity());
        Assertions.assertThat((int)retainedSlice.writerIndex()).isEqualTo(this.buffer.capacity());
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(0, this.buffer.capacity() - 1);
        Assertions.assertThat((int)retainedSlice.writerIndex()).isEqualTo(this.buffer.capacity() - 1);
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(1, this.buffer.capacity() - 1);
        Assertions.assertThat((int)retainedSlice.writerIndex()).isEqualTo(this.buffer.capacity() - 1);
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(1, this.buffer.capacity() - 2);
        Assertions.assertThat((int)retainedSlice.writerIndex()).isEqualTo(this.buffer.capacity() - 2);
        retainedSlice.release();
    }

    @Test
    void testEquals() {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.buffer).isNotEqualTo(null)).isNotEqualTo(new Object());
        byte[] value = new byte[32];
        this.buffer.setIndex(0, value.length);
        this.random.nextBytes(value);
        this.buffer.setBytes(0, value);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)Unpooled.wrappedBuffer((byte[])value)).isEqualTo((Object)Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN))).isEqualTo((Object)this.buffer);
        value[0] = (byte)(value[0] + 1);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.buffer).isNotEqualTo((Object)Unpooled.wrappedBuffer((byte[])value))).isNotEqualTo((Object)Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN));
    }

    @Test
    void testCompareTo() {
        Assertions.assertThatThrownBy(() -> this.buffer.compareTo(null)).isInstanceOf(NullPointerException.class);
        byte[] value = new byte[32];
        this.random.nextBytes(value);
        if (value[0] == 0) {
            value[0] = (byte)(value[0] + 1);
        } else if (value[0] == -1) {
            value[0] = (byte)(value[0] - 1);
        }
        this.buffer.setIndex(0, value.length);
        this.buffer.setBytes(0, value);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.buffer).isEqualTo((Object)Unpooled.wrappedBuffer((byte[])value))).isEqualTo((Object)Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN));
        value[0] = (byte)(value[0] + 1);
        Assertions.assertThat((Comparable)this.buffer).isLessThan((Comparable)Unpooled.wrappedBuffer((byte[])value)).isLessThan((Comparable)Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN));
        value[0] = (byte)(value[0] - 2);
        Assertions.assertThat((Comparable)this.buffer).isGreaterThan((Comparable)Unpooled.wrappedBuffer((byte[])value)).isGreaterThan((Comparable)Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN));
        value[0] = (byte)(value[0] + 1);
        Assertions.assertThat((Comparable)this.buffer).isGreaterThan((Comparable)Unpooled.wrappedBuffer((byte[])value, (int)0, (int)31)).isGreaterThan((Comparable)Unpooled.wrappedBuffer((byte[])value, (int)0, (int)31).order(Unpooled.LITTLE_ENDIAN));
        Assertions.assertThat((Comparable)this.buffer.slice(0, 31)).isLessThan((Comparable)Unpooled.wrappedBuffer((byte[])value)).isLessThan((Comparable)Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN));
        ByteBuf retainedSlice = this.buffer.retainedSlice(0, 31);
        Assertions.assertThat((Comparable)retainedSlice).isLessThan((Comparable)Unpooled.wrappedBuffer((byte[])value));
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(0, 31);
        Assertions.assertThat((Comparable)retainedSlice).isLessThan((Comparable)Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN));
        retainedSlice.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCompareTo2() {
        byte[] bytes = new byte[]{1, 2, 3, 4};
        byte[] bytesReversed = new byte[]{4, 3, 2, 1};
        ByteBuf buf1 = this.newBuffer(4).clear().writeBytes(bytes).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuf buf2 = this.newBuffer(4).clear().writeBytes(bytesReversed).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuf buf3 = this.newBuffer(4).clear().writeBytes(bytes).order(ByteOrder.BIG_ENDIAN);
        ByteBuf buf4 = this.newBuffer(4).clear().writeBytes(bytesReversed).order(ByteOrder.BIG_ENDIAN);
        try {
            Assertions.assertThat((int)buf3.compareTo(buf4)).isEqualTo(buf1.compareTo(buf2));
            Assertions.assertThat((int)buf4.compareTo(buf3)).isEqualTo(buf2.compareTo(buf1));
            Assertions.assertThat((int)buf2.compareTo(buf4)).isEqualTo(buf1.compareTo(buf3));
            Assertions.assertThat((int)buf4.compareTo(buf2)).isEqualTo(buf3.compareTo(buf1));
        }
        finally {
            buf1.release();
            buf2.release();
            buf3.release();
            buf4.release();
        }
    }

    @Test
    void testToString() {
        ByteBuf copied = Unpooled.copiedBuffer((CharSequence)"Hello, World!", (Charset)CharsetUtil.ISO_8859_1);
        this.buffer.clear();
        this.buffer.writeBytes(copied);
        Assertions.assertThat((String)this.buffer.toString(CharsetUtil.ISO_8859_1)).isEqualTo("Hello, World!");
        copied.release();
    }

    @Test
    @Timeout(value=10L)
    void testToStringMultipleThreads() throws Throwable {
        this.buffer.clear();
        this.buffer.writeBytes("Hello, World!".getBytes(CharsetUtil.ISO_8859_1));
        final AtomicInteger counter = new AtomicInteger(30000);
        final AtomicReference errorRef = new AtomicReference();
        ArrayList<1> threads = new ArrayList<1>();
        for (int i = 0; i < 10; ++i) {
            CheckedThread checkedThread = new CheckedThread(){

                public void go() {
                    while (errorRef.get() == null && counter.decrementAndGet() > 0) {
                        Assertions.assertThat((String)AbstractByteBufTest.this.buffer.toString(CharsetUtil.ISO_8859_1)).isEqualTo("Hello, World!");
                    }
                }
            };
            threads.add(checkedThread);
            checkedThread.start();
        }
        for (CheckedThread checkedThread : threads) {
            checkedThread.sync();
        }
    }

    @Test
    void testIndexOf() {
        this.buffer.clear();
        this.buffer.writeByte(1);
        this.buffer.writeByte(2);
        this.buffer.writeByte(3);
        this.buffer.writeByte(2);
        this.buffer.writeByte(1);
        Assertions.assertThat((int)this.buffer.indexOf(1, 4, (byte)1)).isEqualTo(-1);
        Assertions.assertThat((int)this.buffer.indexOf(4, 1, (byte)1)).isEqualTo(-1);
        Assertions.assertThat((int)this.buffer.indexOf(1, 4, (byte)2)).isOne();
        Assertions.assertThat((int)this.buffer.indexOf(4, 1, (byte)2)).isEqualTo(3);
    }

    @Test
    void testNioBuffer1() {
        Assumptions.assumeThat((int)this.buffer.nioBufferCount()).isOne();
        byte[] value = new byte[this.buffer.capacity()];
        this.random.nextBytes(value);
        this.buffer.clear();
        this.buffer.writeBytes(value);
        AbstractByteBufTest.assertRemainingEquals(ByteBuffer.wrap(value), this.buffer.nioBuffer());
    }

    @Test
    void testToByteBuffer2() {
        Assumptions.assumeThat((int)this.buffer.nioBufferCount()).isOne();
        byte[] value = new byte[this.buffer.capacity()];
        this.random.nextBytes(value);
        this.buffer.clear();
        this.buffer.writeBytes(value);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            AbstractByteBufTest.assertRemainingEquals(ByteBuffer.wrap(value, i, 128), this.buffer.nioBuffer(i, 128));
        }
    }

    private static void assertRemainingEquals(ByteBuffer expected, ByteBuffer actual) {
        int remaining = expected.remaining();
        int remaining2 = actual.remaining();
        Assumptions.assumeThat((int)remaining2).isEqualTo(remaining);
        byte[] array1 = new byte[remaining];
        byte[] array2 = new byte[remaining2];
        expected.get(array1);
        actual.get(array2);
        Assertions.assertThat((byte[])array2).isEqualTo((Object)array1);
    }

    @Test
    void testToByteBuffer3() {
        Assumptions.assumeThat((int)this.buffer.nioBufferCount()).isOne();
        Assertions.assertThat((Object)this.buffer.nioBuffer().order()).isEqualTo((Object)this.buffer.order());
    }

    @Test
    void testSkipBytes1() {
        this.buffer.setIndex(1024, 2048);
        this.buffer.skipBytes(1024);
        Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(2048);
        Assertions.assertThatThrownBy(() -> this.buffer.skipBytes(1025)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThat((int)this.buffer.readerIndex()).isEqualTo(2048);
    }

    @Test
    void testHashCode() {
        ByteBuf elemA = Unpooled.buffer((int)15);
        ByteBuf elemB = Unpooled.directBuffer((int)15);
        elemA.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5});
        elemB.writeBytes(new byte[]{6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 9});
        HashSet<ByteBuf> set = new HashSet<ByteBuf>();
        set.add(elemA);
        set.add(elemB);
        Assertions.assertThat(set).hasSize(2);
        ByteBuf elemACopy = elemA.copy();
        Assertions.assertThat(set).contains((Object[])new ByteBuf[]{elemACopy});
        ByteBuf elemBCopy = elemB.copy();
        Assertions.assertThat(set).contains((Object[])new ByteBuf[]{elemBCopy});
        this.buffer.clear();
        this.buffer.writeBytes(elemA.duplicate());
        Assertions.assertThat((boolean)set.remove(this.buffer)).isTrue();
        ((AbstractCollectionAssert)Assertions.assertThat(set).doesNotContainSequence((Object[])new ByteBuf[]{elemA})).hasSize(1);
        this.buffer.clear();
        this.buffer.writeBytes(elemB.duplicate());
        Assertions.assertThat((boolean)set.remove(this.buffer)).isTrue();
        ((AbstractCollectionAssert)Assertions.assertThat(set).doesNotContainSequence((Object[])new ByteBuf[]{elemB})).isEmpty();
        elemA.release();
        elemB.release();
        elemACopy.release();
        elemBCopy.release();
    }

    @Test
    void testDiscardAllReadBytes() {
        this.buffer.writerIndex(this.buffer.capacity());
        this.buffer.readerIndex(this.buffer.writerIndex());
        this.buffer.discardReadBytes();
    }

    @Test
    void testForEachByte() {
        this.buffer.clear();
        for (int i = 0; i < 4096; ++i) {
            this.buffer.writeByte(i + 1);
        }
        final AtomicInteger lastIndex = new AtomicInteger();
        this.buffer.setIndex(1024, 3072);
        Assertions.assertThat((int)this.buffer.forEachByte(new ByteProcessor(){
            int i = 1024;

            public boolean process(byte value) {
                Assertions.assertThat((byte)value).isEqualTo((byte)(this.i + 1));
                lastIndex.set(this.i);
                ++this.i;
                return true;
            }
        })).isEqualTo(-1);
        Assertions.assertThat((AtomicInteger)lastIndex).hasValue(3071);
    }

    @Test
    void testForEachByteAbort() {
        this.buffer.clear();
        for (int i = 0; i < 4096; ++i) {
            this.buffer.writeByte(i + 1);
        }
        int stop = 2048;
        Assertions.assertThat((int)this.buffer.forEachByte(1365, 1365, new ByteProcessor(){
            int i = 1365;

            public boolean process(byte value) {
                Assertions.assertThat((byte)value).isEqualTo((byte)(this.i + 1));
                if (this.i == 2048) {
                    return false;
                }
                ++this.i;
                return true;
            }
        })).isEqualTo(2048);
    }

    @Test
    void testForEachByteDesc() {
        this.buffer.clear();
        for (int i = 0; i < 4096; ++i) {
            this.buffer.writeByte(i + 1);
        }
        final AtomicInteger lastIndex = new AtomicInteger();
        Assertions.assertThat((int)this.buffer.forEachByteDesc(1024, 2048, new ByteProcessor(){
            int i = 3071;

            public boolean process(byte value) {
                Assertions.assertThat((byte)value).isEqualTo((byte)(this.i + 1));
                lastIndex.set(this.i);
                --this.i;
                return true;
            }
        })).isEqualTo(-1);
        Assertions.assertThat((AtomicInteger)lastIndex).hasValue(1024);
    }

    @Test
    void testInternalNioBuffer() {
        this.testInternalNioBuffer(128);
        this.testInternalNioBuffer(1024);
        this.testInternalNioBuffer(4096);
        this.testInternalNioBuffer(65536);
        this.testInternalNioBuffer(0x2000000);
        this.testInternalNioBuffer(0x4000000);
    }

    private void testInternalNioBuffer(int a) {
        ByteBuf buffer = this.newBuffer(2);
        ByteBuffer buf = buffer.internalNioBuffer(buffer.readerIndex(), 1);
        Assertions.assertThat((int)buf.remaining()).isOne();
        byte[] data = new byte[a];
        PlatformDependent.threadLocalRandom().nextBytes(data);
        buffer.writeBytes(data);
        buf = buffer.internalNioBuffer(buffer.readerIndex(), a);
        Assertions.assertThat((int)buf.remaining()).isEqualTo(a);
        for (int i = 0; i < a; ++i) {
            Assertions.assertThat((byte)buf.get()).isEqualTo(data[i]);
        }
        Assertions.assertThat((boolean)buf.hasRemaining()).isFalse();
        buffer.release();
    }

    @Test
    void testDuplicateReadGatheringByteChannelMultipleThreads() throws Exception {
        this.testReadGatheringByteChannelMultipleThreads(false);
    }

    @Test
    void testSliceReadGatheringByteChannelMultipleThreads() throws Exception {
        this.testReadGatheringByteChannelMultipleThreads(true);
    }

    private void testReadGatheringByteChannelMultipleThreads(boolean slice) throws Exception {
        byte[] bytes = new byte[8];
        this.random.nextBytes(bytes);
        ByteBuf buffer = this.newBuffer(8);
        buffer.writeBytes(bytes);
        CountDownLatch latch = new CountDownLatch(60000);
        CyclicBarrier barrier = new CyclicBarrier(11);
        for (int i = 0; i < 10; ++i) {
            new Thread(() -> {
                while (latch.getCount() > 0L) {
                    ByteBuf buf = slice ? buffer.slice() : buffer.duplicate();
                    TestGatheringByteChannel channel = new TestGatheringByteChannel();
                    while (buf.isReadable()) {
                        try {
                            buf.readBytes((GatheringByteChannel)channel, buf.readableBytes());
                        }
                        catch (IOException e) {
                            return;
                        }
                    }
                    Assertions.assertThat((byte[])channel.writtenBytes()).isEqualTo((Object)bytes);
                    latch.countDown();
                }
                try {
                    barrier.await();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
        }
        Assertions.assertThat((boolean)latch.await(10L, TimeUnit.SECONDS)).isTrue();
        barrier.await(5L, TimeUnit.SECONDS);
        buffer.release();
    }

    @Test
    void testDuplicateReadOutputStreamMultipleThreads() throws Exception {
        this.testReadOutputStreamMultipleThreads(false);
    }

    @Test
    void testSliceReadOutputStreamMultipleThreads() throws Exception {
        this.testReadOutputStreamMultipleThreads(true);
    }

    private void testReadOutputStreamMultipleThreads(boolean slice) throws Exception {
        byte[] bytes = new byte[8];
        this.random.nextBytes(bytes);
        ByteBuf buffer = this.newBuffer(8);
        buffer.writeBytes(bytes);
        CountDownLatch latch = new CountDownLatch(60000);
        CyclicBarrier barrier = new CyclicBarrier(11);
        for (int i = 0; i < 10; ++i) {
            new Thread(() -> {
                while (latch.getCount() > 0L) {
                    ByteBuf buf = slice ? buffer.slice() : buffer.duplicate();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    while (buf.isReadable()) {
                        try {
                            buf.readBytes((OutputStream)out, buf.readableBytes());
                        }
                        catch (IOException e) {
                            return;
                        }
                    }
                    Assertions.assertThat((byte[])out.toByteArray()).isEqualTo((Object)bytes);
                    latch.countDown();
                }
                try {
                    barrier.await();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
        }
        Assertions.assertThat((boolean)latch.await(10L, TimeUnit.SECONDS)).isTrue();
        barrier.await(5L, TimeUnit.SECONDS);
        buffer.release();
    }

    @Test
    void testDuplicateBytesInArrayMultipleThreads() throws Exception {
        this.testBytesInArrayMultipleThreads(false);
    }

    @Test
    void testSliceBytesInArrayMultipleThreads() throws Exception {
        this.testBytesInArrayMultipleThreads(true);
    }

    private void testBytesInArrayMultipleThreads(boolean slice) throws Exception {
        byte[] bytes = new byte[8];
        this.random.nextBytes(bytes);
        ByteBuf buffer = this.newBuffer(8);
        buffer.writeBytes(bytes);
        AtomicReference cause = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(60000);
        CyclicBarrier barrier = new CyclicBarrier(11);
        for (int i = 0; i < 10; ++i) {
            new Thread(() -> {
                while (cause.get() == null && latch.getCount() > 0L) {
                    ByteBuf buf = slice ? buffer.slice() : buffer.duplicate();
                    byte[] array = new byte[8];
                    buf.readBytes(array);
                    Assertions.assertThat((byte[])array).isEqualTo((Object)bytes);
                    Arrays.fill(array, (byte)0);
                    buf.getBytes(0, array);
                    Assertions.assertThat((byte[])array).isEqualTo((Object)bytes);
                    latch.countDown();
                }
                try {
                    barrier.await();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
        }
        Assertions.assertThat((boolean)latch.await(10L, TimeUnit.SECONDS)).isTrue();
        barrier.await(5L, TimeUnit.SECONDS);
        Assertions.assertThat((Throwable)((Throwable)cause.get())).isNull();
        buffer.release();
    }

    @Test
    void readByteThrowsIndexOutOfBoundsException() {
        ByteBuf buffer = this.newBuffer(8);
        try {
            buffer.writeByte(0);
            Assertions.assertThat((byte)buffer.readByte()).isZero();
            Assertions.assertThatThrownBy(() -> ((ByteBuf)buffer).readByte()).isInstanceOf(IndexOutOfBoundsException.class);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    void testNioBufferExposeOnlyRegion() {
        ByteBuf buffer = this.newBuffer(8);
        byte[] data = new byte[8];
        this.random.nextBytes(data);
        buffer.writeBytes(data);
        ByteBuffer nioBuf = buffer.nioBuffer(1, data.length - 2);
        Assertions.assertThat((int)nioBuf.position()).isZero();
        Assertions.assertThat((int)nioBuf.remaining()).isEqualTo(6);
        int i = 1;
        while (nioBuf.hasRemaining()) {
            Assertions.assertThat((byte)nioBuf.get()).isEqualTo(data[i]);
            ++i;
        }
        buffer.release();
    }

    @Test
    void ensureWritableWithForceDoesNotThrow() {
        this.ensureWritableDoesNotThrow(true);
    }

    @Test
    void ensureWritableWithOutForceDoesNotThrow() {
        this.ensureWritableDoesNotThrow(false);
    }

    private void ensureWritableDoesNotThrow(boolean force) {
        ByteBuf buffer = this.newBuffer(8);
        buffer.writerIndex(buffer.capacity());
        buffer.ensureWritable(8, force);
        buffer.release();
    }

    @Test
    void testLittleEndianWithExpand() {
        ByteBuf buffer = this.newBuffer(0).order(Unpooled.LITTLE_ENDIAN);
        buffer.writeInt(305419896);
        Assertions.assertThat((String)ByteBufUtil.hexDump((ByteBuf)buffer)).isEqualTo("78563412");
        buffer.release();
    }

    private ByteBuf releasedBuffer() {
        ByteBuf buffer = this.newBuffer(8);
        buffer.clear();
        Assertions.assertThat((boolean)buffer.release()).isTrue();
        return buffer;
    }

    @Test
    void testDiscardReadBytesAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().discardReadBytes()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testDiscardSomeReadBytesAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().discardSomeReadBytes()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testEnsureWritableAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().ensureWritable(16)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetBooleanAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getBoolean(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetByteAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getByte(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetUnsignedByteAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getUnsignedByte(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetShortAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getShort(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetShortLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getShortLE(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetUnsignedShortAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getUnsignedShort(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetUnsignedShortLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getUnsignedShortLE(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetMediumAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getMedium(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetMediumLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getMediumLE(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetUnsignedMediumAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getUnsignedMedium(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetIntAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getInt(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetIntLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getIntLE(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetUnsignedIntAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getUnsignedInt(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetUnsignedIntLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getUnsignedIntLE(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetLongAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getLong(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetLongLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getLongLE(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetCharAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getChar(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetFloatAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getFloat(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetFloatLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getFloatLE(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetDoubleAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getDouble(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetDoubleLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getDoubleLE(0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetBytesAfterRelease() {
        ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            Assertions.assertThatThrownBy(() -> this.releasedBuffer().getBytes(0, buffer)).isInstanceOf(IllegalReferenceCountException.class);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    void testGetBytesAfterRelease2() {
        ByteBuf buffer = Unpooled.buffer();
        try {
            Assertions.assertThatThrownBy(() -> this.releasedBuffer().getBytes(0, buffer, 1)).isInstanceOf(IllegalReferenceCountException.class);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    void testGetBytesAfterRelease3() {
        ByteBuf buffer = Unpooled.buffer();
        try {
            Assertions.assertThatThrownBy(() -> this.releasedBuffer().getBytes(0, buffer, 0, 1)).isInstanceOf(IllegalReferenceCountException.class);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    void testGetBytesAfterRelease4() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getBytes(0, new byte[8])).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetBytesAfterRelease5() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getBytes(0, new byte[8], 0, 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetBytesAfterRelease6() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getBytes(0, ByteBuffer.allocate(8))).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetBytesAfterRelease7() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getBytes(0, (OutputStream)new ByteArrayOutputStream(), 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testGetBytesAfterRelease8() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().getBytes(0, (GatheringByteChannel)new DevNullGatheringByteChannel(), 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetBooleanAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setBoolean(0, true)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetByteAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setByte(0, 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetShortAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setShort(0, 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetShortLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setShortLE(0, 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetMediumAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setMedium(0, 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetMediumLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setMediumLE(0, 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetIntAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setInt(0, 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetIntLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setIntLE(0, 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetLongAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setLong(0, 1L)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetLongLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setLongLE(0, 1L)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetCharAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setChar(0, 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetFloatAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setFloat(0, 1.0f)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetDoubleAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setDouble(0, 1.0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetBytesAfterRelease() {
        ByteBuf buffer = Unpooled.buffer();
        try {
            Assertions.assertThatThrownBy(() -> this.releasedBuffer().setBytes(0, buffer)).isInstanceOf(IllegalReferenceCountException.class);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    void testSetBytesAfterRelease2() {
        ByteBuf buffer = Unpooled.buffer();
        try {
            Assertions.assertThatThrownBy(() -> this.releasedBuffer().setBytes(0, buffer, 1)).isInstanceOf(IllegalReferenceCountException.class);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    void testSetBytesAfterRelease3() {
        ByteBuf buffer = Unpooled.buffer();
        try {
            Assertions.assertThatThrownBy(() -> this.releasedBuffer().setBytes(0, buffer, 0, 1)).isInstanceOf(IllegalReferenceCountException.class);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    void testSetUsAsciiCharSequenceAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.testSetCharSequenceAfterRelease0(CharsetUtil.US_ASCII)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetIso88591CharSequenceAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.testSetCharSequenceAfterRelease0(CharsetUtil.ISO_8859_1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetUtf8CharSequenceAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.testSetCharSequenceAfterRelease0(CharsetUtil.UTF_8)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetUtf16CharSequenceAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.testSetCharSequenceAfterRelease0(CharsetUtil.UTF_16)).isInstanceOf(IllegalReferenceCountException.class);
    }

    private void testSetCharSequenceAfterRelease0(Charset charset) {
        this.releasedBuffer().setCharSequence(0, (CharSequence)"x", charset);
    }

    @Test
    void testSetBytesAfterRelease4() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setBytes(0, new byte[8])).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetBytesAfterRelease5() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setBytes(0, new byte[8], 0, 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetBytesAfterRelease6() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setBytes(0, ByteBuffer.allocate(8))).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetBytesAfterRelease7() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setBytes(0, (InputStream)new ByteArrayInputStream(new byte[8]), 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetBytesAfterRelease8() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setBytes(0, (ScatteringByteChannel)new TestScatteringByteChannel(), 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSetZeroAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().setZero(0, 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadBooleanAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readBoolean()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadByteAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readByte()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadUnsignedByteAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readUnsignedByte()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadShortAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readShort()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadShortLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readShortLE()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadUnsignedShortAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readUnsignedShort()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadUnsignedShortLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readUnsignedShortLE()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadMediumAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readMedium()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadMediumLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readMediumLE()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadUnsignedMediumAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readUnsignedMedium()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadUnsignedMediumLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readUnsignedMediumLE()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadIntAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readInt()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadIntLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readIntLE()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadUnsignedIntAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readUnsignedInt()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadUnsignedIntLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readUnsignedIntLE()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadLongAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readLong()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadLongLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readLongLE()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadCharAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readChar()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadFloatAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readFloat()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadFloatLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readFloatLE()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadDoubleAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readDouble()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadDoubleLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readDoubleLE()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadBytesAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readBytes(1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadBytesAfterRelease2() {
        ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            Assertions.assertThatThrownBy(() -> this.releasedBuffer().readBytes(buffer)).isInstanceOf(IllegalReferenceCountException.class);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    void testReadBytesAfterRelease3() {
        ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            Assertions.assertThatThrownBy(() -> this.releasedBuffer().readBytes(buffer)).isInstanceOf(IllegalReferenceCountException.class);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    void testReadBytesAfterRelease4() {
        ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            Assertions.assertThatThrownBy(() -> this.releasedBuffer().readBytes(buffer, 0, 1)).isInstanceOf(IllegalReferenceCountException.class);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    void testReadBytesAfterRelease5() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readBytes(new byte[8])).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadBytesAfterRelease6() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readBytes(new byte[8], 0, 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadBytesAfterRelease7() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readBytes(ByteBuffer.allocate(8))).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadBytesAfterRelease8() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readBytes((OutputStream)new ByteArrayOutputStream(), 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadBytesAfterRelease9() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readBytes((OutputStream)new ByteArrayOutputStream(), 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testReadBytesAfterRelease10() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().readBytes((GatheringByteChannel)new DevNullGatheringByteChannel(), 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteBooleanAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeBoolean(true)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteByteAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeByte(1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteShortAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeShort(1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteShortLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeShortLE(1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteMediumAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeMedium(1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteMediumLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeMediumLE(1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteIntAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeInt(1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteIntLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeIntLE(1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteLongAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeLong(1L)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteLongLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeLongLE(1L)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteCharAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeChar(1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteFloatAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeFloat(1.0f)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteFloatLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeFloatLE(1.0f)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteDoubleAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeDouble(1.0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteDoubleLEAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeDoubleLE(1.0)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteBytesAfterRelease() {
        ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeBytes(buffer)).isInstanceOf(IllegalReferenceCountException.class);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    void testWriteBytesAfterRelease2() {
        ByteBuf buffer = Unpooled.copiedBuffer((byte[])new byte[8]);
        try {
            Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeBytes(buffer, 1)).isInstanceOf(IllegalReferenceCountException.class);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    void testWriteBytesAfterRelease3() {
        ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeBytes(buffer, 0, 1)).isInstanceOf(IllegalReferenceCountException.class);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    void testWriteBytesAfterRelease4() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeBytes(new byte[8])).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteBytesAfterRelease5() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeBytes(new byte[8], 0, 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteBytesAfterRelease6() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeBytes(ByteBuffer.allocate(8))).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteBytesAfterRelease7() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeBytes((InputStream)new ByteArrayInputStream(new byte[8]), 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteBytesAfterRelease8() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeBytes((ScatteringByteChannel)new TestScatteringByteChannel(), 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteZeroAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().writeZero(1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteUsAsciiCharSequenceAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.testWriteCharSequenceAfterRelease0(CharsetUtil.US_ASCII)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteIso88591CharSequenceAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.testWriteCharSequenceAfterRelease0(CharsetUtil.ISO_8859_1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteUtf8CharSequenceAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.testWriteCharSequenceAfterRelease0(CharsetUtil.UTF_8)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testWriteUtf16CharSequenceAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.testWriteCharSequenceAfterRelease0(CharsetUtil.UTF_16)).isInstanceOf(IllegalReferenceCountException.class);
    }

    private void testWriteCharSequenceAfterRelease0(Charset charset) {
        this.releasedBuffer().writeCharSequence((CharSequence)"x", charset);
    }

    @Test
    void testForEachByteAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().forEachByte((ByteProcessor)new TestByteProcessor())).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testForEachByteAfterRelease1() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().forEachByte(0, 1, (ByteProcessor)new TestByteProcessor())).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testForEachByteDescAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().forEachByteDesc((ByteProcessor)new TestByteProcessor())).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testForEachByteDescAfterRelease1() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().forEachByteDesc(0, 1, (ByteProcessor)new TestByteProcessor())).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testCopyAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().copy()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testCopyAfterRelease1() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().copy()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testNioBufferAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().nioBuffer()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testNioBufferAfterRelease1() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().nioBuffer(0, 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testInternalNioBufferAfterRelease() {
        ByteBuf releasedBuffer = this.releasedBuffer();
        Assertions.assertThatThrownBy(() -> releasedBuffer.internalNioBuffer(releasedBuffer.readerIndex(), 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testNioBuffersAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().nioBuffers()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testNioBuffersAfterRelease2() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().nioBuffers(0, 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testArrayAfterRelease() {
        ByteBuf buf = this.releasedBuffer();
        if (buf.hasArray()) {
            Assertions.assertThatThrownBy(() -> ((ByteBuf)buf).array()).isInstanceOf(IllegalReferenceCountException.class);
        }
    }

    @Test
    void testMemoryAddressAfterRelease() {
        ByteBuf buf = this.releasedBuffer();
        if (buf.hasMemoryAddress()) {
            Assertions.assertThatThrownBy(() -> ((ByteBuf)buf).memoryAddress()).isInstanceOf(IllegalReferenceCountException.class);
        }
    }

    @Test
    void testSliceAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().slice()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testSliceAfterRelease2() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().slice(0, 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    private static void assertSliceFailAfterRelease(ByteBuf ... bufs) {
        for (ByteBuf buf : bufs) {
            if (buf.refCnt() <= 0) continue;
            buf.release();
        }
        for (ByteBuf buf : bufs) {
            Assertions.assertThat((int)buf.refCnt()).isZero();
            Assertions.assertThatThrownBy(() -> ((ByteBuf)buf).slice()).isInstanceOf(IllegalReferenceCountException.class);
        }
    }

    @Test
    void testSliceAfterReleaseRetainedSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        AbstractByteBufTest.assertSliceFailAfterRelease(buf, buf2);
    }

    @Test
    void testSliceAfterReleaseRetainedSliceDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        ByteBuf buf3 = buf2.duplicate();
        AbstractByteBufTest.assertSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    void testSliceAfterReleaseRetainedSliceRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        ByteBuf buf3 = buf2.retainedDuplicate();
        AbstractByteBufTest.assertSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    void testSliceAfterReleaseRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        AbstractByteBufTest.assertSliceFailAfterRelease(buf, buf2);
    }

    @Test
    void testSliceAfterReleaseRetainedDuplicateSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        ByteBuf buf3 = buf2.slice(0, 1);
        AbstractByteBufTest.assertSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    void testRetainedSliceAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().retainedSlice()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testRetainedSliceAfterRelease2() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().retainedSlice(0, 1)).isInstanceOf(IllegalReferenceCountException.class);
    }

    private static void assertRetainedSliceFailAfterRelease(ByteBuf ... bufs) {
        for (ByteBuf buf : bufs) {
            if (buf.refCnt() <= 0) continue;
            buf.release();
        }
        for (ByteBuf buf : bufs) {
            Assertions.assertThat((int)buf.refCnt()).isZero();
            Assertions.assertThatThrownBy(() -> ((ByteBuf)buf).retainedSlice()).isInstanceOf(IllegalReferenceCountException.class);
        }
    }

    @Test
    void testRetainedSliceAfterReleaseRetainedSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        AbstractByteBufTest.assertRetainedSliceFailAfterRelease(buf, buf2);
    }

    @Test
    void testRetainedSliceAfterReleaseRetainedSliceDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        ByteBuf buf3 = buf2.duplicate();
        AbstractByteBufTest.assertRetainedSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    void testRetainedSliceAfterReleaseRetainedSliceRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        ByteBuf buf3 = buf2.retainedDuplicate();
        AbstractByteBufTest.assertRetainedSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    void testRetainedSliceAfterReleaseRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        AbstractByteBufTest.assertRetainedSliceFailAfterRelease(buf, buf2);
    }

    @Test
    void testRetainedSliceAfterReleaseRetainedDuplicateSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        ByteBuf buf3 = buf2.slice(0, 1);
        AbstractByteBufTest.assertRetainedSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    void testDuplicateAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().duplicate()).isInstanceOf(IllegalReferenceCountException.class);
    }

    @Test
    void testRetainedDuplicateAfterRelease() {
        Assertions.assertThatThrownBy(() -> this.releasedBuffer().retainedDuplicate()).isInstanceOf(IllegalReferenceCountException.class);
    }

    private static void assertDuplicateFailAfterRelease(ByteBuf ... bufs) {
        for (ByteBuf buf : bufs) {
            if (buf.refCnt() <= 0) continue;
            buf.release();
        }
        for (ByteBuf buf : bufs) {
            Assertions.assertThat((int)buf.refCnt()).isZero();
            Assertions.assertThatThrownBy(() -> ((ByteBuf)buf).duplicate()).isInstanceOf(IllegalReferenceCountException.class);
        }
    }

    @Test
    void testDuplicateAfterReleaseRetainedSliceDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        ByteBuf buf3 = buf2.duplicate();
        AbstractByteBufTest.assertDuplicateFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    void testDuplicateAfterReleaseRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        AbstractByteBufTest.assertDuplicateFailAfterRelease(buf, buf2);
    }

    @Test
    void testDuplicateAfterReleaseRetainedDuplicateSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        ByteBuf buf3 = buf2.slice(0, 1);
        AbstractByteBufTest.assertDuplicateFailAfterRelease(buf, buf2, buf3);
    }

    private static void assertRetainedDuplicateFailAfterRelease(ByteBuf ... bufs) {
        for (ByteBuf buf : bufs) {
            if (buf.refCnt() <= 0) continue;
            buf.release();
        }
        for (ByteBuf buf : bufs) {
            Assertions.assertThat((int)buf.refCnt()).isZero();
            Assertions.assertThatThrownBy(() -> ((ByteBuf)buf).retainedDuplicate()).isInstanceOf(IllegalReferenceCountException.class);
        }
    }

    @Test
    void testRetainedDuplicateAfterReleaseRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        AbstractByteBufTest.assertRetainedDuplicateFailAfterRelease(buf, buf2);
    }

    @Test
    void testRetainedDuplicateAfterReleaseDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.duplicate();
        AbstractByteBufTest.assertRetainedDuplicateFailAfterRelease(buf, buf2);
    }

    @Test
    void testRetainedDuplicateAfterReleaseRetainedSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        AbstractByteBufTest.assertRetainedDuplicateFailAfterRelease(buf, buf2);
    }

    @Test
    void testSliceRelease() {
        ByteBuf buf = this.newBuffer(8);
        Assertions.assertThat((int)buf.refCnt()).isOne();
        Assertions.assertThat((boolean)buf.slice().release()).isTrue();
        Assertions.assertThat((int)buf.refCnt()).isZero();
    }

    @Test
    void testReadSliceOutOfBounds() {
        Assertions.assertThatThrownBy(() -> this.testReadSliceOutOfBounds(false)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testReadRetainedSliceOutOfBounds() {
        Assertions.assertThatThrownBy(() -> this.testReadSliceOutOfBounds(true)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    private void testReadSliceOutOfBounds(boolean retainedSlice) {
        ByteBuf buf = this.newBuffer(100);
        try {
            buf.writeZero(50);
            if (retainedSlice) {
                buf.readRetainedSlice(51);
            } else {
                buf.readSlice(51);
            }
        }
        finally {
            buf.release();
        }
    }

    @Test
    void testWriteUsAsciiCharSequenceExpand() {
        this.testWriteCharSequenceExpand(CharsetUtil.US_ASCII);
    }

    @Test
    void testWriteUtf8CharSequenceExpand() {
        this.testWriteCharSequenceExpand(CharsetUtil.UTF_8);
    }

    @Test
    void testWriteIso88591CharSequenceExpand() {
        this.testWriteCharSequenceExpand(CharsetUtil.ISO_8859_1);
    }

    @Test
    void testWriteUtf16CharSequenceExpand() {
        this.testWriteCharSequenceExpand(CharsetUtil.UTF_16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWriteCharSequenceExpand(Charset charset) {
        ByteBuf buf = this.newBuffer(1);
        try {
            int writerIndex = buf.capacity() - 1;
            buf.writerIndex(writerIndex);
            int written = buf.writeCharSequence((CharSequence)"AB", charset);
            Assertions.assertThat((int)(buf.writerIndex() - written)).isEqualTo(writerIndex);
        }
        finally {
            buf.release();
        }
    }

    @Test
    void testSetUsAsciiCharSequenceNoExpand() {
        Assertions.assertThatThrownBy(() -> this.testSetCharSequenceNoExpand(CharsetUtil.US_ASCII)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testSetUtf8CharSequenceNoExpand() {
        Assertions.assertThatThrownBy(() -> this.testSetCharSequenceNoExpand(CharsetUtil.UTF_8)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testSetIso88591CharSequenceNoExpand() {
        Assertions.assertThatThrownBy(() -> this.testSetCharSequenceNoExpand(CharsetUtil.ISO_8859_1)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testSetUtf16CharSequenceNoExpand() {
        Assertions.assertThatThrownBy(() -> this.testSetCharSequenceNoExpand(CharsetUtil.UTF_16)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    private void testSetCharSequenceNoExpand(Charset charset) {
        ByteBuf buf = this.newBuffer(1);
        try {
            buf.setCharSequence(0, (CharSequence)"AB", charset);
        }
        finally {
            buf.release();
        }
    }

    @Test
    void testSetUsAsciiCharSequence() {
        this.testSetGetCharSequence(CharsetUtil.US_ASCII);
    }

    @Test
    void testSetUtf8CharSequence() {
        this.testSetGetCharSequence(CharsetUtil.UTF_8);
    }

    @Test
    void testSetIso88591CharSequence() {
        this.testSetGetCharSequence(CharsetUtil.ISO_8859_1);
    }

    @Test
    void testSetUtf16CharSequence() {
        this.testSetGetCharSequence(CharsetUtil.UTF_16);
    }

    private void testSetGetCharSequence(Charset charset) {
        ByteBuf buf = this.newBuffer(1024);
        CharBuffer sequence = CharsetUtil.US_ASCII.equals(charset) ? ASCII_CHARS : EXTENDED_ASCII_CHARS;
        int bytes = buf.setCharSequence(1, (CharSequence)sequence, charset);
        CharBuffer actual = CharBuffer.wrap(buf.getCharSequence(1, bytes, charset));
        Assertions.assertThat((CharSequence)actual).isEqualTo((Object)sequence);
        buf.release();
    }

    @Test
    void testWriteReadUsAsciiCharSequence() {
        this.testWriteReadCharSequence(CharsetUtil.US_ASCII);
    }

    @Test
    void testWriteReadUtf8CharSequence() {
        this.testWriteReadCharSequence(CharsetUtil.UTF_8);
    }

    @Test
    void testWriteReadIso88591CharSequence() {
        this.testWriteReadCharSequence(CharsetUtil.ISO_8859_1);
    }

    @Test
    void testWriteReadUtf16CharSequence() {
        this.testWriteReadCharSequence(CharsetUtil.UTF_16);
    }

    private void testWriteReadCharSequence(Charset charset) {
        ByteBuf buf = this.newBuffer(1024);
        CharBuffer sequence = CharsetUtil.US_ASCII.equals(charset) ? ASCII_CHARS : EXTENDED_ASCII_CHARS;
        buf.writerIndex(1);
        int bytes = buf.writeCharSequence((CharSequence)sequence, charset);
        buf.readerIndex(1);
        CharBuffer actual = CharBuffer.wrap(buf.readCharSequence(bytes, charset));
        Assertions.assertThat((CharSequence)actual).isEqualTo((Object)sequence);
        buf.release();
    }

    @Test
    void testRetainedSliceIndexOutOfBounds() {
        Assertions.assertThatThrownBy(() -> this.testSliceOutOfBounds(true, true, true)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testRetainedSliceLengthOutOfBounds() {
        Assertions.assertThatThrownBy(() -> this.testSliceOutOfBounds(true, true, false)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testMixedSliceAIndexOutOfBounds() {
        Assertions.assertThatThrownBy(() -> this.testSliceOutOfBounds(true, false, true)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testMixedSliceALengthOutOfBounds() {
        Assertions.assertThatThrownBy(() -> this.testSliceOutOfBounds(true, false, false)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testMixedSliceBIndexOutOfBounds() {
        Assertions.assertThatThrownBy(() -> this.testSliceOutOfBounds(false, true, true)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testMixedSliceBLengthOutOfBounds() {
        Assertions.assertThatThrownBy(() -> this.testSliceOutOfBounds(false, true, false)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testSliceIndexOutOfBounds() {
        Assertions.assertThatThrownBy(() -> this.testSliceOutOfBounds(false, false, true)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testSliceLengthOutOfBounds() {
        Assertions.assertThatThrownBy(() -> this.testSliceOutOfBounds(false, false, false)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testRetainedSliceAndRetainedDuplicateContentIsExpected() {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected1 = this.newBuffer(6).resetWriterIndex();
        ByteBuf expected2 = this.newBuffer(5).resetWriterIndex();
        ByteBuf expected3 = this.newBuffer(4).resetWriterIndex();
        ByteBuf expected4 = this.newBuffer(3).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected1.writeBytes(new byte[]{2, 3, 4, 5, 6, 7});
        expected2.writeBytes(new byte[]{3, 4, 5, 6, 7});
        expected3.writeBytes(new byte[]{4, 5, 6, 7});
        expected4.writeBytes(new byte[]{5, 6, 7});
        ByteBuf slice1 = buf.retainedSlice(buf.readerIndex() + 1, 6);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)slice1).isEqualTo((Object)expected1)).isEqualTo((Object)buf.slice(buf.readerIndex() + 1, 6));
        buf.release();
        slice1.readByte();
        ByteBuf dup1 = slice1.retainedDuplicate();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)dup1).isEqualTo((Object)expected2)).isEqualTo((Object)slice1.duplicate());
        dup1.readByte();
        ByteBuf dup2 = dup1.duplicate();
        Assertions.assertThat((Comparable)dup2).isEqualTo((Object)expected3);
        dup2.readByte();
        ByteBuf slice2 = dup2.retainedSlice(dup2.readerIndex(), 3);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)slice2).isEqualTo((Object)expected4)).isEqualTo((Object)dup2.slice(dup2.readerIndex(), 3));
        Assertions.assertThat((boolean)expected1.release()).isTrue();
        Assertions.assertThat((boolean)expected2.release()).isTrue();
        Assertions.assertThat((boolean)expected3.release()).isTrue();
        Assertions.assertThat((boolean)expected4.release()).isTrue();
        slice2.release();
        dup2.release();
        Assertions.assertThat((int)dup2.refCnt()).isEqualTo(slice2.refCnt());
        Assertions.assertThat((int)dup1.refCnt()).isEqualTo(dup2.refCnt());
        Assertions.assertThat((boolean)slice1.release()).isTrue();
        Assertions.assertThat((int)buf.refCnt()).isZero();
        Assertions.assertThat((int)slice1.refCnt()).isZero();
        Assertions.assertThat((int)slice2.refCnt()).isZero();
        Assertions.assertThat((int)dup1.refCnt()).isZero();
        Assertions.assertThat((int)dup2.refCnt()).isZero();
    }

    @Test
    void testRetainedDuplicateAndRetainedSliceContentIsExpected() {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected1 = this.newBuffer(6).resetWriterIndex();
        ByteBuf expected2 = this.newBuffer(5).resetWriterIndex();
        ByteBuf expected3 = this.newBuffer(4).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected1.writeBytes(new byte[]{2, 3, 4, 5, 6, 7});
        expected2.writeBytes(new byte[]{3, 4, 5, 6, 7});
        expected3.writeBytes(new byte[]{5, 6, 7});
        ByteBuf dup1 = buf.retainedDuplicate();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)dup1).isEqualTo((Object)buf)).isEqualTo((Object)buf.slice());
        buf.release();
        dup1.readByte();
        ByteBuf slice1 = dup1.retainedSlice(dup1.readerIndex(), 6);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)slice1).isEqualTo((Object)expected1)).isEqualTo((Object)slice1.duplicate());
        slice1.readByte();
        ByteBuf dup2 = slice1.duplicate();
        Assertions.assertThat((Comparable)dup2).isEqualTo((Object)slice1);
        dup2.readByte();
        ByteBuf slice2 = dup2.retainedSlice(dup2.readerIndex() + 1, 3);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)slice2).isEqualTo((Object)expected3)).isEqualTo((Object)dup2.slice(dup2.readerIndex() + 1, 3));
        Assertions.assertThat((boolean)expected1.release()).isTrue();
        Assertions.assertThat((boolean)expected2.release()).isTrue();
        Assertions.assertThat((boolean)expected3.release()).isTrue();
        slice2.release();
        slice1.release();
        Assertions.assertThat((int)dup2.refCnt()).isEqualTo(slice2.refCnt());
        Assertions.assertThat((int)slice1.refCnt()).isEqualTo(dup2.refCnt());
        Assertions.assertThat((boolean)dup1.release()).isTrue();
        Assertions.assertThat((int)buf.refCnt()).isZero();
        Assertions.assertThat((int)slice1.refCnt()).isZero();
        Assertions.assertThat((int)slice2.refCnt()).isZero();
        Assertions.assertThat((int)dup1.refCnt()).isZero();
        Assertions.assertThat((int)dup2.refCnt()).isZero();
    }

    @Test
    void testRetainedSliceContents() {
        this.testSliceContents(true);
    }

    @Test
    void testMultipleLevelRetainedSlice1() {
        this.testMultipleLevelRetainedSliceWithNonRetained(true, true);
    }

    @Test
    void testMultipleLevelRetainedSlice2() {
        this.testMultipleLevelRetainedSliceWithNonRetained(true, false);
    }

    @Test
    void testMultipleLevelRetainedSlice3() {
        this.testMultipleLevelRetainedSliceWithNonRetained(false, true);
    }

    @Test
    void testMultipleLevelRetainedSlice4() {
        this.testMultipleLevelRetainedSliceWithNonRetained(false, false);
    }

    @Test
    void testRetainedSliceReleaseOriginal1() {
        this.testSliceReleaseOriginal(true, true);
    }

    @Test
    void testRetainedSliceReleaseOriginal2() {
        this.testSliceReleaseOriginal(true, false);
    }

    @Test
    void testRetainedSliceReleaseOriginal3() {
        this.testSliceReleaseOriginal(false, true);
    }

    @Test
    void testRetainedSliceReleaseOriginal4() {
        this.testSliceReleaseOriginal(false, false);
    }

    @Test
    void testRetainedDuplicateReleaseOriginal1() {
        this.testDuplicateReleaseOriginal(true, true);
    }

    @Test
    void testRetainedDuplicateReleaseOriginal2() {
        this.testDuplicateReleaseOriginal(true, false);
    }

    @Test
    void testRetainedDuplicateReleaseOriginal3() {
        this.testDuplicateReleaseOriginal(false, true);
    }

    @Test
    void testRetainedDuplicateReleaseOriginal4() {
        this.testDuplicateReleaseOriginal(false, false);
    }

    @Test
    void testMultipleRetainedSliceReleaseOriginal1() {
        this.testMultipleRetainedSliceReleaseOriginal(true, true);
    }

    @Test
    void testMultipleRetainedSliceReleaseOriginal2() {
        this.testMultipleRetainedSliceReleaseOriginal(true, false);
    }

    @Test
    void testMultipleRetainedSliceReleaseOriginal3() {
        this.testMultipleRetainedSliceReleaseOriginal(false, true);
    }

    @Test
    void testMultipleRetainedSliceReleaseOriginal4() {
        this.testMultipleRetainedSliceReleaseOriginal(false, false);
    }

    @Test
    void testMultipleRetainedDuplicateReleaseOriginal1() {
        this.testMultipleRetainedDuplicateReleaseOriginal(true, true);
    }

    @Test
    void testMultipleRetainedDuplicateReleaseOriginal2() {
        this.testMultipleRetainedDuplicateReleaseOriginal(true, false);
    }

    @Test
    void testMultipleRetainedDuplicateReleaseOriginal3() {
        this.testMultipleRetainedDuplicateReleaseOriginal(false, true);
    }

    @Test
    void testMultipleRetainedDuplicateReleaseOriginal4() {
        this.testMultipleRetainedDuplicateReleaseOriginal(false, false);
    }

    @Test
    void testSliceContents() {
        this.testSliceContents(false);
    }

    @Test
    void testRetainedDuplicateContents() {
        this.testDuplicateContents(true);
    }

    @Test
    void testDuplicateContents() {
        this.testDuplicateContents(false);
    }

    @Test
    void testDuplicateCapacityChange() {
        this.testDuplicateCapacityChange(false);
    }

    @Test
    void testRetainedDuplicateCapacityChange() {
        this.testDuplicateCapacityChange(true);
    }

    @Test
    void testSliceCapacityChange() {
        Assertions.assertThatThrownBy(() -> this.testSliceCapacityChange(false)).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testRetainedSliceCapacityChange() {
        Assertions.assertThatThrownBy(() -> this.testSliceCapacityChange(true)).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testRetainedSliceUnreleasable1() {
        this.testRetainedSliceUnreleasable(true, true);
    }

    @Test
    void testRetainedSliceUnreleasable2() {
        this.testRetainedSliceUnreleasable(true, false);
    }

    @Test
    void testRetainedSliceUnreleasable3() {
        this.testRetainedSliceUnreleasable(false, true);
    }

    @Test
    void testRetainedSliceUnreleasable4() {
        this.testRetainedSliceUnreleasable(false, false);
    }

    @Test
    void testReadRetainedSliceUnreleasable1() {
        this.testReadRetainedSliceUnreleasable(true, true);
    }

    @Test
    void testReadRetainedSliceUnreleasable2() {
        this.testReadRetainedSliceUnreleasable(true, false);
    }

    @Test
    void testReadRetainedSliceUnreleasable3() {
        this.testReadRetainedSliceUnreleasable(false, true);
    }

    @Test
    void testReadRetainedSliceUnreleasable4() {
        this.testReadRetainedSliceUnreleasable(false, false);
    }

    @Test
    void testRetainedDuplicateUnreleasable1() {
        this.testRetainedDuplicateUnreleasable(true, true);
    }

    @Test
    void testRetainedDuplicateUnreleasable2() {
        this.testRetainedDuplicateUnreleasable(true, false);
    }

    @Test
    void testRetainedDuplicateUnreleasable3() {
        this.testRetainedDuplicateUnreleasable(false, true);
    }

    @Test
    void testRetainedDuplicateUnreleasable4() {
        this.testRetainedDuplicateUnreleasable(false, false);
    }

    private void testRetainedSliceUnreleasable(boolean initRetainedSlice, boolean finalRetainedSlice) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf buf1 = initRetainedSlice ? buf.retainedSlice() : buf.slice().retain();
        ByteBuf buf2 = Unpooled.unreleasableBuffer((ByteBuf)buf1);
        ByteBuf buf3 = finalRetainedSlice ? buf2.retainedSlice() : buf2.slice().retain();
        Assertions.assertThat((boolean)buf3.release()).isFalse();
        Assertions.assertThat((boolean)buf2.release()).isFalse();
        buf1.release();
        Assertions.assertThat((boolean)buf.release()).isTrue();
        Assertions.assertThat((int)buf1.refCnt()).isZero();
        Assertions.assertThat((int)buf.refCnt()).isZero();
    }

    private void testReadRetainedSliceUnreleasable(boolean initRetainedSlice, boolean finalRetainedSlice) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf buf1 = initRetainedSlice ? buf.retainedSlice() : buf.slice().retain();
        ByteBuf buf2 = Unpooled.unreleasableBuffer((ByteBuf)buf1);
        ByteBuf buf3 = finalRetainedSlice ? buf2.readRetainedSlice(buf2.readableBytes()) : buf2.readSlice(buf2.readableBytes()).retain();
        Assertions.assertThat((boolean)buf3.release()).isFalse();
        Assertions.assertThat((boolean)buf2.release()).isFalse();
        buf1.release();
        Assertions.assertThat((boolean)buf.release()).isTrue();
        Assertions.assertThat((int)buf1.refCnt()).isZero();
        Assertions.assertThat((int)buf.refCnt()).isZero();
    }

    private void testRetainedDuplicateUnreleasable(boolean initRetainedDuplicate, boolean finalRetainedDuplicate) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf buf1 = initRetainedDuplicate ? buf.retainedDuplicate() : buf.duplicate().retain();
        ByteBuf buf2 = Unpooled.unreleasableBuffer((ByteBuf)buf1);
        ByteBuf buf3 = finalRetainedDuplicate ? buf2.retainedDuplicate() : buf2.duplicate().retain();
        Assertions.assertThat((boolean)buf3.release()).isFalse();
        Assertions.assertThat((boolean)buf2.release()).isFalse();
        buf1.release();
        Assertions.assertThat((boolean)buf.release()).isTrue();
        Assertions.assertThat((int)buf1.refCnt()).isZero();
        Assertions.assertThat((int)buf.refCnt()).isZero();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDuplicateCapacityChange(boolean retainedDuplicate) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf dup = retainedDuplicate ? buf.retainedDuplicate() : buf.duplicate();
        try {
            dup.capacity(10);
            Assertions.assertThat((int)dup.capacity()).isEqualTo(buf.capacity());
            dup.capacity(5);
            Assertions.assertThat((int)dup.capacity()).isEqualTo(buf.capacity());
        }
        finally {
            if (retainedDuplicate) {
                dup.release();
            }
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSliceCapacityChange(boolean retainedSlice) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf slice = retainedSlice ? buf.retainedSlice(buf.readerIndex() + 1, 3) : buf.slice(buf.readerIndex() + 1, 3);
        try {
            slice.capacity(10);
        }
        finally {
            if (retainedSlice) {
                slice.release();
            }
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSliceOutOfBounds(boolean initRetainedSlice, boolean finalRetainedSlice, boolean indexOutOfBounds) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf slice = initRetainedSlice ? buf.retainedSlice(buf.readerIndex() + 1, 2) : buf.slice(buf.readerIndex() + 1, 2);
        try {
            int length;
            Assertions.assertThat((int)slice.capacity()).isEqualTo(2);
            Assertions.assertThat((int)slice.maxCapacity()).isEqualTo(2);
            int index = indexOutOfBounds ? 3 : 0;
            int n = length = indexOutOfBounds ? 0 : 3;
            if (finalRetainedSlice) {
                slice.retainedSlice(index, length);
            } else {
                slice.slice(index, length);
            }
        }
        finally {
            if (initRetainedSlice) {
                slice.release();
            }
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSliceContents(boolean retainedSlice) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected = this.newBuffer(3).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected.writeBytes(new byte[]{4, 5, 6});
        ByteBuf slice = retainedSlice ? buf.retainedSlice(buf.readerIndex() + 3, 3) : buf.slice(buf.readerIndex() + 3, 3);
        try {
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)slice).isEqualTo((Object)slice.duplicate())).isEqualTo((Object)expected);
            ByteBuf b = slice.retainedDuplicate();
            Assertions.assertThat((Comparable)slice).isEqualTo((Object)b);
            b.release();
            Assertions.assertThat((Comparable)slice).isEqualTo((Object)slice.slice(0, slice.capacity()));
        }
        finally {
            if (retainedSlice) {
                slice.release();
            }
            buf.release();
            expected.release();
        }
    }

    private void testSliceReleaseOriginal(boolean retainedSlice1, boolean retainedSlice2) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected1 = this.newBuffer(3).resetWriterIndex();
        ByteBuf expected2 = this.newBuffer(2).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected1.writeBytes(new byte[]{6, 7, 8});
        expected2.writeBytes(new byte[]{7, 8});
        ByteBuf slice1 = retainedSlice1 ? buf.retainedSlice(buf.readerIndex() + 5, 3) : buf.slice(buf.readerIndex() + 5, 3).retain();
        Assertions.assertThat((Comparable)slice1).isEqualTo((Object)expected1);
        buf.release();
        ByteBuf slice2 = retainedSlice2 ? slice1.retainedSlice(slice1.readerIndex() + 1, 2) : slice1.slice(slice1.readerIndex() + 1, 2).retain();
        Assertions.assertThat((Comparable)slice2).isEqualTo((Object)expected2);
        Assertions.assertThat((boolean)expected1.release()).isTrue();
        Assertions.assertThat((boolean)expected2.release()).isTrue();
        slice2.release();
        Assertions.assertThat((boolean)slice1.release()).isTrue();
        Assertions.assertThat((int)buf.refCnt()).isZero();
        Assertions.assertThat((int)slice1.refCnt()).isZero();
        Assertions.assertThat((int)slice2.refCnt()).isZero();
    }

    private void testMultipleLevelRetainedSliceWithNonRetained(boolean doSlice1, boolean doSlice2) {
        ByteBuf slice4;
        ByteBuf slice3;
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected1 = this.newBuffer(6).resetWriterIndex();
        ByteBuf expected2 = this.newBuffer(4).resetWriterIndex();
        ByteBuf expected3 = this.newBuffer(2).resetWriterIndex();
        ByteBuf expected4SliceSlice = this.newBuffer(1).resetWriterIndex();
        ByteBuf expected4DupSlice = this.newBuffer(1).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected1.writeBytes(new byte[]{2, 3, 4, 5, 6, 7});
        expected2.writeBytes(new byte[]{3, 4, 5, 6});
        expected3.writeBytes(new byte[]{4, 5});
        expected4SliceSlice.writeBytes(new byte[]{5});
        expected4DupSlice.writeBytes(new byte[]{4});
        ByteBuf slice1 = buf.retainedSlice(buf.readerIndex() + 1, 6);
        Assertions.assertThat((Comparable)slice1).isEqualTo((Object)expected1);
        buf.release();
        ByteBuf slice2 = slice1.retainedSlice(slice1.readerIndex() + 1, 4);
        Assertions.assertThat((Comparable)slice2).isEqualTo((Object)expected2);
        Assertions.assertThat((Comparable)slice2).isEqualTo((Object)slice2.duplicate());
        Assertions.assertThat((Comparable)slice2).isEqualTo((Object)slice2.slice());
        ByteBuf tmpBuf = slice2.retainedDuplicate();
        Assertions.assertThat((Comparable)slice2).isEqualTo((Object)tmpBuf);
        tmpBuf.release();
        tmpBuf = slice2.retainedSlice();
        Assertions.assertThat((Comparable)slice2).isEqualTo((Object)tmpBuf);
        tmpBuf.release();
        ByteBuf byteBuf = slice3 = doSlice1 ? slice2.slice(slice2.readerIndex() + 1, 2) : slice2.duplicate();
        if (doSlice1) {
            Assertions.assertThat((Comparable)slice3).isEqualTo((Object)expected3);
        } else {
            Assertions.assertThat((Comparable)slice3).isEqualTo((Object)expected2);
        }
        ByteBuf byteBuf2 = slice4 = doSlice2 ? slice3.slice(slice3.readerIndex() + 1, 1) : slice3.duplicate();
        if (doSlice1 && doSlice2) {
            Assertions.assertThat((Comparable)slice4).isEqualTo((Object)expected4SliceSlice);
        } else if (doSlice2) {
            Assertions.assertThat((Comparable)slice4).isEqualTo((Object)expected4DupSlice);
        } else {
            Assertions.assertThat((Comparable)slice3).isEqualTo((Object)slice4);
        }
        Assertions.assertThat((boolean)expected1.release()).isTrue();
        Assertions.assertThat((boolean)expected2.release()).isTrue();
        Assertions.assertThat((boolean)expected3.release()).isTrue();
        Assertions.assertThat((boolean)expected4SliceSlice.release()).isTrue();
        Assertions.assertThat((boolean)expected4DupSlice.release()).isTrue();
        slice4.release();
        Assertions.assertThat((int)slice2.refCnt()).isEqualTo(slice3.refCnt());
        Assertions.assertThat((int)slice4.refCnt()).isEqualTo(slice3.refCnt());
        Assertions.assertThat((boolean)slice1.release()).isTrue();
        Assertions.assertThat((int)buf.refCnt()).isZero();
        Assertions.assertThat((int)slice1.refCnt()).isZero();
        Assertions.assertThat((int)slice2.refCnt()).isZero();
        Assertions.assertThat((int)slice3.refCnt()).isZero();
    }

    private void testDuplicateReleaseOriginal(boolean retainedDuplicate1, boolean retainedDuplicate2) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected = this.newBuffer(8).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected.writeBytes(buf, buf.readerIndex(), buf.readableBytes());
        ByteBuf dup1 = retainedDuplicate1 ? buf.retainedDuplicate() : buf.duplicate().retain();
        Assertions.assertThat((Comparable)dup1).isEqualTo((Object)expected);
        buf.release();
        ByteBuf dup2 = retainedDuplicate2 ? dup1.retainedDuplicate() : dup1.duplicate().retain();
        Assertions.assertThat((Comparable)dup2).isEqualTo((Object)expected);
        Assertions.assertThat((boolean)expected.release()).isTrue();
        dup2.release();
        Assertions.assertThat((boolean)dup1.release()).isTrue();
        Assertions.assertThat((int)buf.refCnt()).isZero();
        Assertions.assertThat((int)dup1.refCnt()).isZero();
        Assertions.assertThat((int)dup2.refCnt()).isZero();
    }

    private void testMultipleRetainedSliceReleaseOriginal(boolean retainedSlice1, boolean retainedSlice2) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected1 = this.newBuffer(3).resetWriterIndex();
        ByteBuf expected2 = this.newBuffer(2).resetWriterIndex();
        ByteBuf expected3 = this.newBuffer(2).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected1.writeBytes(new byte[]{6, 7, 8});
        expected2.writeBytes(new byte[]{7, 8});
        expected3.writeBytes(new byte[]{6, 7});
        ByteBuf slice1 = retainedSlice1 ? buf.retainedSlice(buf.readerIndex() + 5, 3) : buf.slice(buf.readerIndex() + 5, 3).retain();
        Assertions.assertThat((Comparable)slice1).isEqualTo((Object)expected1);
        buf.release();
        ByteBuf slice2 = retainedSlice2 ? slice1.retainedSlice(slice1.readerIndex() + 1, 2) : slice1.slice(slice1.readerIndex() + 1, 2).retain();
        Assertions.assertThat((Comparable)slice2).isEqualTo((Object)expected2);
        slice2.release();
        ByteBuf slice3 = slice1.retainedSlice(slice1.readerIndex(), 2);
        Assertions.assertThat((Comparable)slice3).isEqualTo((Object)expected3);
        slice3.release();
        Assertions.assertThat((boolean)slice1.release()).isTrue();
        Assertions.assertThat((boolean)expected1.release()).isTrue();
        Assertions.assertThat((boolean)expected2.release()).isTrue();
        Assertions.assertThat((boolean)expected3.release()).isTrue();
        Assertions.assertThat((int)buf.refCnt()).isZero();
        Assertions.assertThat((int)slice1.refCnt()).isZero();
        Assertions.assertThat((int)slice2.refCnt()).isZero();
        Assertions.assertThat((int)slice3.refCnt()).isZero();
    }

    private void testMultipleRetainedDuplicateReleaseOriginal(boolean retainedDuplicate1, boolean retainedDuplicate2) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected = this.newBuffer(8).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected.writeBytes(buf, buf.readerIndex(), buf.readableBytes());
        ByteBuf dup1 = retainedDuplicate1 ? buf.retainedDuplicate() : buf.duplicate().retain();
        Assertions.assertThat((Comparable)dup1).isEqualTo((Object)expected);
        buf.release();
        ByteBuf dup2 = retainedDuplicate2 ? dup1.retainedDuplicate() : dup1.duplicate().retain();
        ((AbstractComparableAssert)((AbstractComparableAssert)Assertions.assertThat((Comparable)dup2).isEqualTo((Object)expected)).isEqualTo((Object)dup2.duplicate())).isEqualTo((Object)dup2.slice());
        ByteBuf tmpBuf = dup2.retainedDuplicate();
        Assertions.assertThat((Comparable)dup2).isEqualTo((Object)tmpBuf);
        tmpBuf.release();
        tmpBuf = dup2.retainedSlice();
        Assertions.assertThat((Comparable)dup2).isEqualTo((Object)tmpBuf);
        tmpBuf.release();
        dup2.release();
        ByteBuf dup3 = dup1.retainedDuplicate();
        Assertions.assertThat((Comparable)dup3).isEqualTo((Object)expected);
        dup3.release();
        Assertions.assertThat((boolean)dup1.release()).isTrue();
        Assertions.assertThat((boolean)expected.release()).isTrue();
        Assertions.assertThat((int)buf.refCnt()).isZero();
        Assertions.assertThat((int)dup1.refCnt()).isZero();
        Assertions.assertThat((int)dup2.refCnt()).isZero();
        Assertions.assertThat((int)dup3.refCnt()).isZero();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDuplicateContents(boolean retainedDuplicate) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        ByteBuf dup = retainedDuplicate ? buf.retainedDuplicate() : buf.duplicate();
        try {
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)dup).isEqualTo((Object)buf)).isEqualTo((Object)dup.duplicate());
            ByteBuf b = dup.retainedDuplicate();
            Assertions.assertThat((Comparable)dup).isEqualTo((Object)b);
            b.release();
            Assertions.assertThat((Comparable)dup).isEqualTo((Object)dup.slice(dup.readerIndex(), dup.readableBytes()));
        }
        finally {
            if (retainedDuplicate) {
                dup.release();
            }
            buf.release();
        }
    }

    @Test
    void testDuplicateRelease() {
        ByteBuf buf = this.newBuffer(8);
        Assertions.assertThat((int)buf.refCnt()).isOne();
        Assertions.assertThat((boolean)buf.duplicate().release()).isTrue();
        Assertions.assertThat((int)buf.refCnt()).isZero();
    }

    @Test
    void testRefCnt() throws Exception {
        this.testRefCnt0(false);
    }

    @Test
    void testRefCnt2() throws Exception {
        this.testRefCnt0(true);
    }

    @Test
    void testEmptyNioBuffers() {
        ByteBuf buffer = this.newBuffer(8);
        buffer.clear();
        Assertions.assertThat((boolean)buffer.isReadable()).isFalse();
        Object[] nioBuffers = buffer.nioBuffers();
        Assertions.assertThat((Object[])nioBuffers).hasSize(1);
        Assertions.assertThat((boolean)((Buffer)nioBuffers[0]).hasRemaining()).isFalse();
        buffer.release();
    }

    @Test
    void testGetReadOnlyDirectDst() {
        this.testGetReadOnlyDst(true);
    }

    @Test
    void testGetReadOnlyHeapDst() {
        this.testGetReadOnlyDst(false);
    }

    private void testGetReadOnlyDst(boolean direct) {
        byte[] bytes = new byte[]{97, 98, 99, 100};
        ByteBuf buffer = this.newBuffer(bytes.length);
        buffer.writeBytes(bytes);
        ByteBuffer dst = direct ? ByteBuffer.allocateDirect(bytes.length) : ByteBuffer.allocate(bytes.length);
        ByteBuffer readOnlyDst = dst.asReadOnlyBuffer();
        Assertions.assertThatThrownBy(() -> buffer.getBytes(0, readOnlyDst)).isInstanceOf(ReadOnlyBufferException.class);
        Assertions.assertThat((int)readOnlyDst.position()).isZero();
        buffer.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testReadBytesAndWriteBytesWithFileChannel() throws IOException {
        File file = File.createTempFile("file-channel", ".tmp");
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");){
            FileChannel channel = randomAccessFile.getChannel();
            long channelPosition = channel.position();
            byte[] bytes = new byte[]{97, 98, 99, 100};
            int len = bytes.length;
            ByteBuf buffer = this.newBuffer(len);
            buffer.resetReaderIndex();
            buffer.resetWriterIndex();
            buffer.writeBytes(bytes);
            int oldReaderIndex = buffer.readerIndex();
            Assertions.assertThat((int)buffer.readBytes(channel, 10L, len)).isEqualTo(len);
            Assertions.assertThat((int)buffer.readerIndex()).isEqualTo(oldReaderIndex + len);
            Assertions.assertThat((long)channel.position()).isEqualTo(channelPosition);
            ByteBuf buffer2 = this.newBuffer(len);
            buffer2.resetReaderIndex();
            buffer2.resetWriterIndex();
            int oldWriterIndex = buffer2.writerIndex();
            Assertions.assertThat((int)buffer2.writeBytes(channel, 10L, len)).isEqualTo(len);
            Assertions.assertThat((long)channel.position()).isEqualTo(channelPosition);
            Assertions.assertThat((int)buffer2.writerIndex()).isEqualTo(oldWriterIndex + len);
            Assertions.assertThat((char)((char)buffer2.getByte(0))).isEqualTo('a');
            Assertions.assertThat((char)((char)buffer2.getByte(1))).isEqualTo('b');
            Assertions.assertThat((char)((char)buffer2.getByte(2))).isEqualTo('c');
            Assertions.assertThat((char)((char)buffer2.getByte(3))).isEqualTo('d');
            buffer.release();
            buffer2.release();
        }
        finally {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetBytesAndSetBytesWithFileChannel() throws IOException {
        File file = File.createTempFile("file-channel", ".tmp");
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");){
            FileChannel channel = randomAccessFile.getChannel();
            long channelPosition = channel.position();
            byte[] bytes = new byte[]{97, 98, 99, 100};
            int len = bytes.length;
            ByteBuf buffer = this.newBuffer(len);
            buffer.resetReaderIndex();
            buffer.resetWriterIndex();
            buffer.writeBytes(bytes);
            int oldReaderIndex = buffer.readerIndex();
            Assertions.assertThat((int)buffer.getBytes(oldReaderIndex, channel, 10L, len)).isEqualTo(len);
            Assertions.assertThat((int)buffer.readerIndex()).isEqualTo(oldReaderIndex);
            Assertions.assertThat((long)channel.position()).isEqualTo(channelPosition);
            ByteBuf buffer2 = this.newBuffer(len);
            buffer2.resetReaderIndex();
            buffer2.resetWriterIndex();
            int oldWriterIndex = buffer2.writerIndex();
            Assertions.assertThat((int)buffer2.setBytes(oldWriterIndex, channel, 10L, len)).isEqualTo(len);
            Assertions.assertThat((long)channel.position()).isEqualTo(channelPosition);
            Assertions.assertThat((int)buffer2.writerIndex()).isEqualTo(oldWriterIndex);
            Assertions.assertThat((char)((char)buffer2.getByte(oldWriterIndex))).isEqualTo('a');
            Assertions.assertThat((char)((char)buffer2.getByte(oldWriterIndex + 1))).isEqualTo('b');
            Assertions.assertThat((char)((char)buffer2.getByte(oldWriterIndex + 2))).isEqualTo('c');
            Assertions.assertThat((char)((char)buffer2.getByte(oldWriterIndex + 3))).isEqualTo('d');
            buffer.release();
            buffer2.release();
        }
        finally {
            file.delete();
        }
    }

    @Test
    void testReadBytes() {
        ByteBuf buffer = this.newBuffer(8);
        byte[] bytes = new byte[8];
        buffer.writeBytes(bytes);
        ByteBuf buffer2 = buffer.readBytes(4);
        Assertions.assertThat((Object)buffer2.alloc()).isSameAs((Object)buffer.alloc());
        Assertions.assertThat((int)buffer.readerIndex()).isEqualTo(4);
        Assertions.assertThat((boolean)buffer.release()).isTrue();
        Assertions.assertThat((int)buffer.refCnt()).isZero();
        Assertions.assertThat((boolean)buffer2.release()).isTrue();
        Assertions.assertThat((int)buffer2.refCnt()).isZero();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testForEachByteDesc2() {
        byte[] expected = new byte[]{1, 2, 3, 4};
        ByteBuf buf = this.newBuffer(expected.length);
        try {
            buf.writeBytes(expected);
            final byte[] bytes = new byte[expected.length];
            int i = buf.forEachByteDesc(new ByteProcessor(){
                private int index;
                {
                    this.index = bytes.length - 1;
                }

                public boolean process(byte value) {
                    bytes[this.index--] = value;
                    return true;
                }
            });
            Assertions.assertThat((int)i).isEqualTo(-1);
            Assertions.assertThat((byte[])bytes).isEqualTo((Object)expected);
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testForEachByte2() {
        byte[] expected = new byte[]{1, 2, 3, 4};
        ByteBuf buf = this.newBuffer(expected.length);
        try {
            buf.writeBytes(expected);
            final byte[] bytes = new byte[expected.length];
            int i = buf.forEachByte(new ByteProcessor(){
                private int index;

                public boolean process(byte value) {
                    bytes[this.index++] = value;
                    return true;
                }
            });
            Assertions.assertThat((int)i).isEqualTo(-1);
            Assertions.assertThat((byte[])bytes).isEqualTo((Object)expected);
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testGetBytesByteBuffer() {
        byte[] bytes = new byte[]{97, 98, 99, 100, 101, 102, 103};
        ByteBuffer nioBuffer = ByteBuffer.allocate(bytes.length + 1);
        ByteBuf buffer = this.newBuffer(bytes.length);
        try {
            buffer.writeBytes(bytes);
            Assertions.assertThatThrownBy(() -> buffer.getBytes(buffer.readerIndex(), nioBuffer)).isInstanceOf(IndexOutOfBoundsException.class);
        }
        finally {
            buffer.release();
        }
    }

    private void testRefCnt0(final boolean parameter) throws Exception {
        for (int i = 0; i < 10; ++i) {
            final CountDownLatch latch = new CountDownLatch(1);
            final CountDownLatch innerLatch = new CountDownLatch(1);
            final ByteBuf buffer = this.newBuffer(4);
            Assertions.assertThat((int)buffer.refCnt()).isOne();
            final AtomicInteger cnt = new AtomicInteger(Integer.MAX_VALUE);
            Thread t1 = new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean released = parameter ? buffer.release(buffer.refCnt()) : buffer.release();
                    Assertions.assertThat((boolean)released).isTrue();
                    Thread t2 = new Thread(() -> {
                        cnt.set(buffer.refCnt());
                        latch.countDown();
                    });
                    t2.start();
                    try {
                        innerLatch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            t1.start();
            latch.await();
            Assertions.assertThat((AtomicInteger)cnt).hasValue(0);
            innerLatch.countDown();
        }
    }

    @Test
    void testCapacityEnforceMaxCapacity() {
        ByteBuf buffer = this.newBuffer(3, 13);
        Assertions.assertThat((int)buffer.maxCapacity()).isEqualTo(13);
        Assertions.assertThat((int)buffer.capacity()).isEqualTo(3);
        try {
            Assertions.assertThatThrownBy(() -> buffer.capacity(14)).isInstanceOf(IllegalArgumentException.class);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    void testCapacityNegative() {
        ByteBuf buffer = this.newBuffer(3, 13);
        Assertions.assertThat((int)buffer.maxCapacity()).isEqualTo(13);
        Assertions.assertThat((int)buffer.capacity()).isEqualTo(3);
        try {
            Assertions.assertThatThrownBy(() -> buffer.capacity(-1)).isInstanceOf(IllegalArgumentException.class);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    void testCapacityDecrease() {
        ByteBuf buffer = this.newBuffer(3, 13);
        Assertions.assertThat((int)buffer.maxCapacity()).isEqualTo(13);
        Assertions.assertThat((int)buffer.capacity()).isEqualTo(3);
        try {
            buffer.capacity(2);
            Assertions.assertThat((int)buffer.capacity()).isEqualTo(2);
            Assertions.assertThat((int)buffer.maxCapacity()).isEqualTo(13);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    void testCapacityIncrease() {
        ByteBuf buffer = this.newBuffer(3, 13);
        Assertions.assertThat((int)buffer.maxCapacity()).isEqualTo(13);
        Assertions.assertThat((int)buffer.capacity()).isEqualTo(3);
        try {
            buffer.capacity(4);
            Assertions.assertThat((int)buffer.capacity()).isEqualTo(4);
            Assertions.assertThat((int)buffer.maxCapacity()).isEqualTo(13);
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testReaderIndexLargerThanWriterIndex() {
        String content1 = "hello";
        String content2 = "world";
        int length = content1.length() + content2.length();
        ByteBuf buffer = this.newBuffer(length);
        buffer.setIndex(0, 0);
        buffer.writeCharSequence((CharSequence)content1, CharsetUtil.US_ASCII);
        buffer.markWriterIndex();
        buffer.skipBytes(content1.length());
        buffer.writeCharSequence((CharSequence)content2, CharsetUtil.US_ASCII);
        buffer.skipBytes(content2.length());
        Assertions.assertThat((int)buffer.readerIndex()).isLessThanOrEqualTo(buffer.writerIndex());
        try {
            Assertions.assertThatThrownBy(() -> ((ByteBuf)buffer).resetWriterIndex()).isInstanceOf(IndexOutOfBoundsException.class);
        }
        finally {
            buffer.release();
        }
    }

    static {
        char[] chars = new char[256];
        for (int c = 0; c < chars.length; c = (int)((char)(c + 1))) {
            chars[c] = c;
        }
        EXTENDED_ASCII_CHARS = CharBuffer.wrap(chars);
        ASCII_CHARS = CharBuffer.wrap(chars, 0, 128);
    }

    private static final class TestByteProcessor
    implements ByteProcessor {
        private TestByteProcessor() {
        }

        public boolean process(byte value) {
            return true;
        }
    }

    private static final class TestScatteringByteChannel
    implements ScatteringByteChannel {
        private TestScatteringByteChannel() {
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long read(ByteBuffer[] dsts) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(ByteBuffer dst) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class DevNullGatheringByteChannel
    implements GatheringByteChannel {
        private DevNullGatheringByteChannel() {
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long write(ByteBuffer[] srcs) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int write(ByteBuffer src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException();
        }
    }

    static final class TestGatheringByteChannel
    implements GatheringByteChannel {
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();
        private final WritableByteChannel channel = Channels.newChannel(this.out);
        private final int limit;

        TestGatheringByteChannel(int limit) {
            this.limit = limit;
        }

        TestGatheringByteChannel() {
            this(Integer.MAX_VALUE);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            long written = 0L;
            while (offset < length && (written += (long)this.write(srcs[offset])) < (long)this.limit) {
                ++offset;
            }
            return written;
        }

        @Override
        public long write(ByteBuffer[] srcs) throws IOException {
            return this.write(srcs, 0, srcs.length);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int oldLimit = src.limit();
            if (this.limit < src.remaining()) {
                src.limit(src.position() + this.limit);
            }
            int w = this.channel.write(src);
            src.limit(oldLimit);
            return w;
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }

        public byte[] writtenBytes() {
            return this.out.toByteArray();
        }
    }
}

