/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.deployment.ConsumedSubpartitionContext;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ConsumedSubpartitionContextTest {
    ConsumedSubpartitionContextTest() {
    }

    @Test
    void testBuildConsumedSubpartitionContextWithGroups() {
        Map<IndexRange, IndexRange> consumedSubpartitionGroups = Map.of(new IndexRange(0, 1), new IndexRange(0, 2), new IndexRange(2, 3), new IndexRange(3, 5));
        List<IntermediateResultPartitionID> partitions = ConsumedSubpartitionContextTest.createPartitions();
        ConsumedPartitionGroup consumedPartitionGroup = ConsumedPartitionGroup.fromMultiplePartitions((int)4, partitions, (ResultPartitionType)ResultPartitionType.BLOCKING);
        ConsumedSubpartitionContext context = ConsumedSubpartitionContext.buildConsumedSubpartitionContext(consumedSubpartitionGroups, (ConsumedPartitionGroup)consumedPartitionGroup, partitions::get);
        Assertions.assertThat((int)context.getNumConsumedShuffleDescriptors()).isEqualTo(4);
        Collection shuffleDescriptorRanges = context.getConsumedShuffleDescriptorRanges();
        Assertions.assertThat((Collection)shuffleDescriptorRanges).hasSize(1);
        Assertions.assertThat((Object)context.getConsumedSubpartitionRange(0)).isEqualTo((Object)new IndexRange(0, 2));
        Assertions.assertThat((Object)context.getConsumedSubpartitionRange(1)).isEqualTo((Object)new IndexRange(0, 2));
        Assertions.assertThat((Object)context.getConsumedSubpartitionRange(2)).isEqualTo((Object)new IndexRange(3, 5));
        Assertions.assertThat((Object)context.getConsumedSubpartitionRange(3)).isEqualTo((Object)new IndexRange(3, 5));
    }

    @Test
    void testBuildConsumedSubpartitionContextWithUnorderedGroups() {
        Map<IndexRange, IndexRange> consumedSubpartitionGroups = Map.of(new IndexRange(3, 3), new IndexRange(1, 1), new IndexRange(0, 0), new IndexRange(0, 1));
        List<IntermediateResultPartitionID> partitions = ConsumedSubpartitionContextTest.createPartitions();
        ConsumedPartitionGroup consumedPartitionGroup = ConsumedPartitionGroup.fromMultiplePartitions((int)4, partitions, (ResultPartitionType)ResultPartitionType.BLOCKING);
        ConsumedSubpartitionContext context = ConsumedSubpartitionContext.buildConsumedSubpartitionContext(consumedSubpartitionGroups, (ConsumedPartitionGroup)consumedPartitionGroup, partitions::get);
        Assertions.assertThat((int)context.getNumConsumedShuffleDescriptors()).isEqualTo(2);
        Collection shuffleDescriptorRanges = context.getConsumedShuffleDescriptorRanges();
        Assertions.assertThat((Collection)shuffleDescriptorRanges).hasSize(2);
        Assertions.assertThat((Object)context.getConsumedSubpartitionRange(0)).isEqualTo((Object)new IndexRange(0, 1));
        Assertions.assertThat((Object)context.getConsumedSubpartitionRange(3)).isEqualTo((Object)new IndexRange(1, 1));
    }

    @Test
    void testBuildConsumedSubpartitionContextWithOverlapGroups() {
        Map<IndexRange, IndexRange> consumedSubpartitionGroups = Map.of(new IndexRange(0, 3), new IndexRange(1, 1), new IndexRange(0, 1), new IndexRange(2, 2));
        List<IntermediateResultPartitionID> partitions = ConsumedSubpartitionContextTest.createPartitions();
        ConsumedPartitionGroup consumedPartitionGroup = ConsumedPartitionGroup.fromMultiplePartitions((int)4, partitions, (ResultPartitionType)ResultPartitionType.BLOCKING);
        ConsumedSubpartitionContext context = ConsumedSubpartitionContext.buildConsumedSubpartitionContext(consumedSubpartitionGroups, (ConsumedPartitionGroup)consumedPartitionGroup, partitions::get);
        Assertions.assertThat((int)context.getNumConsumedShuffleDescriptors()).isEqualTo(4);
        Collection shuffleDescriptorRanges = context.getConsumedShuffleDescriptorRanges();
        Assertions.assertThat((Collection)shuffleDescriptorRanges).hasSize(1);
        Assertions.assertThat((Object)context.getConsumedSubpartitionRange(0)).isEqualTo((Object)new IndexRange(1, 2));
        Assertions.assertThat((Object)context.getConsumedSubpartitionRange(1)).isEqualTo((Object)new IndexRange(1, 2));
        Assertions.assertThat((Object)context.getConsumedSubpartitionRange(2)).isEqualTo((Object)new IndexRange(1, 1));
        Assertions.assertThat((Object)context.getConsumedSubpartitionRange(3)).isEqualTo((Object)new IndexRange(1, 1));
    }

    @Test
    void testBuildConsumedSubpartitionContextWithRange() {
        int numConsumedShuffleDescriptors = 5;
        IndexRange consumedSubpartitionRange = new IndexRange(0, 4);
        ConsumedSubpartitionContext context = ConsumedSubpartitionContext.buildConsumedSubpartitionContext((int)numConsumedShuffleDescriptors, (IndexRange)consumedSubpartitionRange);
        Assertions.assertThat((int)context.getNumConsumedShuffleDescriptors()).isEqualTo(numConsumedShuffleDescriptors);
        Collection shuffleDescriptorRanges = context.getConsumedShuffleDescriptorRanges();
        Assertions.assertThat((Collection)shuffleDescriptorRanges).hasSize(1);
        Assertions.assertThat((Collection)shuffleDescriptorRanges).contains((Object[])new IndexRange[]{new IndexRange(0, 4)});
        IndexRange subpartitionRange = context.getConsumedSubpartitionRange(2);
        Assertions.assertThat((Object)subpartitionRange).isEqualTo((Object)consumedSubpartitionRange);
    }

    private static List<IntermediateResultPartitionID> createPartitions() {
        ArrayList<IntermediateResultPartitionID> partitions = new ArrayList<IntermediateResultPartitionID>();
        IntermediateDataSetID intermediateDataSetID = new IntermediateDataSetID();
        for (int i = 0; i < 4; ++i) {
            partitions.add(new IntermediateResultPartitionID(intermediateDataSetID, i));
        }
        return partitions;
    }
}

