/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.checkpoint.metadata.ChannelStateTestUtils;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointTestUtils;
import org.apache.flink.runtime.checkpoint.metadata.MetadataSerializer;
import org.apache.flink.runtime.checkpoint.metadata.MetadataV6Serializer;
import org.apache.flink.runtime.state.InputStateHandle;
import org.apache.flink.runtime.state.OutputStateHandle;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class MetadataV6SerializerTest {
    private static final MetadataSerializer INSTANCE = MetadataV6Serializer.INSTANCE;
    private static final Random RND = new Random();
    private String basePath;
    private List<InputStateHandle> inputHandles;
    private List<OutputStateHandle> outputHandles;
    private CheckpointMetadata metadata;

    MetadataV6SerializerTest() {
    }

    @BeforeEach
    public void beforeEach(@TempDir java.nio.file.Path tempDir) throws IOException {
        this.basePath = tempDir.toUri().toString();
        Path metaPath = new Path(this.basePath, "_metadata");
        FileSystem.getLocalFileSystem().create(metaPath, FileSystem.WriteMode.OVERWRITE).close();
    }

    @Test
    void testSerializeUnmergedChannelStateHandle() throws IOException {
        this.testSerializeChannelStateHandle(() -> ChannelStateTestUtils.randomInputChannelStateHandlesFromSameSubtask().stream().map(e -> e).collect(Collectors.toList()), () -> ChannelStateTestUtils.randomResultSubpartitionStateHandlesFromSameSubtask().stream().map(e -> e).collect(Collectors.toList()));
    }

    @Test
    void testSerializeMergedChannelStateHandle() throws IOException {
        this.testSerializeChannelStateHandle(() -> Collections.singletonList(ChannelStateTestUtils.randomMergedInputChannelStateHandle()), () -> Collections.singletonList(ChannelStateTestUtils.randomMergedResultSubpartitionStateHandle()));
    }

    private void testSerializeChannelStateHandle(Supplier<List<InputStateHandle>> getter1, Supplier<List<OutputStateHandle>> getter2) throws IOException {
        this.prepareAndSerializeMetadata(getter1, getter2);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(out);){
            INSTANCE.serialize(this.metadata, dos);
            try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(out.toByteArray()));){
                CheckpointMetadata deserializedMetadata = INSTANCE.deserialize(dis, this.metadata.getClass().getClassLoader(), this.basePath);
                Collection operatorStates = deserializedMetadata.getOperatorStates();
                Assertions.assertThat((Collection)operatorStates).hasSize(1);
                OperatorState operatorState = (OperatorState)operatorStates.iterator().next();
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)operatorState.getNumberCollectedStates());
                OperatorSubtaskState subtaskState = operatorState.getState(0);
                org.junit.jupiter.api.Assertions.assertEquals(this.inputHandles, (Object)subtaskState.getInputChannelState().asList());
                org.junit.jupiter.api.Assertions.assertEquals(this.outputHandles, (Object)subtaskState.getResultSubpartitionState().asList());
            }
        }
    }

    private void prepareAndSerializeMetadata(Supplier<List<InputStateHandle>> getter1, Supplier<List<OutputStateHandle>> getter2) {
        Collection<OperatorState> operatorStates = CheckpointTestUtils.createOperatorStates(RND, this.basePath, 1, 0, 0, 1);
        this.inputHandles = getter1.get();
        this.outputHandles = getter2.get();
        for (OperatorState operatorState : operatorStates) {
            int subtaskStateCount = operatorState.getNumberCollectedStates();
            for (int i = 0; i < subtaskStateCount; ++i) {
                OperatorSubtaskState originSubtaskState = operatorState.getState(i);
                OperatorSubtaskState.Builder builder = originSubtaskState.toBuilder();
                builder.setInputChannelState(new StateObjectCollection(this.inputHandles));
                builder.setResultSubpartitionState(new StateObjectCollection(this.outputHandles));
                operatorState.putState(i, builder.build());
            }
        }
        this.metadata = new CheckpointMetadata(1L, operatorStates, Collections.emptyList(), null);
    }
}

