/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Map;
import org.apache.flink.runtime.checkpoint.SubTaskInitializationMetricsBuilder;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Test;

public class SubTaskInitializationMetricsTest {
    @Test
    public void testBuildingInvalidMetrics() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> {
            SubTaskInitializationMetricsBuilder subTaskInitializationMetricsBuilder = new SubTaskInitializationMetricsBuilder(10L);
            subTaskInitializationMetricsBuilder.build(9L);
        });
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> {
            SubTaskInitializationMetricsBuilder subTaskInitializationMetricsBuilder = new SubTaskInitializationMetricsBuilder(-1L);
            subTaskInitializationMetricsBuilder.build(50L);
        });
    }

    @Test
    public void testDurationMetrics() {
        SubTaskInitializationMetricsBuilder subTaskInitializationMetricsBuilder = new SubTaskInitializationMetricsBuilder(10L);
        subTaskInitializationMetricsBuilder.addDurationMetric("A", 20L);
        subTaskInitializationMetricsBuilder.addDurationMetric("B", 10L);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)subTaskInitializationMetricsBuilder.build(50L).getDurationMetrics()).containsOnlyKeys((Object[])new String[]{"A", "B"})).containsEntry((Object)"A", (Object)20L)).containsEntry((Object)"B", (Object)10L);
    }
}

