/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collections;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStoreTest;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryImpl;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CheckpointsCleanerTest {
    CheckpointsCleanerTest() {
    }

    @Test
    void testNotCleanCheckpointInUse() {
        SharedStateRegistryImpl sharedStateRegistry = new SharedStateRegistryImpl();
        CheckpointsCleaner checkpointsCleaner = new CheckpointsCleaner();
        CompletedCheckpointStoreTest.TestCompletedCheckpoint cp1 = CompletedCheckpointStoreTest.createCheckpoint(1L, (SharedStateRegistry)sharedStateRegistry);
        checkpointsCleaner.addSubsumedCheckpoint((CompletedCheckpoint)cp1);
        CompletedCheckpointStoreTest.TestCompletedCheckpoint cp2 = CompletedCheckpointStoreTest.createCheckpoint(2L, (SharedStateRegistry)sharedStateRegistry);
        checkpointsCleaner.addSubsumedCheckpoint((CompletedCheckpoint)cp2);
        CompletedCheckpointStoreTest.TestCompletedCheckpoint cp3 = CompletedCheckpointStoreTest.createCheckpoint(3L, (SharedStateRegistry)sharedStateRegistry);
        checkpointsCleaner.addSubsumedCheckpoint((CompletedCheckpoint)cp3);
        checkpointsCleaner.cleanSubsumedCheckpoints(3L, Collections.singleton(1L), () -> {}, Executors.directExecutor());
        Assertions.assertThat((boolean)cp1.isDiscarded()).isFalse();
        Assertions.assertThat((boolean)cp2.isDiscarded()).isTrue();
    }

    @Test
    void testNotCleanHigherCheckpoint() {
        SharedStateRegistryImpl sharedStateRegistry = new SharedStateRegistryImpl();
        CheckpointsCleaner checkpointsCleaner = new CheckpointsCleaner();
        CompletedCheckpointStoreTest.TestCompletedCheckpoint cp1 = CompletedCheckpointStoreTest.createCheckpoint(1L, (SharedStateRegistry)sharedStateRegistry);
        checkpointsCleaner.addSubsumedCheckpoint((CompletedCheckpoint)cp1);
        CompletedCheckpointStoreTest.TestCompletedCheckpoint cp2 = CompletedCheckpointStoreTest.createCheckpoint(2L, (SharedStateRegistry)sharedStateRegistry);
        checkpointsCleaner.addSubsumedCheckpoint((CompletedCheckpoint)cp2);
        CompletedCheckpointStoreTest.TestCompletedCheckpoint cp3 = CompletedCheckpointStoreTest.createCheckpoint(3L, (SharedStateRegistry)sharedStateRegistry);
        checkpointsCleaner.addSubsumedCheckpoint((CompletedCheckpoint)cp3);
        checkpointsCleaner.cleanSubsumedCheckpoints(2L, Collections.emptySet(), () -> {}, Executors.directExecutor());
        Assertions.assertThat((boolean)cp1.isDiscarded()).isTrue();
        Assertions.assertThat((boolean)cp2.isDiscarded()).isFalse();
        Assertions.assertThat((boolean)cp3.isDiscarded()).isFalse();
    }
}

