/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throwable;

import java.util.Optional;
import org.apache.flink.runtime.execution.SuppressRestartsException;
import org.apache.flink.runtime.throwable.ThrowableAnnotation;
import org.apache.flink.runtime.throwable.ThrowableClassifier;
import org.apache.flink.runtime.throwable.ThrowableType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ThrowableClassifierTest {
    ThrowableClassifierTest() {
    }

    @Test
    void testThrowableType_NonRecoverable() {
        Assertions.assertThat((Comparable)ThrowableClassifier.getThrowableType((Throwable)new SuppressRestartsException((Throwable)new Exception("")))).isEqualTo((Object)ThrowableType.NonRecoverableError);
    }

    @Test
    void testThrowableType_Recoverable() {
        Assertions.assertThat((Comparable)ThrowableClassifier.getThrowableType((Throwable)new Exception(""))).isEqualTo((Object)ThrowableType.RecoverableError);
        Assertions.assertThat((Comparable)ThrowableClassifier.getThrowableType((Throwable)new TestRecoverableErrorException())).isEqualTo((Object)ThrowableType.RecoverableError);
    }

    @Test
    void testThrowableType_EnvironmentError() {
        Assertions.assertThat((Comparable)ThrowableClassifier.getThrowableType((Throwable)new TestEnvironmentErrorException())).isEqualTo((Object)ThrowableType.EnvironmentError);
    }

    @Test
    void testThrowableType_PartitionDataMissingError() {
        Assertions.assertThat((Comparable)ThrowableClassifier.getThrowableType((Throwable)new TestPartitionDataMissingErrorException())).isEqualTo((Object)ThrowableType.PartitionDataMissingError);
    }

    @Test
    void testThrowableType_InheritError() {
        Assertions.assertThat((Comparable)ThrowableClassifier.getThrowableType((Throwable)new TestPartitionDataMissingErrorSubException())).isEqualTo((Object)ThrowableType.PartitionDataMissingError);
    }

    @Test
    void testFindThrowableOfThrowableType() {
        Assertions.assertThat((Optional)ThrowableClassifier.findThrowableOfThrowableType((Throwable)new Exception(), (ThrowableType)ThrowableType.RecoverableError)).isNotPresent();
        Assertions.assertThat((Optional)ThrowableClassifier.findThrowableOfThrowableType((Throwable)new TestPartitionDataMissingErrorException(), (ThrowableType)ThrowableType.RecoverableError)).isNotPresent();
        Assertions.assertThat((Optional)ThrowableClassifier.findThrowableOfThrowableType((Throwable)new TestRecoverableErrorException(), (ThrowableType)ThrowableType.RecoverableError)).isPresent();
        Assertions.assertThat((Optional)ThrowableClassifier.findThrowableOfThrowableType((Throwable)new Exception(new TestRecoverableErrorException()), (ThrowableType)ThrowableType.RecoverableError)).isPresent();
        Assertions.assertThat((Optional)ThrowableClassifier.findThrowableOfThrowableType((Throwable)new TestRecoverableFailureSubException(), (ThrowableType)ThrowableType.RecoverableError)).isPresent();
    }

    private static class TestRecoverableFailureSubException
    extends TestRecoverableErrorException {
        private TestRecoverableFailureSubException() {
        }
    }

    private static class TestPartitionDataMissingErrorSubException
    extends TestPartitionDataMissingErrorException {
        private TestPartitionDataMissingErrorSubException() {
        }
    }

    @ThrowableAnnotation(value=ThrowableType.RecoverableError)
    private static class TestRecoverableErrorException
    extends Exception {
        private TestRecoverableErrorException() {
        }
    }

    @ThrowableAnnotation(value=ThrowableType.EnvironmentError)
    private static class TestEnvironmentErrorException
    extends Exception {
        private TestEnvironmentErrorException() {
        }
    }

    @ThrowableAnnotation(value=ThrowableType.PartitionDataMissingError)
    private static class TestPartitionDataMissingErrorException
    extends Exception {
        private TestPartitionDataMissingErrorException() {
        }
    }
}

