/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.Collections;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StateLatencyTrackOptions;
import org.apache.flink.configuration.StateSizeTrackOptions;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.operators.testutils.DummyEnvironment;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateBackendParametersImpl;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.hashmap.HashMapStateBackend;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.metrics.AbstractMetricsTrackState;
import org.apache.flink.runtime.state.metrics.StateMetricBase;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

abstract class MetricsTrackingStateTestBase<K> {
    protected static final int SAMPLE_INTERVAL = 10;

    MetricsTrackingStateTestBase() {
    }

    protected AbstractKeyedStateBackend<K> createKeyedBackend(TypeSerializer<K> keySerializer) throws Exception {
        DummyEnvironment env = new DummyEnvironment();
        KeyGroupRange keyGroupRange = new KeyGroupRange(0, 127);
        int numberOfKeyGroups = keyGroupRange.getNumberOfKeyGroups();
        Configuration configuration = new Configuration();
        configuration.set(StateLatencyTrackOptions.LATENCY_TRACK_ENABLED, (Object)true);
        configuration.set(StateSizeTrackOptions.SIZE_TRACK_ENABLED, (Object)true);
        configuration.set(StateLatencyTrackOptions.LATENCY_TRACK_SAMPLE_INTERVAL, (Object)10);
        configuration.set(StateSizeTrackOptions.SIZE_TRACK_SAMPLE_INTERVAL, (Object)10);
        int historySize = 1000000;
        configuration.set(StateLatencyTrackOptions.LATENCY_TRACK_HISTORY_SIZE, (Object)historySize);
        configuration.set(StateSizeTrackOptions.SIZE_TRACK_HISTORY_SIZE, (Object)historySize);
        HashMapStateBackend stateBackend = new HashMapStateBackend().configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        JobID jobID = new JobID();
        TaskKvStateRegistry kvStateRegistry = env.getTaskKvStateRegistry();
        CloseableRegistry cancelStreamRegistry = new CloseableRegistry();
        return stateBackend.createKeyedStateBackend((StateBackend.KeyedStateBackendParameters)new KeyedStateBackendParametersImpl((Environment)env, jobID, "test_op", keySerializer, numberOfKeyGroups, keyGroupRange, kvStateRegistry, TtlTimeProvider.DEFAULT, (MetricGroup)new UnregisteredMetricsGroup(), Collections.emptyList(), cancelStreamRegistry));
    }

    protected <N, V, S extends InternalKvState<K, N, V>, S2 extends State, LSM extends StateMetricBase> AbstractMetricsTrackState<K, N, V, S, LSM> createMetricsTrackingState(AbstractKeyedStateBackend<K> keyedBackend, StateDescriptor<S2, V> stateDescriptor) throws Exception {
        State keyedState = keyedBackend.getOrCreateKeyedState((TypeSerializer)VoidNamespaceSerializer.INSTANCE, stateDescriptor);
        Preconditions.checkState((boolean)(keyedState instanceof AbstractMetricsTrackState));
        return (AbstractMetricsTrackState)keyedState;
    }

    abstract <V, S extends State> StateDescriptor<S, V> getStateDescriptor();

    abstract TypeSerializer<K> getKeySerializer();

    abstract void setCurrentKey(AbstractKeyedStateBackend<K> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testLatencyTrackingStateClear() throws Exception {
        AbstractKeyedStateBackend<K> keyedBackend = this.createKeyedBackend(this.getKeySerializer());
        try {
            AbstractMetricsTrackState latencyTrackingState = this.createMetricsTrackingState(keyedBackend, this.getStateDescriptor());
            latencyTrackingState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            StateMetricBase latencyTrackingStateMetric = latencyTrackingState.getLatencyTrackingStateMetric();
            Assertions.assertThat((int)latencyTrackingStateMetric.getClearCount()).isZero();
            this.setCurrentKey(keyedBackend);
            for (int index = 1; index <= 10; ++index) {
                int expectedResult = index == 10 ? 0 : index;
                latencyTrackingState.clear();
                Assertions.assertThat((int)latencyTrackingStateMetric.getClearCount()).isEqualTo(expectedResult);
            }
        }
        finally {
            if (keyedBackend != null) {
                keyedBackend.close();
                keyedBackend.dispose();
            }
        }
    }
}

