/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import java.util.Arrays;
import java.util.Random;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphBuilder;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.scheduler.adaptivebatch.NonAdaptiveExecutionHandler;
import org.apache.flink.runtime.util.JobVertexConnectionUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class NonAdaptiveExecutionHandlerTest {
    NonAdaptiveExecutionHandlerTest() {
    }

    @Test
    void testGetInitialParallelismAndNotifyJobVertexParallelismDecided() {
        JobVertex v1 = new JobVertex("v1");
        JobVertex v2 = new JobVertex("v2");
        JobVertexConnectionUtils.connectNewDataSetAsInput(v2, v1, DistributionPattern.POINTWISE, ResultPartitionType.BLOCKING, false, true);
        JobGraph jobGraph = JobGraphBuilder.newBatchJobGraphBuilder().addJobVertices(Arrays.asList(v1, v2)).build();
        NonAdaptiveExecutionHandler handler = new NonAdaptiveExecutionHandler(jobGraph);
        Assertions.assertThat((int)handler.getInitialParallelism(v1.getID())).isEqualTo(v1.getParallelism());
        Random random = new Random();
        int parallelism = 1 + random.nextInt(8);
        handler.notifyJobVertexParallelismDecided(v1.getID(), parallelism);
        Assertions.assertThat((int)handler.getInitialParallelism(v2.getID())).isEqualTo(parallelism);
    }
}

