/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.compatibility;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.rest.compatibility.Compatibility;
import org.apache.flink.runtime.rest.compatibility.CompatibilityCheckResult;
import org.apache.flink.runtime.rest.compatibility.CompatibilityRoutine;
import org.apache.flink.runtime.rest.compatibility.CompatibilityRoutines;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.util.DocumentingRestEndpoint;
import org.apache.flink.runtime.rest.versioning.RestAPIVersion;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.PrettyPrinter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.util.DefaultIndenter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.util.jackson.JacksonMapperFactory;
import org.junit.jupiter.api.Assertions;

public final class RestAPIStabilityTestUtils {
    private static final ObjectMapper OBJECT_MAPPER = JacksonMapperFactory.createObjectMapper();

    public static void testStability(String snapshotFileName, String snapshotRegenerateProperty, RestAPIVersion apiVersion, DocumentingRestEndpoint documentingRestEndpoint) throws IOException {
        URL resource;
        String versionedSnapshotFileName = String.format(snapshotFileName, apiVersion.getURLVersionPrefix());
        RestAPISnapshot currentSnapshot = RestAPIStabilityTestUtils.createSnapshot(documentingRestEndpoint, apiVersion);
        if (System.getProperty(snapshotRegenerateProperty) != null) {
            RestAPIStabilityTestUtils.writeSnapshot(versionedSnapshotFileName, currentSnapshot);
        }
        if ((resource = RestAPIStabilityTestUtils.class.getClassLoader().getResource(versionedSnapshotFileName)) == null) {
            Assertions.fail((String)("Snapshot file does not exist. If you added a new version, re-run this test with -D" + snapshotFileName + " being set."));
        }
        RestAPISnapshot previousSnapshot = (RestAPISnapshot)OBJECT_MAPPER.readValue(resource, RestAPISnapshot.class);
        RestAPIStabilityTestUtils.assertCompatible(snapshotRegenerateProperty, previousSnapshot, currentSnapshot);
    }

    private static void writeSnapshot(String versionedSnapshotFileName, RestAPISnapshot snapshot) throws IOException {
        OBJECT_MAPPER.writer((PrettyPrinter)new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter().withLinefeed("\n"))).writeValue(new File("src/test/resources/" + versionedSnapshotFileName), (Object)snapshot);
        System.out.println("REST API snapshot " + versionedSnapshotFileName + " was updated, please remember to commit the snapshot.");
    }

    private static RestAPISnapshot createSnapshot(DocumentingRestEndpoint restEndpoint, RestAPIVersion apiVersion) {
        List<JsonNode> calls = restEndpoint.getSpecs().stream().filter(spec -> spec.getSupportedAPIVersions().contains(apiVersion)).map(spec -> {
            ObjectNode json = OBJECT_MAPPER.createObjectNode();
            for (CompatibilityRoutine<?> routine : CompatibilityRoutines.ROUTINES) {
                Object extract = routine.getContainer((MessageHeaders<?, ?, ?>)spec);
                json.set(routine.getKey(), OBJECT_MAPPER.valueToTree(extract));
            }
            return json;
        }).collect(Collectors.toList());
        return new RestAPISnapshot(calls);
    }

    private static void assertCompatible(String snapshotRegenerateProperty, RestAPISnapshot old, RestAPISnapshot cur) {
        List<Object> compatibilityCheckResults;
        for (JsonNode oldCall2 : old.calls) {
            compatibilityCheckResults = cur.calls.stream().map(curCall -> Tuple2.of((Object)curCall, (Object)RestAPIStabilityTestUtils.checkCompatibility(oldCall2, curCall))).collect(Collectors.toList());
            if (compatibilityCheckResults.stream().allMatch(result -> ((CompatibilityCheckResult)result.f1).getBackwardCompatibility() == Compatibility.INCOMPATIBLE)) {
                RestAPIStabilityTestUtils.fail(oldCall2, compatibilityCheckResults);
            }
            if (!compatibilityCheckResults.stream().noneMatch(result -> ((CompatibilityCheckResult)result.f1).getBackwardCompatibility() == Compatibility.IDENTICAL)) continue;
            Assertions.fail((String)("The Rest API was modified in a compatible way, but the snapshot was not updated. To update the snapshot, re-run this test with -D" + snapshotRegenerateProperty + " being set. If you see this message in a CI pipeline, rerun the test locally and commit the generated changes."));
        }
        for (JsonNode curCall2 : cur.calls) {
            compatibilityCheckResults = old.calls.stream().map(oldCall -> Tuple2.of((Object)curCall2, (Object)RestAPIStabilityTestUtils.checkCompatibility(oldCall, curCall2))).collect(Collectors.toList());
            if (!compatibilityCheckResults.stream().noneMatch(result -> ((CompatibilityCheckResult)result.f1).getBackwardCompatibility() == Compatibility.IDENTICAL)) continue;
            Assertions.fail((String)("API was modified in a compatible way, but the snapshot was not updated. To update the snapshot, re-run this test with -D" + snapshotRegenerateProperty + " being set."));
        }
    }

    private static void fail(JsonNode oldCall, List<Tuple2<JsonNode, CompatibilityCheckResult>> compatibilityCheckResults) {
        StringBuilder sb = new StringBuilder();
        sb.append("No compatible call could be found for " + oldCall + ".");
        compatibilityCheckResults.stream().sorted(Collections.reverseOrder(Comparator.comparingInt(tuple -> ((CompatibilityCheckResult)tuple.f1).getBackwardCompatibilityGrade()))).forEachOrdered(result -> {
            sb.append(System.lineSeparator());
            sb.append("\tRejected by candidate: " + result.f0 + ".");
            sb.append(System.lineSeparator());
            sb.append("\tCompatibility grade: " + ((CompatibilityCheckResult)result.f1).getBackwardCompatibilityGrade() + "/" + CompatibilityRoutines.ROUTINES.size());
            sb.append(System.lineSeparator());
            sb.append("\tIncompatibilities: ");
            for (AssertionError error : ((CompatibilityCheckResult)result.f1).getBackwardCompatibilityErrors()) {
                sb.append(System.lineSeparator());
                sb.append("\t\t" + ((Throwable)((Object)error)).getMessage());
            }
        });
        Assertions.fail((String)sb.toString());
    }

    private static CompatibilityCheckResult checkCompatibility(JsonNode oldCall, JsonNode newCall) {
        return CompatibilityRoutines.ROUTINES.stream().map(routine -> RestAPIStabilityTestUtils.checkCompatibility(routine, oldCall, newCall)).reduce(CompatibilityCheckResult::merge).get();
    }

    private static <X> CompatibilityCheckResult checkCompatibility(CompatibilityRoutine<X> routine, JsonNode oldCall, JsonNode curCall) {
        Optional<X> old = RestAPIStabilityTestUtils.readJson(routine, oldCall);
        Optional<X> cur = RestAPIStabilityTestUtils.readJson(routine, curCall);
        return routine.checkCompatibility(old, cur);
    }

    private static <X> Optional<X> readJson(CompatibilityRoutine<X> routine, JsonNode call) {
        Optional<JsonNode> jsonContainer = Optional.ofNullable(call.get(routine.getKey()));
        return jsonContainer.map(container -> RestAPIStabilityTestUtils.jsonToObject(container, routine.getContainerClass()));
    }

    private static <X> X jsonToObject(JsonNode jsonContainer, Class<X> containerClass) {
        try {
            return (X)OBJECT_MAPPER.treeToValue((TreeNode)jsonContainer, containerClass);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static final class RestAPISnapshot {
        public List<JsonNode> calls;

        private RestAPISnapshot() {
        }

        RestAPISnapshot(List<JsonNode> calls) {
            this.calls = calls;
        }
    }
}

