/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.LeaderInformationRegister;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;
import org.apache.flink.util.function.TriConsumer;

public class TestingLeaderElectionDriver
implements LeaderElectionDriver {
    private final Function<ReentrantLock, Boolean> hasLeadershipFunction;
    private final TriConsumer<ReentrantLock, String, LeaderInformation> publishLeaderInformationConsumer;
    private final BiConsumer<ReentrantLock, String> deleteLeaderInformationConsumer;
    private final ThrowingConsumer<ReentrantLock, Exception> closeConsumer;
    private final ReentrantLock lock = new ReentrantLock();

    public TestingLeaderElectionDriver(Function<ReentrantLock, Boolean> hasLeadershipFunction, TriConsumer<ReentrantLock, String, LeaderInformation> publishLeaderInformationConsumer, BiConsumer<ReentrantLock, String> deleteLeaderInformationConsumer, ThrowingConsumer<ReentrantLock, Exception> closeConsumer) {
        this.hasLeadershipFunction = hasLeadershipFunction;
        this.publishLeaderInformationConsumer = publishLeaderInformationConsumer;
        this.deleteLeaderInformationConsumer = deleteLeaderInformationConsumer;
        this.closeConsumer = closeConsumer;
    }

    public boolean hasLeadership() {
        return this.hasLeadershipFunction.apply(this.lock);
    }

    public void publishLeaderInformation(String componentId, LeaderInformation leaderInformation) {
        this.publishLeaderInformationConsumer.accept((Object)this.lock, (Object)componentId, (Object)leaderInformation);
    }

    public void deleteLeaderInformation(String componentId) {
        this.deleteLeaderInformationConsumer.accept(this.lock, componentId);
    }

    public void close() throws Exception {
        this.closeConsumer.accept((Object)this.lock);
    }

    public static Builder newNoOpBuilder() {
        return new Builder();
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public static Builder newBuilder(AtomicBoolean grantLeadership) {
        return TestingLeaderElectionDriver.newBuilder(grantLeadership, new AtomicReference<LeaderInformationRegister>(), new AtomicBoolean());
    }

    public static Builder newBuilder(AtomicBoolean hasLeadership, AtomicReference<LeaderInformationRegister> storedLeaderInformation, AtomicBoolean isClosed) {
        Preconditions.checkState((storedLeaderInformation.get() == null || !storedLeaderInformation.get().getRegisteredComponentIds().iterator().hasNext() ? 1 : 0) != 0, (Object)"Initial state check for storedLeaderInformation failed.");
        Preconditions.checkState((!isClosed.get() ? 1 : 0) != 0, (Object)"Initial state check for isClosed failed.");
        return TestingLeaderElectionDriver.newNoOpBuilder().setHasLeadershipFunction(lock -> {
            try {
                lock.lock();
                Boolean bl = hasLeadership.get();
                return bl;
            }
            finally {
                lock.unlock();
            }
        }).setPublishLeaderInformationConsumer((TriConsumer<ReentrantLock, String, LeaderInformation>)((TriConsumer)(lock, componentId, leaderInformation) -> {
            try {
                lock.lock();
                if (hasLeadership.get()) {
                    storedLeaderInformation.getAndUpdate(oldData -> LeaderInformationRegister.merge((LeaderInformationRegister)oldData, (String)componentId, (LeaderInformation)leaderInformation));
                }
            }
            finally {
                lock.unlock();
            }
        })).setDeleteLeaderInformationConsumer((lock, componentId) -> {
            try {
                lock.lock();
                if (hasLeadership.get()) {
                    storedLeaderInformation.getAndUpdate(oldData -> LeaderInformationRegister.clear((LeaderInformationRegister)oldData, (String)componentId));
                }
            }
            finally {
                lock.unlock();
            }
        }).setCloseConsumer((ThrowingConsumer<ReentrantLock, Exception>)((ThrowingConsumer)lock -> {
            try {
                lock.lock();
                isClosed.set(true);
            }
            finally {
                lock.unlock();
            }
        }));
    }

    public static class Builder {
        private Function<ReentrantLock, Boolean> hasLeadershipFunction = ignoredLock -> false;
        private TriConsumer<ReentrantLock, String, LeaderInformation> publishLeaderInformationConsumer = (ignoredLock, ignoredComponentId, ignoredLeaderInformation) -> {};
        private BiConsumer<ReentrantLock, String> deleteLeaderInformationConsumer = (ignoredLock, ignoredComponentId) -> {};
        private ThrowingConsumer<ReentrantLock, Exception> closeConsumer = ignoredLock -> {};

        private Builder() {
        }

        public Builder setHasLeadershipFunction(Function<ReentrantLock, Boolean> hasLeadershipFunction) {
            this.hasLeadershipFunction = hasLeadershipFunction;
            return this;
        }

        public Builder setPublishLeaderInformationConsumer(TriConsumer<ReentrantLock, String, LeaderInformation> publishLeaderInformationConsumer) {
            this.publishLeaderInformationConsumer = publishLeaderInformationConsumer;
            return this;
        }

        public Builder setDeleteLeaderInformationConsumer(BiConsumer<ReentrantLock, String> deleteLeaderInformationConsumer) {
            this.deleteLeaderInformationConsumer = deleteLeaderInformationConsumer;
            return this;
        }

        public Builder setCloseConsumer(ThrowingConsumer<ReentrantLock, Exception> closeConsumer) {
            this.closeConsumer = closeConsumer;
            return this;
        }

        public TestingLeaderElectionDriver build(LeaderElectionDriver.Listener ignoredListener) {
            return new TestingLeaderElectionDriver(this.hasLeadershipFunction, this.publishLeaderInformationConsumer, this.deleteLeaderInformationConsumer, this.closeConsumer);
        }
    }

    public static class Factory
    implements LeaderElectionDriverFactory {
        private final Builder driverBuilder;
        private final Queue<TestingLeaderElectionDriver> createdDrivers = new ConcurrentLinkedQueue<TestingLeaderElectionDriver>();

        public static Factory createFactoryWithNoOpDriver() {
            return new Factory(TestingLeaderElectionDriver.newNoOpBuilder());
        }

        public static Factory defaultDriverFactory(AtomicBoolean hasLeadership, AtomicReference<LeaderInformationRegister> storedLeaderInformation, AtomicBoolean isClosed) {
            return new Factory(TestingLeaderElectionDriver.newBuilder(hasLeadership, storedLeaderInformation, isClosed));
        }

        public Factory(Builder driverBuilder) {
            this.driverBuilder = driverBuilder;
        }

        public LeaderElectionDriver create(LeaderElectionDriver.Listener leaderElectionListener) throws Exception {
            TestingLeaderElectionDriver driver = this.driverBuilder.build(leaderElectionListener);
            this.createdDrivers.add(driver);
            return driver;
        }

        public TestingLeaderElectionDriver assertAndGetOnlyCreatedDriver() {
            TestingLeaderElectionDriver driver = this.createdDrivers.poll();
            if (driver == null) {
                throw new AssertionError((Object)"No driver was created by this factory, yet.");
            }
            if (!this.createdDrivers.isEmpty()) {
                throw new AssertionError((Object)"More than one driver was created by this factory.");
            }
            return driver;
        }

        public int getCreatedDriverCount() {
            return this.createdDrivers.size();
        }
    }
}

