/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;

public class TestingLeaderElection
implements LeaderElection {
    @Nullable
    private LeaderContender contender = null;
    @Nullable
    private CompletableFuture<LeaderInformation> confirmationFuture = null;
    @Nullable
    private UUID issuedLeaderSessionId = null;
    private CompletableFuture<Void> startFuture = new CompletableFuture();

    public synchronized void startLeaderElection(LeaderContender contender) throws Exception {
        Preconditions.checkNotNull((Object)contender);
        Preconditions.checkState((this.contender == null ? 1 : 0) != 0, (Object)"Only one contender is supported.");
        this.contender = contender;
        if (this.hasLeadership()) {
            contender.grantLeadership(this.issuedLeaderSessionId);
        }
        this.startFuture.complete(null);
    }

    public synchronized CompletableFuture<Void> confirmLeadershipAsync(UUID leaderSessionID, String leaderAddress) {
        if (leaderSessionID.equals(this.issuedLeaderSessionId) && this.confirmationFuture != null && !this.confirmationFuture.isDone()) {
            this.confirmationFuture.complete(LeaderInformation.known((UUID)leaderSessionID, (String)leaderAddress));
        }
        return FutureUtils.completedVoidFuture();
    }

    public synchronized CompletableFuture<Boolean> hasLeadershipAsync(UUID leaderSessionId) {
        return CompletableFuture.completedFuture(this.hasLeadership() && leaderSessionId.equals(this.issuedLeaderSessionId));
    }

    private boolean hasLeadership() {
        return this.issuedLeaderSessionId != null;
    }

    public synchronized void close() {
        if (this.hasLeadership() && this.contender != null) {
            this.contender.revokeLeadership();
        }
        if (this.confirmationFuture != null) {
            this.confirmationFuture.cancel(true);
            this.confirmationFuture = null;
        }
        this.contender = null;
        this.startFuture.cancel(false);
        this.startFuture = new CompletableFuture();
    }

    public synchronized CompletableFuture<LeaderInformation> isLeader(UUID leaderSessionID) {
        if (this.confirmationFuture != null) {
            this.confirmationFuture.cancel(false);
        }
        this.confirmationFuture = new CompletableFuture();
        this.issuedLeaderSessionId = leaderSessionID;
        if (this.contender != null) {
            this.contender.grantLeadership(leaderSessionID);
        }
        return this.confirmationFuture;
    }

    public synchronized void notLeader() {
        Preconditions.checkState((boolean)this.hasLeadership(), (Object)"Leadership should have been acquired before calling this method.");
        this.issuedLeaderSessionId = null;
        if (this.contender != null) {
            this.contender.revokeLeadership();
        }
    }

    public synchronized CompletableFuture<Void> getStartFuture() {
        return this.startFuture;
    }

    public synchronized boolean isStopped() {
        return this.contender == null;
    }
}

