/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobmaster.DefaultExecutionDeploymentTracker;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentState;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentTracker;

public class TestingExecutionDeploymentTrackerWrapper
implements ExecutionDeploymentTracker {
    private final ExecutionDeploymentTracker originalTracker;
    private final CompletableFuture<ExecutionAttemptID> taskDeploymentFuture;
    private final CompletableFuture<ExecutionAttemptID> stopFuture;
    private final Set<ExecutionAttemptID> deployedExecutions = new HashSet<ExecutionAttemptID>();

    public TestingExecutionDeploymentTrackerWrapper() {
        this((ExecutionDeploymentTracker)new DefaultExecutionDeploymentTracker());
    }

    public TestingExecutionDeploymentTrackerWrapper(ExecutionDeploymentTracker originalTracker) {
        this.originalTracker = originalTracker;
        this.taskDeploymentFuture = new CompletableFuture();
        this.stopFuture = new CompletableFuture();
    }

    public void startTrackingPendingDeploymentOf(ExecutionAttemptID executionAttemptId, ResourceID host) {
        this.originalTracker.startTrackingPendingDeploymentOf(executionAttemptId, host);
    }

    public void completeDeploymentOf(ExecutionAttemptID executionAttemptId) {
        this.originalTracker.completeDeploymentOf(executionAttemptId);
        this.taskDeploymentFuture.complete(executionAttemptId);
        this.deployedExecutions.add(executionAttemptId);
    }

    public void stopTrackingDeploymentOf(ExecutionAttemptID executionAttemptId) {
        this.originalTracker.stopTrackingDeploymentOf(executionAttemptId);
        this.stopFuture.complete(executionAttemptId);
    }

    public Map<ExecutionAttemptID, ExecutionDeploymentState> getExecutionsOn(ResourceID host) {
        return this.originalTracker.getExecutionsOn(host);
    }

    public CompletableFuture<ExecutionAttemptID> getTaskDeploymentFuture() {
        return this.taskDeploymentFuture;
    }

    public CompletableFuture<ExecutionAttemptID> getStopFuture() {
        return this.stopFuture;
    }

    public Set<ExecutionAttemptID> getDeployedExecutions() {
        return Collections.unmodifiableSet(this.deployedExecutions);
    }
}

