/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.buffer.BufferCompressor;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.TestingTieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFile;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteTierProducerAgent;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class RemoteTierProducerAgentTest {
    RemoteTierProducerAgentTest() {
    }

    @Test
    void test(@TempDir Path tempDir) throws Exception {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
        int numSubpartitions = 10;
        int bufferSizeBytes = 1024;
        int networkBufferSize = 1024;
        int numBytesPerSegment = 4096;
        SegmentPartitionFileWriter partitionFileWriter = SegmentPartitionFile.createPartitionFileWriter((String)String.format("file://%s", tempDir), (int)10);
        TestingTieredStorageMemoryManager memoryManager = new TestingTieredStorageMemoryManager.Builder().build();
        TieredStorageResourceRegistry resourceRegistry = new TieredStorageResourceRegistry();
        BufferCompressor bufferCompressor = new BufferCompressor(1024, NettyShuffleEnvironmentOptions.CompressionCodec.LZ4);
        try (RemoteTierProducerAgent agent = new RemoteTierProducerAgent(partitionId, 10, 4096, 1024, false, (PartitionFileWriter)partitionFileWriter, (TieredStorageMemoryManager)memoryManager, resourceRegistry, bufferCompressor);){
            Object bufferOwner = new Object();
            for (int i = 0; i < 10; i += 2) {
                TieredStorageSubpartitionId subpartitionId = new TieredStorageSubpartitionId(i);
                Assertions.assertThat((boolean)agent.tryStartNewSegment(subpartitionId, 0, 1)).isTrue();
                Assertions.assertThat((boolean)agent.tryWrite(subpartitionId, BufferBuilderTestUtils.buildSomeBuffer(1024), bufferOwner, 0)).isTrue();
            }
        }
        try (Stream<Path> files = Files.walk(tempDir, new FileVisitOption[0]);){
            long numFinishedSegments = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> "FINISH".equals(file.getParent().getFileName().toString())).count();
            ((AbstractLongAssert)Assertions.assertThat((long)numFinishedSegments).withFailMessage("Only every second partition should have a finished segment.", new Object[0])).isEqualTo(5L);
        }
    }
}

