/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.flink.runtime.executiongraph.failover.RestartAllFailoverStrategy;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingTopology;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RestartAllFailoverStrategyTest {
    RestartAllFailoverStrategyTest() {
    }

    @Test
    void testGetTasksNeedingRestart() {
        TestingSchedulingTopology topology = new TestingSchedulingTopology();
        TestingSchedulingExecutionVertex v1 = topology.newExecutionVertex();
        TestingSchedulingExecutionVertex v2 = topology.newExecutionVertex();
        TestingSchedulingExecutionVertex v3 = topology.newExecutionVertex();
        topology.connect(v1, v2, ResultPartitionType.PIPELINED);
        topology.connect(v2, v3, ResultPartitionType.BLOCKING);
        RestartAllFailoverStrategy strategy = new RestartAllFailoverStrategy((SchedulingTopology)topology);
        Assertions.assertThat(new HashSet<ExecutionVertexID>(Arrays.asList(v1.getId(), v2.getId(), v3.getId()))).isEqualTo((Object)strategy.getTasksNeedingRestart(v1.getId(), (Throwable)new Exception("Test failure")));
    }
}

