/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.zookeeper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.ServerConfig;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.apache.flink.util.ParameterTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkZooKeeperQuorumPeer {
    public static final int DEFAULT_ZOOKEEPER_CLIENT_PORT = 2181;
    public static final int DEFAULT_ZOOKEEPER_INIT_LIMIT = 10;
    public static final int DEFAULT_ZOOKEEPER_SYNC_LIMIT = 5;
    public static final int DEFAULT_ZOOKEEPER_PEER_PORT = 2888;
    public static final int DEFAULT_ZOOKEEPER_LEADER_PORT = 3888;
    private static final Logger LOG = LoggerFactory.getLogger(FlinkZooKeeperQuorumPeer.class);

    public static void main(String[] args) {
        try {
            EnvironmentInformation.logEnvironmentInfo(LOG, "ZooKeeper Quorum Peer", args);
            ParameterTool params = ParameterTool.fromArgs((String[])args);
            String zkConfigFile = params.getRequired("zkConfigFile");
            int peerId = params.getInt("peerId");
            FlinkZooKeeperQuorumPeer.runFlinkZkQuorumPeer(zkConfigFile, peerId);
        }
        catch (Throwable t) {
            LOG.error("Error running ZooKeeper quorum peer: " + t.getMessage(), t);
            System.exit(-1);
        }
    }

    public static void runFlinkZkQuorumPeer(String zkConfigFile, int peerId) throws Exception {
        Properties zkProps = new Properties();
        try (FileInputStream inStream = new FileInputStream(new File(zkConfigFile));){
            zkProps.load(inStream);
        }
        LOG.info("Configuration: " + zkProps);
        FlinkZooKeeperQuorumPeer.setRequiredProperties(zkProps);
        FlinkZooKeeperQuorumPeer.writeMyIdToDataDir(zkProps, peerId);
        QuorumPeerConfig conf = new QuorumPeerConfig();
        conf.parseProperties(zkProps);
        if (conf.isDistributed()) {
            LOG.info("Running distributed ZooKeeper quorum peer (total peers: {}).", (Object)conf.getServers().size());
            QuorumPeerMain qp = new QuorumPeerMain();
            qp.runFromConfig(conf);
        } else {
            LOG.info("Running standalone ZooKeeper quorum peer.");
            ZooKeeperServerMain zk = new ZooKeeperServerMain();
            ServerConfig sc = new ServerConfig();
            sc.readFrom(conf);
            zk.runFromConfig(sc);
        }
    }

    private static void setRequiredProperties(Properties zkProps) {
        if (zkProps.getProperty("clientPort") == null) {
            zkProps.setProperty("clientPort", String.valueOf(2181));
            LOG.warn("No 'clientPort' configured. Set to '{}'.", (Object)2181);
        }
        if (zkProps.getProperty("initLimit") == null) {
            zkProps.setProperty("initLimit", String.valueOf(10));
            LOG.warn("No 'initLimit' configured. Set to '{}'.", (Object)10);
        }
        if (zkProps.getProperty("syncLimit") == null) {
            zkProps.setProperty("syncLimit", String.valueOf(5));
            LOG.warn("No 'syncLimit' configured. Set to '{}'.", (Object)5);
        }
        if (zkProps.getProperty("dataDir") == null) {
            String dataDir = String.format("%s/%s/zookeeper", System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
            zkProps.setProperty("dataDir", dataDir);
            LOG.warn("No 'dataDir' configured. Set to '{}'.", (Object)dataDir);
        }
        int peerPort = 2888;
        int leaderPort = 3888;
        for (Map.Entry<Object, Object> entry : zkProps.entrySet()) {
            String address;
            String key = (String)entry.getKey();
            if (!entry.getKey().toString().startsWith("server.")) continue;
            String value = (String)entry.getValue();
            String[] parts = value.split(":");
            if (parts.length == 1) {
                address = String.format("%s:%d:%d", parts[0], peerPort, leaderPort);
                zkProps.setProperty(key, address);
                LOG.info("Set peer and leader port of '{}': '{}' => '{}'.", new Object[]{key, value, address});
                continue;
            }
            if (parts.length != 2) continue;
            address = String.format("%s:%d:%d", parts[0], Integer.valueOf(parts[1]), leaderPort);
            zkProps.setProperty(key, address);
            LOG.info("Set peer port of '{}': '{}' => '{}'.", new Object[]{key, value, address});
        }
    }

    private static void writeMyIdToDataDir(Properties zkProps, int id) throws IOException {
        if (zkProps.getProperty("dataDir") == null) {
            throw new IllegalConfigurationException("No dataDir configured.");
        }
        File dataDir = new File(zkProps.getProperty("dataDir"));
        if (!dataDir.isDirectory() && !dataDir.mkdirs()) {
            throw new IOException("Cannot create dataDir '" + dataDir + "'.");
        }
        dataDir.deleteOnExit();
        LOG.info("Writing {} to myid file in 'dataDir'.", (Object)id);
        try (FileWriter writer = new FileWriter(new File(dataDir, "myid"));){
            writer.write(String.valueOf(id));
        }
    }
}

