/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.token.hadoop;

import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.security.token.DelegationTokenReceiver;
import org.apache.flink.runtime.security.token.hadoop.HadoopDelegationTokenConverter;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class HadoopDelegationTokenReceiver
implements DelegationTokenReceiver {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public abstract String serviceName();

    public void init(Configuration configuration) throws Exception {
    }

    public void onNewTokensObtained(byte[] tokens) throws Exception {
        if (tokens == null || tokens.length == 0) {
            throw new IllegalArgumentException("Illegal tokens tried to be processed");
        }
        Credentials credentials = HadoopDelegationTokenConverter.deserialize(tokens);
        this.log.info("Updating delegation tokens for current user");
        this.dumpAllTokens(credentials);
        UserGroupInformation.getCurrentUser().addCredentials(credentials);
        this.log.info("Updated delegation tokens for current user successfully");
    }

    private void dumpAllTokens(Credentials credentials) {
        credentials.getAllTokens().forEach(token -> this.log.info("Token Service:{} Identifier:{}", (Object)token.getService(), (Object)token.getIdentifier()));
    }
}

