/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.cluster;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.ProfilingInfoList;
import org.apache.flink.runtime.util.profiler.ProfilingService;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobManagerProfilingListHandler
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, ProfilingInfoList, EmptyMessageParameters> {
    private final ProfilingService profilingService;

    public JobManagerProfilingListHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, ProfilingInfoList, EmptyMessageParameters> messageHeaders, Configuration configuration) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.profilingService = ProfilingService.getInstance(configuration);
    }

    @Override
    protected CompletableFuture<ProfilingInfoList> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        return this.profilingService.getProfilingList("JobManager").thenApply(ProfilingInfoList::new);
    }
}

