/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import org.apache.flink.core.asyncprocessing.AsyncFutureImpl;
import org.apache.flink.core.asyncprocessing.InternalAsyncFuture;
import org.apache.flink.runtime.asyncprocessing.AsyncExecutionController;
import org.apache.flink.runtime.asyncprocessing.CallbackRunnerWrapper;
import org.apache.flink.runtime.asyncprocessing.ContextAsyncFutureImpl;
import org.apache.flink.runtime.asyncprocessing.RecordContext;
import org.apache.flink.util.function.ThrowingRunnable;

public class AsyncFutureFactory<K> {
    private final AsyncExecutionController<K, ?> asyncExecutionController;
    private final CallbackRunnerWrapper callbackRunner;
    private final AsyncFutureImpl.AsyncFrameworkExceptionHandler exceptionHandler;

    AsyncFutureFactory(AsyncExecutionController<K, ?> asyncExecutionController, CallbackRunnerWrapper callbackRunner, AsyncFutureImpl.AsyncFrameworkExceptionHandler exceptionHandler) {
        this.asyncExecutionController = asyncExecutionController;
        this.callbackRunner = callbackRunner;
        this.exceptionHandler = exceptionHandler;
    }

    public <OUT> InternalAsyncFuture<OUT> create(RecordContext<K> context) {
        return new ContextAsyncFutureImpl(runnable -> this.callbackRunner.submit((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> {
            this.asyncExecutionController.setCurrentContext(context);
            runnable.run();
        })), this.exceptionHandler, context);
    }
}

