/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.DoubleLinkedList;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import org.apache.pekko.util.RecencyList;
import org.apache.pekko.util.SegmentedRecencyList$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.IndexedSeq;
import scala.collection.mutable.IndexedSeq$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric$IntIsIntegral$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction1$mcVI$sp;

@ScalaSignature(bytes="\u0006\u0001\t-vAB%K\u0011\u0003a%K\u0002\u0004U\u0015\"\u0005A*\u0016\u0005\u00069\u0006!\tA\u0018\u0005\u0006?\u0006!\t\u0001Y\u0004\b\u0005#\u000b\u0001\u0012\u0001BJ\r\u001d\u0011)*\u0001E\u0001\u0005/Ca\u0001X\u0003\u0005\u0002\te\u0005BB0\u0006\t\u0003\u0011YJ\u0002\u0004\u0002^\u00051\u0011q\f\u0005\u000b\u0003GB!Q1A\u0005\u0002\u0005\u0015\u0004BCA6\u0011\t\u0005\t\u0015!\u0003\u0002h!1A\f\u0003C\u0001\u0003[B\u0011\"!\u001e\t\u0001\u0004%\t!a\r\t\u0013\u0005]\u0004\u00021A\u0005\u0002\u0005e\u0004bBA?\u0011\u0001\u0006KA\u001c\u0005\n\u0003\u007fB\u0001\u0019!C\u0001\u0003\u0003C\u0011\"!#\t\u0001\u0004%\t!a#\t\u0011\u0005=\u0005\u0002)Q\u0005\u0003\u0007C\u0011\"!%\t\u0001\u0004%\t!a%\t\u0013\u0005]\u0005\u00021A\u0005\u0002\u0005e\u0005\u0002CAO\u0011\u0001\u0006K!!&\t\u0013\u0005}\u0005\u00021A\u0005\u0002\u0005M\u0005\"CAQ\u0011\u0001\u0007I\u0011AAR\u0011!\t9\u000b\u0003Q!\n\u0005U\u0005\"CAU\u0011\u0001\u0007I\u0011AAJ\u0011%\tY\u000b\u0003a\u0001\n\u0003\ti\u000b\u0003\u0005\u00022\"\u0001\u000b\u0015BAK\u0011%\t\u0019\f\u0003a\u0001\n\u0003\t\u0019\nC\u0005\u00026\"\u0001\r\u0011\"\u0001\u00028\"A\u00111\u0018\u0005!B\u0013\t)JB\u0003U\u0015\na5\r\u0003\u0005f=\t\u0005\t\u0015!\u0003g\u0011!\thD!A!\u0002\u0013\u0011\b\"\u0002/\u001f\t\u0003a\b\"CA\f=\u0001\u0007I\u0011BA\r\u0011%\t\tC\ba\u0001\n\u0013\t\u0019\u0003\u0003\u0005\u00020y\u0001\u000b\u0015BA\u000e\u0011%\t\tD\ba\u0001\n\u0013\t\u0019\u0004C\u0005\u00026y\u0001\r\u0011\"\u0003\u00028!9\u00111\b\u0010!B\u0013q\u0007\"CA\u001f=\t\u0007I\u0011BA\u001a\u0011\u001d\tyD\bQ\u0001\n9D\u0011\"!\u0011\u001f\u0005\u0004%I!a\r\t\u000f\u0005\rc\u0004)A\u0005]\"I\u0011Q\t\u0010C\u0002\u0013%\u00111\u0007\u0005\b\u0003\u000fr\u0002\u0015!\u0003o\u0011%\tIE\bb\u0001\n\u0013\tY\u0005\u0003\u0005\u0002>z\u0001\u000b\u0011BA'\u0011%\tyL\bb\u0001\n\u0013\t\t\r\u0003\u0005\u0002Nz\u0001\u000b\u0011BAb\u0011%\tyM\bb\u0001\n\u0013\t\t\u000e\u0003\u0005\u0002Tz\u0001\u000b\u0011BA*\u0011%\t)N\bb\u0001\n\u0013\t9\u000e\u0003\u0005\u0002`z\u0001\u000b\u0011BAm\u0011\u001d\t\tO\bC\u0001\u0003gAq!a9\u001f\t\u0003\t)\u000fC\u0004\u0002jz!\t!a;\t\u000f\u0005=h\u0004\"\u0001\u0002r\"9\u0011Q\u001f\u0010\u0005\u0002\u0005]\bb\u0002B\u0001=\u0011\u0005!1\u0001\u0005\b\u0005\u000fqB\u0011\u0001B\u0005\u0011\u001d\u0011)C\bC\u0001\u0005OAqAa\u000b\u001f\t\u0003\u00119\u0003C\u0004\u0003.y!\tAa\f\t\u000f\t\rc\u0004\"\u0001\u0003F!9!1\n\u0010\u0005\n\t5\u0003b\u0002B(=\u0011%!\u0011\u000b\u0005\b\u0005+rB\u0011\u0002B,\u0011\u001d\u0011iF\bC\u0005\u0005?BqAa\u0019\u001f\t\u0013\u0011)\u0007C\u0004\u0003jy!IAa\u001b\t\u000f\tEd\u0004\"\u0003\u0003t!9!q\u000f\u0010\u0005\n\te\u0014\u0001F*fO6,g\u000e^3e%\u0016\u001cWM\\2z\u0019&\u001cHO\u0003\u0002L\u0019\u0006!Q\u000f^5m\u0015\tie*A\u0003qK.\\wN\u0003\u0002P!\u00061\u0011\r]1dQ\u0016T\u0011!U\u0001\u0004_J<\u0007CA*\u0002\u001b\u0005Q%\u0001F*fO6,g\u000e^3e%\u0016\u001cWM\\2z\u0019&\u001cHo\u0005\u0002\u0002-B\u0011qKW\u0007\u00021*\t\u0011,A\u0003tG\u0006d\u0017-\u0003\u0002\\1\n1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002%\u0006)Q-\u001c9usV\u0019\u0011M!$\u0015\u0007\t\u0014y\t\u0005\u0003T=\t-Uc\u00013\u0002\u0002M\u0011aDV\u0001\u000eS:LG/[1m\u0019&l\u0017\u000e^:\u0011\u0007\u001ddg.D\u0001i\u0015\tI'.A\u0005j[6,H/\u00192mK*\u00111\u000eW\u0001\u000bG>dG.Z2uS>t\u0017BA7i\u0005\r\u0019V-\u001d\t\u0003/>L!\u0001\u001d-\u0003\u0007%sG/A\u0003dY>\u001c7\u000eE\u0002TgVL!\u0001\u001e&\u0003\u0013=\u0003H/[8o-\u0006d\u0007C\u0001<z\u001d\t\u0019v/\u0003\u0002y\u0015\u0006Y!+Z2f]\u000eLH*[:u\u0013\tQ8PA\u0003DY>\u001c7N\u0003\u0002y\u0015R)Q0a\u0005\u0002\u0016A\u00191K\b@\u0011\u0007}\f\t\u0001\u0004\u0001\u0005\u000f\u0005\raD1\u0001\u0002\u0006\t\t\u0011)\u0005\u0003\u0002\b\u00055\u0001cA,\u0002\n%\u0019\u00111\u0002-\u0003\u000f9{G\u000f[5oOB\u0019q+a\u0004\n\u0007\u0005E\u0001LA\u0002B]fDQ!Z\u0011A\u0002\u0019DQ!]\u0011A\u0002I\fa\u0001\\5nSR\u001cXCAA\u000e!\u00119\u0017Q\u00048\n\u0007\u0005}\u0001N\u0001\u0006J]\u0012,\u00070\u001a3TKF\f!\u0002\\5nSR\u001cx\fJ3r)\u0011\t)#a\u000b\u0011\u0007]\u000b9#C\u0002\u0002*a\u0013A!\u00168ji\"I\u0011QF\u0012\u0002\u0002\u0003\u0007\u00111D\u0001\u0004q\u0012\n\u0014a\u00027j[&$8\u000fI\u0001\u000bi>$\u0018\r\u001c'j[&$X#\u00018\u0002\u001dQ|G/\u00197MS6LGo\u0018\u0013fcR!\u0011QEA\u001d\u0011!\tiCJA\u0001\u0002\u0004q\u0017a\u0003;pi\u0006dG*[7ji\u0002\na\u0001\\3wK2\u001c\u0018a\u00027fm\u0016d7\u000fI\u0001\u0007Y><Xm\u001d;\u0002\u000f1|w/Z:uA\u00059\u0001.[4iKN$\u0018\u0001\u00035jO\",7\u000f\u001e\u0011\u0002\u0011M,w-\\3oiN,\"!!\u0014\u0011\r\u0005=\u0013\u0011KA*\u001b\u0005Q\u0017bAA\u0010UB)1+!\u0016\u0002Z%\u0019\u0011q\u000b&\u0003!\u0011{WO\u00197f\u0019&t7.\u001a3MSN$\b\u0003BA.\u0011yt!a\u0015\u0001\u0003\t9{G-Z\u000b\u0005\u0003C\nIg\u0005\u0002\t-\u0006)a/\u00197vKV\u0011\u0011q\r\t\u0004\u007f\u0006%DaBA\u0002\u0011\t\u0007\u0011QA\u0001\u0007m\u0006dW/\u001a\u0011\u0015\t\u0005=\u00141\u000f\t\u0006\u0003cB\u0011qM\u0007\u0002\u0003!9\u00111M\u0006A\u0002\u0005\u001d\u0014!\u00027fm\u0016d\u0017!\u00037fm\u0016dw\fJ3r)\u0011\t)#a\u001f\t\u0011\u00055R\"!AA\u00029\fa\u0001\\3wK2\u0004\u0013!\u0003;j[\u0016\u001cH/Y7q+\t\t\u0019\tE\u0002X\u0003\u000bK1!a\"Y\u0005\u0011auN\\4\u0002\u001bQLW.Z:uC6\u0004x\fJ3r)\u0011\t)#!$\t\u0013\u00055\u0002#!AA\u0002\u0005\r\u0015A\u0003;j[\u0016\u001cH/Y7qA\u0005QA.Z:t%\u0016\u001cWM\u001c;\u0016\u0005\u0005U\u0005\u0003B*t\u0003_\na\u0002\\3tgJ+7-\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002&\u0005m\u0005\"CA\u0017'\u0005\u0005\t\u0019AAK\u0003-aWm]:SK\u000e,g\u000e\u001e\u0011\u0002\u00155|'/\u001a*fG\u0016tG/\u0001\bn_J,'+Z2f]R|F%Z9\u0015\t\u0005\u0015\u0012Q\u0015\u0005\n\u0003[1\u0012\u0011!a\u0001\u0003+\u000b1\"\\8sKJ+7-\u001a8uA\u0005\trN^3sC2dG*Z:t%\u0016\u001cWM\u001c;\u0002+=4XM]1mY2+7o\u001d*fG\u0016tGo\u0018\u0013fcR!\u0011QEAX\u0011%\ti#GA\u0001\u0002\u0004\t)*\u0001\npm\u0016\u0014\u0018\r\u001c7MKN\u001c(+Z2f]R\u0004\u0013!E8wKJ\fG\u000e\\'pe\u0016\u0014VmY3oi\u0006)rN^3sC2dWj\u001c:f%\u0016\u001cWM\u001c;`I\u0015\fH\u0003BA\u0013\u0003sC\u0011\"!\f\u001d\u0003\u0003\u0005\r!!&\u0002%=4XM]1mY6{'/\u001a*fG\u0016tG\u000fI\u0001\ng\u0016<W.\u001a8ug\u0002\nQa]5{KN,\"!a1\u0011\u000b\u0005\u0015\u00171\u001a8\u000e\u0005\u0005\u001d'bAAeU\u00069Q.\u001e;bE2,\u0017\u0002BA\u0010\u0003\u000f\faa]5{KN\u0004\u0013AD8wKJ\fG\u000e\u001c*fG\u0016t7-_\u000b\u0003\u0003'\nqb\u001c<fe\u0006dGNU3dK:\u001c\u0017\u0010I\u0001\u000bY>|7.\u001e9O_\u0012,WCAAm!\u001d\t)-a7\u007f\u00033JA!!8\u0002H\n\u0019Q*\u00199\u0002\u00171|wn[;q\u001d>$W\rI\u0001\u0005g&TX-\u0001\u0004tSj,wJ\u001a\u000b\u0004]\u0006\u001d\bBBA;o\u0001\u0007a.\u0001\u0004va\u0012\fG/\u001a\u000b\u0004{\u00065\bBBA2q\u0001\u0007a0\u0001\u0004sK6|g/\u001a\u000b\u0004{\u0006M\bBBA2s\u0001\u0007a0\u0001\u0005d_:$\u0018-\u001b8t)\u0011\tI0a@\u0011\u0007]\u000bY0C\u0002\u0002~b\u0013qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002di\u0002\rA`\u0001\fY\u0016\f7\u000f\u001e*fG\u0016tG/\u0006\u0002\u0003\u0006A\u00191k\u001d@\u0002'1,\u0017m\u001d;U_6{7\u000f\u001e*fG\u0016tGo\u00144\u0015\t\t-!1\u0005\t\u0006\u0005\u001b\u0011iB \b\u0005\u0005\u001f\u0011IB\u0004\u0003\u0003\u0012\t]QB\u0001B\n\u0015\r\u0011)\"X\u0001\u0007yI|w\u000e\u001e \n\u0003eK1Aa\u0007Y\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\b\u0003\"\tA\u0011\n^3sCR|'OC\u0002\u0003\u001caCa!!\u001e=\u0001\u0004q\u0017A\u0007:f[>4X\rT3bgR\u0014VmY3oi>3XM\u001d'j[&$HC\u0001B\u0015!\r9GN`\u0001\u0012e\u0016lwN^3MK\u0006\u001cHOU3dK:$\u0018a\b:f[>4Xm\u0014<fe\u0006dG\u000eT3bgR\u0014VmY3oi>+Ho]5eKR!!\u0011\u0006B\u0019\u0011\u001d\u0011\u0019d\u0010a\u0001\u0005k\t\u0001\u0002Z;sCRLwN\u001c\t\u0005\u0005o\u0011y$\u0004\u0002\u0003:)!!1\u0007B\u001e\u0015\r\u0011i\u0004W\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002\u0002B!\u0005s\u0011aBR5oSR,G)\u001e:bi&|g.\u0001\u0007va\u0012\fG/\u001a'j[&$8\u000f\u0006\u0003\u0002&\t\u001d\u0003B\u0002B%\u0001\u0002\u0007a-A\u0005oK^d\u0015.\\5ug\u0006)\u0012\r\u001a6vgR\u0004&o\u001c;fGR,G\rT3wK2\u001cHCAA\u0013\u0003\u0019\tGM[;tiR!\u0011Q\u0005B*\u0011\u0019\t)H\u0011a\u0001]\u00061\u0011N\\:feR$B!!\n\u0003Z!9!1L\"A\u0002\u0005e\u0013\u0001\u00028pI\u0016\fq\u0001\u001d:p[>$X\r\u0006\u0003\u0002&\t\u0005\u0004b\u0002B.\t\u0002\u0007\u0011\u0011L\u0001\u0007I\u0016lw\u000e^3\u0015\t\u0005\u0015\"q\r\u0005\b\u00057*\u0005\u0019AA-\u0003!\t\u0007\u000f]3oIR{GCBA\u0013\u0005[\u0012y\u0007\u0003\u0004\u0002v\u0019\u0003\rA\u001c\u0005\b\u000572\u0005\u0019AA-\u0003Y\u0011X-\\8wK\u001a\u0013x.\\\"veJ,g\u000e\u001e'fm\u0016dG\u0003BA\u0013\u0005kBqAa\u0017H\u0001\u0004\tI&\u0001\u0006sK6|g/\u001a(pI\u0016$2A B>\u0011\u001d\u0011Y\u0006\u0013a\u0001\u00033B3A\bB@!\u0011\u0011\tIa\"\u000e\u0005\t\r%b\u0001BC\u0019\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t%%1\u0011\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000eE\u0002\u0000\u0005\u001b#q!a\u0001\u0004\u0005\u0004\t)\u0001\u0003\u0004\u0002\u0018\r\u0001\rAZ\u0001\u0013o&$\bn\u0014<fe\u0006dGNU3dK:\u001c\u0017\u0010E\u0002\u0002r\u0015\u0011!c^5uQ>3XM]1mYJ+7-\u001a8dsN\u0011QA\u0016\u000b\u0003\u0005'+BA!(\u0003$R!!q\u0014BS!\u0011\u0019fD!)\u0011\u0007}\u0014\u0019\u000bB\u0004\u0002\u0004\u001d\u0011\r!!\u0002\t\r\u0005]q\u00011\u0001gQ\r\t!q\u0010\u0015\u0004\u0001\t}\u0004")
@InternalApi
public final class SegmentedRecencyList<A> {
    private final RecencyList.Clock clock;
    private scala.collection.immutable.IndexedSeq<Object> limits;
    private int totalLimit;
    private final int levels;
    private final int lowest;
    private final int highest;
    private final scala.collection.IndexedSeq<DoubleLinkedList<Node<A>>> segments;
    private final IndexedSeq<Object> sizes;
    private final DoubleLinkedList<Node<A>> overallRecency;
    private final Map<A, Node<A>> lookupNode;

    public static <A> SegmentedRecencyList<A> empty(scala.collection.immutable.Seq<Object> seq) {
        return SegmentedRecencyList$.MODULE$.empty(seq);
    }

    private scala.collection.immutable.IndexedSeq<Object> limits() {
        return this.limits;
    }

    private void limits_$eq(scala.collection.immutable.IndexedSeq<Object> x$1) {
        this.limits = x$1;
    }

    private int totalLimit() {
        return this.totalLimit;
    }

    private void totalLimit_$eq(int x$1) {
        this.totalLimit = x$1;
    }

    private int levels() {
        return this.levels;
    }

    private int lowest() {
        return this.lowest;
    }

    private int highest() {
        return this.highest;
    }

    private scala.collection.IndexedSeq<DoubleLinkedList<Node<A>>> segments() {
        return this.segments;
    }

    private IndexedSeq<Object> sizes() {
        return this.sizes;
    }

    private DoubleLinkedList<Node<A>> overallRecency() {
        return this.overallRecency;
    }

    private Map<A, Node<A>> lookupNode() {
        return this.lookupNode;
    }

    public int size() {
        return this.lookupNode().size();
    }

    public int sizeOf(int level) {
        return BoxesRunTime.unboxToInt(this.sizes().apply(level));
    }

    public SegmentedRecencyList<A> update(A value) {
        if (this.lookupNode().contains(value)) {
            this.promote((Node)this.lookupNode().apply(value));
        } else {
            this.insert(new Node<A>(value));
        }
        return this;
    }

    public SegmentedRecencyList<A> remove(A value) {
        if (this.lookupNode().contains(value)) {
            this.removeNode((Node)this.lookupNode().apply(value));
        }
        return this;
    }

    public boolean contains(A value) {
        return this.lookupNode().contains(value);
    }

    public A leastRecent() {
        Node node = (Node)((DoubleLinkedList)this.segments().apply(this.lowest())).getFirst();
        Node node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node first = OptionVal$.MODULE$.get$extension(node2);
            return OptionVal$Some$.MODULE$.apply(first.value());
        }
        return OptionVal$.MODULE$.none();
    }

    public Iterator<A> leastToMostRecentOf(int level) {
        return ((DoubleLinkedList)this.segments().apply(level)).forwardIterator().map((Function1<Node, Object> & Serializable & scala.Serializable)x$5 -> x$5.value());
    }

    public scala.collection.immutable.Seq<A> removeLeastRecentOverLimit() {
        if (this.size() > this.totalLimit()) {
            this.adjustProtectedLevels();
            int excess = this.size() - this.totalLimit();
            if (excess == 1) {
                return this.removeLeastRecent();
            }
            return ((DoubleLinkedList)this.segments().apply(this.lowest())).forwardIterator().take(excess).map((Function1<Node, Object> & Serializable & scala.Serializable)node -> this.removeNode((Node)node)).toList();
        }
        return Nil$.MODULE$;
    }

    public scala.collection.immutable.Seq<A> removeLeastRecent() {
        Node node = (Node)((DoubleLinkedList)this.segments().apply(this.lowest())).getFirst();
        Node node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node first = OptionVal$.MODULE$.get$extension(node2);
            return List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray(new Object[]{this.removeNode(first)}));
        }
        return Nil$.MODULE$;
    }

    public scala.collection.immutable.Seq<A> removeOverallLeastRecentOutside(FiniteDuration duration) {
        if (OptionVal$.MODULE$.isEmpty$extension(this.clock)) {
            throw new UnsupportedOperationException("Overall recency is not enabled");
        }
        long min = OptionVal$.MODULE$.get$extension(this.clock).earlierTime(duration);
        return this.overallRecency().forwardIterator().takeWhile((Function1<Node, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean(SegmentedRecencyList.$anonfun$removeOverallLeastRecentOutside$1(min, x$6))).map((Function1<Node, Object> & Serializable & scala.Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public void updateLimits(scala.collection.immutable.Seq<Object> newLimits) {
        this.limits_$eq(newLimits.toIndexedSeq());
        this.totalLimit_$eq(BoxesRunTime.unboxToInt(this.limits().sum(Numeric$IntIsIntegral$.MODULE$)));
    }

    private void adjustProtectedLevels() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.highest()), this.lowest()).by(-1).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)level -> this.adjust(level));
    }

    private void adjust(int level) {
        int excess = BoxesRunTime.unboxToInt(this.sizes().apply(level)) - BoxesRunTime.unboxToInt(this.limits().apply(level));
        if (excess > 0) {
            ((DoubleLinkedList)this.segments().apply(level)).forwardIterator().take(excess).foreach((Function1<Node, Object> & Serializable & scala.Serializable)node -> {
                this.demote(node);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void insert(Node<A> node) {
        this.appendTo(this.lowest(), node);
        this.lookupNode().$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(node.value()), node));
        if (OptionVal$.MODULE$.isDefined$extension(this.clock)) {
            node.timestamp_$eq(OptionVal$.MODULE$.get$extension(this.clock).currentTime());
            this.overallRecency().append(node);
            return;
        }
    }

    private void promote(Node<A> node) {
        if (node.level() == this.highest()) {
            ((DoubleLinkedList)this.segments().apply(node.level())).moveToBack(node);
        } else {
            int newLevel = node.level() + 1;
            this.removeFromCurrentLevel(node);
            this.appendTo(newLevel, node);
            this.adjust(newLevel);
        }
        if (OptionVal$.MODULE$.isDefined$extension(this.clock)) {
            node.timestamp_$eq(OptionVal$.MODULE$.get$extension(this.clock).currentTime());
            this.overallRecency().moveToBack(node);
            return;
        }
    }

    private void demote(Node<A> node) {
        this.removeFromCurrentLevel(node);
        this.appendTo(node.level() - 1, node);
    }

    private void appendTo(int level, Node<A> node) {
        node.level_$eq(level);
        ((DoubleLinkedList)this.segments().apply(level)).append(node);
        this.sizes().update(level, BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(this.sizes().apply(level)) + 1));
    }

    private void removeFromCurrentLevel(Node<A> node) {
        ((DoubleLinkedList)this.segments().apply(node.level())).remove(node);
        int n = node.level();
        this.sizes().update(n, BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(this.sizes().apply(n)) - 1));
    }

    private A removeNode(Node<A> node) {
        A value = node.value();
        this.removeFromCurrentLevel(node);
        if (OptionVal$.MODULE$.isDefined$extension(this.clock)) {
            this.overallRecency().remove(node);
        }
        this.lookupNode().$minus$eq(value);
        return value;
    }

    public static final /* synthetic */ boolean $anonfun$removeOverallLeastRecentOutside$1(long min$1, Node x$6) {
        return x$6.timestamp() < min$1;
    }

    public SegmentedRecencyList(scala.collection.immutable.Seq<Object> initialLimits, RecencyList.Clock clock) {
        this.clock = clock;
        this.limits = initialLimits.toIndexedSeq();
        this.totalLimit = BoxesRunTime.unboxToInt(this.limits().sum(Numeric$IntIsIntegral$.MODULE$));
        this.levels = this.limits().size();
        this.lowest = 0;
        this.highest = this.levels() - 1;
        this.segments = (scala.collection.IndexedSeq)package$.MODULE$.IndexedSeq().fill(this.levels(), (Function0<DoubleLinkedList> & Serializable & scala.Serializable)() -> new DoubleLinkedList((Function1<Node, Object> & Serializable & scala.Serializable)x$1 -> new OptionVal<Node>(x$1.lessRecent()), (Function1<Node, Object> & Serializable & scala.Serializable)x$2 -> new OptionVal<Node>(x$2.moreRecent()), (Function2<Node, Object, Object> & Serializable & scala.Serializable)(node, previous) -> {
            node.lessRecent_$eq((Node)((OptionVal)previous).x());
            return BoxedUnit.UNIT;
        }, (Function2<Node, Object, Object> & Serializable & scala.Serializable)(node, next) -> {
            node.moreRecent_$eq((Node)((OptionVal)next).x());
            return BoxedUnit.UNIT;
        }));
        this.sizes = (IndexedSeq)IndexedSeq$.MODULE$.fill(this.levels(), (JFunction0$mcI$sp & scala.Serializable)() -> 0);
        this.overallRecency = new DoubleLinkedList((Function1<Node, Object> & Serializable & scala.Serializable)x$3 -> new OptionVal<Node>(x$3.overallLessRecent()), (Function1<Node, Object> & Serializable & scala.Serializable)x$4 -> new OptionVal<Node>(x$4.overallMoreRecent()), (Function2<Node, Object, Object> & Serializable & scala.Serializable)(node, previous) -> {
            node.overallLessRecent_$eq((Node)((OptionVal)previous).x());
            return BoxedUnit.UNIT;
        }, (Function2<Node, Object, Object> & Serializable & scala.Serializable)(node, next) -> {
            node.overallMoreRecent_$eq((Node)((OptionVal)next).x());
            return BoxedUnit.UNIT;
        });
        this.lookupNode = Map$.MODULE$.empty();
    }

    private static final class Node<A> {
        private final A value;
        private int level;
        private long timestamp;
        private Node<A> lessRecent;
        private Node<A> moreRecent;
        private Node<A> overallLessRecent;
        private Node<A> overallMoreRecent;

        public A value() {
            return this.value;
        }

        public int level() {
            return this.level;
        }

        public void level_$eq(int x$1) {
            this.level = x$1;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public void timestamp_$eq(long x$1) {
            this.timestamp = x$1;
        }

        public Node<A> lessRecent() {
            return this.lessRecent;
        }

        public void lessRecent_$eq(Node<A> x$1) {
            this.lessRecent = x$1;
        }

        public Node<A> moreRecent() {
            return this.moreRecent;
        }

        public void moreRecent_$eq(Node<A> x$1) {
            this.moreRecent = x$1;
        }

        public Node<A> overallLessRecent() {
            return this.overallLessRecent;
        }

        public void overallLessRecent_$eq(Node<A> x$1) {
            this.overallLessRecent = x$1;
        }

        public Node<A> overallMoreRecent() {
            return this.overallMoreRecent;
        }

        public void overallMoreRecent_$eq(Node<A> x$1) {
            this.overallMoreRecent = x$1;
        }

        public Node(A value) {
            this.value = value;
            this.level = 0;
            this.timestamp = 0L;
            OptionVal$.MODULE$.None();
            this.lessRecent = null;
            OptionVal$.MODULE$.None();
            this.moreRecent = null;
            OptionVal$.MODULE$.None();
            this.overallLessRecent = null;
            OptionVal$.MODULE$.None();
            this.overallMoreRecent = null;
        }
    }
}

