/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.parquet.vector.reader.TimestampColumnReader;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.DateTimeUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.DoubleStatistics;
import org.apache.parquet.column.statistics.FloatStatistics;
import org.apache.parquet.column.statistics.IntStatistics;
import org.apache.parquet.column.statistics.LongStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetFormatStatisticsReportUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetFormatStatisticsReportUtil.class);

    public static TableStats getTableStatistics(List<Path> files, DataType producedDataType, Configuration hadoopConfig, boolean isUtcTimestamp) {
        return ParquetFormatStatisticsReportUtil.getTableStatistics(files, producedDataType, hadoopConfig, isUtcTimestamp, Runtime.getRuntime().availableProcessors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableStats getTableStatistics(List<Path> files, DataType producedDataType, Configuration hadoopConfig, boolean isUtcTimestamp, int statisticsThreadNum) {
        ExecutorService executorService = null;
        try {
            HashMap columnStatisticsMap = new HashMap();
            RowType producedRowType = (RowType)producedDataType.getLogicalType();
            executorService = Executors.newFixedThreadPool(statisticsThreadNum, (ThreadFactory)new ExecutorThreadFactory("parquet-get-table-statistic-worker"));
            long rowCount = 0L;
            ArrayList<Future<FileParquetStatistics>> fileRowCountFutures = new ArrayList<Future<FileParquetStatistics>>();
            for (Path tableStats : files) {
                fileRowCountFutures.add(executorService.submit(new ParquetFileRowCountCalculator(hadoopConfig, tableStats, columnStatisticsMap)));
            }
            for (Future future : fileRowCountFutures) {
                FileParquetStatistics fileStatistics = (FileParquetStatistics)future.get();
                List<String> columns = fileStatistics.getColumns();
                List<BlockMetaData> blocks = fileStatistics.blocks;
                for (BlockMetaData block : blocks) {
                    rowCount += block.getRowCount();
                    for (int i = 0; i < columns.size(); ++i) {
                        ParquetFormatStatisticsReportUtil.updateStatistics(((ColumnChunkMetaData)block.getColumns().get(i)).getStatistics(), columns.get(i), columnStatisticsMap);
                    }
                }
            }
            Map<String, ColumnStats> columnStatsMap = ParquetFormatStatisticsReportUtil.convertToColumnStats(columnStatisticsMap, producedRowType, isUtcTimestamp);
            TableStats tableStats = new TableStats(rowCount, columnStatsMap);
            return tableStats;
        }
        catch (Exception e) {
            LOG.warn("Reporting statistics failed for Parquet format", (Throwable)e);
            TableStats tableStats = TableStats.UNKNOWN;
            return tableStats;
        }
        finally {
            if (executorService != null) {
                executorService.shutdownNow();
            }
        }
    }

    private static void updateStatistics(Statistics<?> statistics, String column, Map<String, Statistics<?>> columnStatisticsMap) {
        Statistics<?> previousStatistics = columnStatisticsMap.get(column);
        if (previousStatistics == null) {
            columnStatisticsMap.put(column, statistics);
        } else {
            previousStatistics.mergeStatistics(statistics);
        }
    }

    private static Map<String, ColumnStats> convertToColumnStats(Map<String, Statistics<?>> columnStatisticsMap, RowType producedRowType, boolean isUtcTimestamp) {
        HashMap<String, ColumnStats> columnStatMap = new HashMap<String, ColumnStats>();
        for (String column : producedRowType.getFieldNames()) {
            Statistics<?> statistics = columnStatisticsMap.get(column);
            if (statistics == null) continue;
            ColumnStats columnStats = ParquetFormatStatisticsReportUtil.convertToColumnStats(producedRowType.getTypeAt(producedRowType.getFieldIndex(column)), statistics, isUtcTimestamp);
            columnStatMap.put(column, columnStats);
        }
        return columnStatMap;
    }

    private static ColumnStats convertToColumnStats(LogicalType logicalType, Statistics<?> statistics, boolean isUtcTimestamp) {
        ColumnStats.Builder builder = new ColumnStats.Builder().setNullCount(Long.valueOf(statistics.getNumNulls()));
        switch (logicalType.getTypeRoot()) {
            case BOOLEAN: 
            case BINARY: 
            case VARBINARY: {
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                if (statistics instanceof IntStatistics) {
                    builder.setMin((Comparable)Integer.valueOf(((IntStatistics)statistics).getMin())).setMax((Comparable)Integer.valueOf(((IntStatistics)statistics).getMax()));
                    break;
                }
                if (statistics instanceof LongStatistics) {
                    builder.setMin((Comparable)Long.valueOf(((LongStatistics)statistics).getMin())).setMax((Comparable)Long.valueOf(((LongStatistics)statistics).getMax()));
                    break;
                }
                return null;
            }
            case DOUBLE: {
                if (statistics instanceof DoubleStatistics) {
                    builder.setMin((Comparable)Double.valueOf(((DoubleStatistics)statistics).getMin())).setMax((Comparable)Double.valueOf(((DoubleStatistics)statistics).getMax()));
                    break;
                }
                return null;
            }
            case FLOAT: {
                if (statistics instanceof FloatStatistics) {
                    builder.setMin((Comparable)Float.valueOf(((FloatStatistics)statistics).getMin())).setMax((Comparable)Float.valueOf(((FloatStatistics)statistics).getMax()));
                    break;
                }
                return null;
            }
            case DATE: {
                if (statistics instanceof IntStatistics) {
                    Date min = Date.valueOf(DateTimeUtils.formatDate((int)((IntStatistics)statistics).getMin()));
                    Date max = Date.valueOf(DateTimeUtils.formatDate((int)((IntStatistics)statistics).getMax()));
                    builder.setMin((Comparable)min).setMax((Comparable)max);
                    break;
                }
                return null;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                if (statistics instanceof IntStatistics) {
                    Time min = Time.valueOf(DateTimeUtils.toLocalTime((int)((IntStatistics)statistics).getMin()));
                    Time max = Time.valueOf(DateTimeUtils.toLocalTime((int)((IntStatistics)statistics).getMax()));
                    builder.setMin((Comparable)min).setMax((Comparable)max);
                    break;
                }
                return null;
            }
            case CHAR: 
            case VARCHAR: {
                if (statistics instanceof BinaryStatistics) {
                    Binary min = ((BinaryStatistics)statistics).genericGetMin();
                    Binary max = ((BinaryStatistics)statistics).genericGetMax();
                    if (min != null) {
                        builder.setMin((Comparable)((Object)min.toStringUsingUTF8()));
                    } else {
                        builder.setMin(null);
                    }
                    if (max != null) {
                        builder.setMax((Comparable)((Object)max.toStringUsingUTF8()));
                        break;
                    }
                    builder.setMax(null);
                    break;
                }
                return null;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case TIMESTAMP_WITH_TIME_ZONE: {
                if (statistics instanceof LongStatistics) {
                    builder.setMin((Comparable)new Timestamp(((LongStatistics)statistics).getMin())).setMax((Comparable)new Timestamp(((LongStatistics)statistics).getMax()));
                    break;
                }
                if (statistics instanceof BinaryStatistics) {
                    Binary min = ((BinaryStatistics)statistics).genericGetMin();
                    Binary max = ((BinaryStatistics)statistics).genericGetMax();
                    if (min != null) {
                        builder.setMin((Comparable)ParquetFormatStatisticsReportUtil.binaryToTimestamp(min, isUtcTimestamp));
                    } else {
                        builder.setMin(null);
                    }
                    if (max != null) {
                        builder.setMax((Comparable)ParquetFormatStatisticsReportUtil.binaryToTimestamp(max, isUtcTimestamp));
                        break;
                    }
                    builder.setMax(null);
                    break;
                }
                return null;
            }
            case DECIMAL: {
                if (statistics instanceof IntStatistics) {
                    builder.setMin((Comparable)BigDecimal.valueOf(((IntStatistics)statistics).getMin())).setMax((Comparable)BigDecimal.valueOf(((IntStatistics)statistics).getMax()));
                    break;
                }
                if (statistics instanceof LongStatistics) {
                    builder.setMin((Comparable)BigDecimal.valueOf(((LongStatistics)statistics).getMin())).setMax((Comparable)BigDecimal.valueOf(((LongStatistics)statistics).getMax()));
                    break;
                }
                if (statistics instanceof BinaryStatistics) {
                    Binary min = ((BinaryStatistics)statistics).genericGetMin();
                    Binary max = ((BinaryStatistics)statistics).genericGetMax();
                    if (min != null) {
                        builder.setMin((Comparable)ParquetFormatStatisticsReportUtil.binaryToDecimal(min, ((DecimalType)logicalType).getScale()));
                    } else {
                        builder.setMin(null);
                    }
                    if (max != null) {
                        builder.setMax((Comparable)ParquetFormatStatisticsReportUtil.binaryToDecimal(max, ((DecimalType)logicalType).getScale()));
                        break;
                    }
                    builder.setMax(null);
                    break;
                }
                return null;
            }
            default: {
                return null;
            }
        }
        return builder.build();
    }

    private static BigDecimal binaryToDecimal(Binary decimal, int scale) {
        BigInteger bigInteger = new BigInteger(decimal.getBytesUnsafe());
        return new BigDecimal(bigInteger, scale);
    }

    private static Timestamp binaryToTimestamp(Binary timestamp, boolean utcTimestamp) {
        Preconditions.checkArgument((timestamp.length() == 12 ? 1 : 0) != 0, (Object)"Must be 12 bytes");
        ByteBuffer buf = timestamp.toByteBuffer();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        long timeOfDayNanos = buf.getLong();
        int julianDay = buf.getInt();
        TimestampData timestampData = TimestampColumnReader.int96ToTimestamp(utcTimestamp, timeOfDayNanos, julianDay);
        return timestampData.toTimestamp();
    }

    private static class ParquetFileRowCountCalculator
    implements Callable<FileParquetStatistics> {
        private final Configuration hadoopConfig;
        private final Path file;

        public ParquetFileRowCountCalculator(Configuration hadoopConfig, Path file, Map<String, Statistics<?>> columnStatisticsMap) {
            this.hadoopConfig = hadoopConfig;
            this.file = file;
        }

        @Override
        public FileParquetStatistics call() throws Exception {
            org.apache.hadoop.fs.Path hadoopPath = new org.apache.hadoop.fs.Path(this.file.toUri());
            ParquetMetadata metadata = ParquetFileReader.readFooter((Configuration)this.hadoopConfig, (org.apache.hadoop.fs.Path)hadoopPath);
            MessageType schema = metadata.getFileMetaData().getSchema();
            List<String> columns = schema.asGroupType().getFields().stream().map(Type::getName).collect(Collectors.toList());
            List blocks = metadata.getBlocks();
            return new FileParquetStatistics(columns, blocks);
        }
    }

    private static class FileParquetStatistics {
        private final List<String> columns;
        private final List<BlockMetaData> blocks;

        public FileParquetStatistics(List<String> columns, List<BlockMetaData> blocks) {
            this.columns = columns;
            this.blocks = blocks;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public List<BlockMetaData> getBlocks() {
            return this.blocks;
        }
    }
}

